<?php
session_start();
require 'conexao.php';

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Definir o usuário atual
$user_name = $_SESSION['user_name'];

// --- LÓGICA PHP MANTIDA INTACTA ---

// Processar ação de apagar notificação
if (isset($_GET['apagar'])) {
    $id_notificacao = (int)$_GET['apagar'];
    $sqlApagar = "UPDATE notificacoes_sis SET apg = 1 WHERE id = :id AND user2 = :user_name";
    $stmtApagar = $pdo->prepare($sqlApagar);
    $stmtApagar->bindParam(':id', $id_notificacao, PDO::PARAM_INT);
    $stmtApagar->bindParam(':user_name', $user_name, PDO::PARAM_STR);
    $stmtApagar->execute();
    
    echo '<script>window.location.href = window.location.pathname;</script>';
    exit();
}

// Paginação
$registros_por_pagina = 10;
$pagina_atual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;

// Contar total
$sqlCount = "SELECT COUNT(*) FROM notificacoes_sis WHERE user2 = :user_name AND apg != 1";
$stmtCount = $pdo->prepare($sqlCount);
$stmtCount->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmtCount->execute();
$total_notificacoes = $stmtCount->fetchColumn();

$total_paginas = ceil($total_notificacoes / $registros_por_pagina);
$offset = ($pagina_atual - 1) * $registros_por_pagina;

// Consulta
$sql = "SELECT * FROM notificacoes_sis 
        WHERE user2 = :user_name AND apg != 1 
        ORDER BY dataehora DESC 
        LIMIT :offset, :limit";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
$stmt->bindParam(':limit', $registros_por_pagina, PDO::PARAM_INT);
$stmt->execute();

// Marcar como lido (vz2 = 1)
$sqlUpdateVz2 = "UPDATE notificacoes_sis SET vz2 = 1 WHERE user2 = :user_name AND apg != 1";
$stmtUpdateVz2 = $pdo->prepare($sqlUpdateVz2);
$stmtUpdateVz2->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmtUpdateVz2->execute();
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notificações - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/dashboard.css">
</head>
<body>
    <div class="light-rays"></div>

    <div class="container"> 
        
        <div class="card" style="margin-top: 30px;">
              <center>
            <div class="listing-header-centered">
              <h1 class=""><font color="blue"><b>RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder</b></font></h1><br>
            
                
                <div class="btn-group btn-container-center">
                    <a href="dashboard.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                    </a>
                </div>

    <h1 class=""><font color=""><b>Página de Notificações</b></font></h1>

                <p class="listing-intro">Encontre aqui todas as notificações do jogador.</p> <br><hr><br>
            </div>
            <div class="notification-list-container">
                <?php
                if ($stmt->rowCount() > 0) {
                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                        // Define se é lida ou não lida para o CSS (SUA LÓGICA MANTIDA)
                        $classe_estado = ($row['vz2'] == 0) ? 'notificacao-nao-lida' : 'notificacao-lida';
                        $data_formatada = date('d/m/Y H:i', strtotime($row['dataehora']));
                        ?>
                        
                        <div class="notificacao-item <?php echo $classe_estado; ?>" onclick="apagarNotificacao(<?php echo $row['id']; ?>)">
                            <div class="noti-header">
                                <span class="noti-type"><?php echo htmlspecialchars($row['tipo']); ?></span>
                                <span class="noti-date"><?php echo $data_formatada; ?></span>
                            </div>
                            <div class="noti-body">
                                <?php echo nl2br(htmlspecialchars($row['notificacao'])); ?>
                            </div>
                        </div>

                        <?php
                    }
                    ?>

                    <div class="pagination-neon">
                        <?php
                        for ($i = 1; $i <= $total_paginas; $i++) {
                            if ($i == $pagina_atual) {
                                echo '<a href="?pagina='.$i.'" class="active">'.$i.'</a>';
                            } else {
                                echo '<a href="?pagina='.$i.'">'.$i.'</a>';
                            }
                        }
                        ?>
                    </div>

                    <?php
                } else {
                    echo '<div class="no-news" style="font-size: 1.2rem; margin-top: 30px; text-align: center; color: #ccc;">Nenhuma notificação encontrada no momento.</div>';
                }
                ?>
            </div> 
        </div> 
        <br>
        <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> <script>
    function apagarNotificacao(id) {
        if (confirm("Tem certeza que deseja apagar esta notificação do histórico?")) {
            window.location.href = '?apagar=' + id;
        }
    }
    </script>
</body>
</html>