<?php
session_start();
require 'conexao.php';

// Estilos para facilitar a leitura dos dados
echo '<style>
    body { background: #111; color: #eee; font-family: Consolas, monospace; padding: 20px; }
    .box { background: #222; border: 1px solid #444; padding: 15px; margin-bottom: 15px; border-radius: 5px; }
    .title { color: #00f3ff; font-size: 1.2em; border-bottom: 1px solid #444; padding-bottom: 5px; margin-bottom: 10px; }
    .label { color: #888; min-width: 150px; display: inline-block; }
    .value { color: #fff; font-weight: bold; }
    .highlight { color: #ffd700; }
    .ok { color: #0f0; }
    .error { color: #f00; font-weight: bold; }
    .card-dir { border-left: 3px solid #555; padding-left: 10px; margin: 10px 0; background: rgba(255,255,255,0.05); padding: 10px; }
    .btn { display: inline-block; padding: 10px 20px; background: #00f3ff; color: #000; text-decoration: none; font-weight: bold; margin-top: 20px; }
</style>';

echo "<h1>🛠️ DIAGNÓSTICO DE MAPA E REGIÃO</h1>";

if (!isset($_SESSION['personagem'])) {
    die("Erro: Logue e selecione um personagem.");
}

try {
    // 1. DADOS DO PERSONAGEM (Onde ele diz que está?)
    echo "<div class='box'>";
    echo "<div class='title'>1. Personagem</div>";
    
    $stmt = $pdo->prepare("SELECT id, personagem, local FROM personagens WHERE id = :id");
    $stmt->execute([':id' => $_SESSION['personagem']]);
    $char = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($char) {
        echo "<span class='label'>Nome:</span> <span class='value'>{$char['personagem']}</span><br>";
        echo "<span class='label'>Local Atual (Banco):</span> <span class='value highlight'>[ {$char['local']} ]</span><br>";
    } else {
        die("Personagem não encontrado.");
    }
    echo "</div>";

    // 2. DADOS DO LOCAL ATUAL (Para descobrir a Região e os Vizinhos)
    echo "<div class='box'>";
    echo "<div class='title'>2. Dados do Quadrado Atual (Tabela mapasmed)</div>";
    
    $stmt = $pdo->prepare("SELECT * FROM mapasmed WHERE nome = :nome LIMIT 1");
    $stmt->execute([':nome' => $char['local']]);
    $mapa_atual = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $regiao_detectada = ""; // Vamos guardar isso para usar na busca dos vizinhos

    if ($mapa_atual) {
        $regiao_detectada = $mapa_atual['regiao'];
        
        echo "<span class='label'>Nome do Local:</span> <span class='value'>{$mapa_atual['nome']}</span><br>";
        echo "<span class='label'>ID (PK):</span> <span class='value'>{$mapa_atual['id']}</span><br>";
        echo "<span class='label'>ID2 (Lógico):</span> <span class='value highlight'>{$mapa_atual['id2']}</span><br>";
        echo "<span class='label'>REGIÃO (Cidade):</span> <span class='value highlight' style='font-size:1.2em; color:#00f3ff'>[ $regiao_detectada ]</span><br>";
        echo "<br><em>Nota: Todos os vizinhos abaixo serão buscados usando esta Região.</em>";
    } else {
        echo "<div class='error'>ERRO CRÍTICO: O local '{$char['local']}' não existe na tabela mapasmed!</div>";
        echo "O sistema não consegue saber a região nem os vizinhos.";
        exit;
    }
    echo "</div>";

    // 3. LISTAGEM E TESTE DOS VIZINHOS
    echo "<div class='box'>";
    echo "<div class='title'>3. Teste de Conexões (Vizinhos)</div>";
    
    $direcoes = [
        'NORTE (n)' => $mapa_atual['n'],
        'SUL (s)'   => $mapa_atual['s'],
        'LESTE (l)' => $mapa_atual['l'],
        'OESTE (o)' => $mapa_atual['o']
    ];

    foreach ($direcoes as $nome_dir => $id2_alvo) {
        echo "<div class='card-dir'>";
        echo "<strong>DIREÇÃO: $nome_dir</strong><br>";
        
        if (empty($id2_alvo)) {
            echo "<span class='error'>[ X ] Bloqueado / Fim de Mapa (Campo vazio ou 0)</span>";
        } else {
            echo "<span class='label'>Aponta para ID2:</span> <span class='value'>$id2_alvo</span><br>";
            echo "<span class='label'>Filtro de Região:</span> <span class='value'>$regiao_detectada</span><br>";
            
            // TENTA ACHAR O VIZINHO NO BANCO
            // Query: Procura alguém com esse ID2 E com a MESMA REGIÃO
            $sqlVizinho = "SELECT id, nome, regiao, id2 FROM mapasmed WHERE id2 = :id2 AND regiao = :regiao LIMIT 1";
            $stmtV = $pdo->prepare($sqlVizinho);
            $stmtV->execute([
                ':id2' => $id2_alvo,
                ':regiao' => $regiao_detectada
            ]);
            $vizinho = $stmtV->fetch(PDO::FETCH_ASSOC);
            
            echo "<div style='margin-top:5px; padding:5px; background:#000; border:1px dashed #444'>";
            if ($vizinho) {
                echo "<span class='ok'>[ OK ] Caminho Válido!</span><br>";
                echo "<span class='label'>Nome Encontrado:</span> <span class='value highlight'>{$vizinho['nome']}</span><br>";
                echo "<span class='label'>Confirmação:</span> ID2: {$vizinho['id2']} | Região: {$vizinho['regiao']}";
            } else {
                echo "<span class='error'>[ ERRO ] Destino Inexistente!</span><br>";
                echo "O sistema procurou por <strong>ID2=$id2_alvo</strong> na região <strong>'$regiao_detectada'</strong> e não achou nada.<br>";
                echo "Verifique se o quadrado vizinho está cadastrado com a região correta.";
            }
            echo "</div>";
        }
        echo "</div>";
    }
    echo "</div>";
    
} catch (PDOException $e) {
    echo "<div class='error'>Erro de Banco de Dados: " . $e->getMessage() . "</div>";
}


// --- INÍCIO DO CÓDIGO DE BLOQUEIO (PARALISIA E TEMPO) ---
// --- INÍCIO DO CÓDIGO DE BLOQUEIO (CORRIGIDO) ---

    // 1. DEFINIÇÃO DA VARIÁVEL (Isso corrige o erro da linha 123)
    $personagem_id = $_SESSION['personagem']; 

    // 2. BUSCA OS DADOS DE TEMPO
    $stmtCheck = $pdo->prepare("SELECT paralisado, movido FROM personagens WHERE id = :id");
    $stmtCheck->execute([':id' => $personagem_id]);
    $dadosTempo = $stmtCheck->fetch(PDO::FETCH_ASSOC);

    $agora = date('Y-m-d H:i:s'); // Horário atual

    // REGRA 1: Verifica se está PARALISADO
    if (!empty($dadosTempo['paralisado']) && $dadosTempo['paralisado'] > $agora) {
        $dataParaTerminar = date('H:i:s', strtotime($dadosTempo['paralisado']));
        $_SESSION['msg'] = "Você está paralisado até às $dataParaTerminar!";
        header("Location: dashboardmed.php");
        exit;
    }

    // REGRA 2: Verifica o COOLDOWN (15 Segundos)
    if (!empty($dadosTempo['movido'])) {
        $tempoUltimoMovimento = strtotime($dadosTempo['movido']);
        $tempoAtual = time(); 
        $diferenca = $tempoAtual - $tempoUltimoMovimento;

        if ($diferenca < 15) {
            $segundosRestantes = 15 - $diferenca;
            $_SESSION['msg'] = "Descanse! Aguarde $segundosRestantes segundos para andar novamente.";
            header("Location: dashboardmed.php");
            exit;
        }
    }

    // --- FIM DO BLOQUEIO ---
    // --- FIM DO CÓDIGO DE BLOQUEIO ---

// --- INÍCIO DO CÓDIGO DE ATUALIZAÇÃO MANUAL ---

    // 1. Define a Região (Pega da sessão ou define 'Dervian' como padrão)
    if (!isset($_SESSION['regiao']) || empty($_SESSION['regiao'])) {
        $_SESSION['regiao'] = 'Dervian'; // Cria a sessão se não existir
    }
    $regiao_atual = $_SESSION['regiao'];

    // 2. Pega o ID2 que veio do botão
    $id2_alvo = $_POST['direcao'];

    // 3. Busca o NOME do local na tabela mapasmed
    // Lógica: "Qual é o nome do lugar que tem este id2 NESTA região?"
    $stmtBusca = $pdo->prepare("SELECT nome FROM mapasmed WHERE id2 = :id AND regiao = :regiao LIMIT 1");
    $stmtBusca->execute([
        ':id' => $id2_alvo,
        ':regiao' => $regiao_atual
    ]);
    $destino_encontrado = $stmtBusca->fetch(PDO::FETCH_ASSOC);

    if ($destino_encontrado) {
        $nome_novo_local = $destino_encontrado['nome'];

      // --- CÓDIGO DE ATUALIZAÇÃO COM REGISTRO DE TEMPO ---
        
        // Atualiza o Local E a data de 'movido' para agora
        $stmtUpdate = $pdo->prepare("UPDATE personagens SET local = :novo_local, movido = :agora WHERE id = :id_pers");
        $stmtUpdate->execute([
            ':novo_local' => $nome_novo_local,
            ':agora'      => date('Y-m-d H:i:s'), // Grava o momento exato do movimento
            ':id_pers'    => $_SESSION['personagem']
        ]);

        // Atualiza a sessão para o jogo não precisar de relogin
        $_SESSION['local'] = $nome_novo_local;

        // 5. Mensagem de Sucesso (Texto exato que você pediu)
        echo "Personagem " . $_SESSION['personagem_nome'] . " enviado para " . $nome_novo_local . " com sucesso";
        
        // Opcional: Se quiser redirecionar depois de mostrar a mensagem, descomente a linha abaixo:
         header("Refresh: 2; url=dashboardmed.php"); 
        exit;

    } else {
        die("Erro Crítico: Não foi possível encontrar um local com ID2: $id2_alvo na região: $regiao_atual.");
    }

    // --- FIM DO CÓDIGO DE ATUALIZAÇÃO MANUAL ---


echo "<a href='dashboardmed.php' class='btn'>Voltar</a>";
?>