<?php
session_start();
// Ajuste o caminho para o conexao.php se necessário
require '../conexao.php';

// Configurações de erro (mantidas do seu código)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador_atual = $_SESSION['user_name'];
$user_id = $_SESSION['user_id'];

// --- LÓGICA PHP MANTIDA INTACTA ---

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jogador_destino = trim($_POST['jogador_destino']);
    $quantidade = (int)$_POST['quantidade'];
    $pin = $_POST['pin'];
    
    if (empty($jogador_destino) || $quantidade <= 0 || empty($pin)) {
        $_SESSION['msg'] = "Preencha todos os campos corretamente!";
        $_SESSION['msg_type'] = 'error'; // Define o tipo de mensagem
        header("Location: transferir_fichas.php");
        exit();
    }

    // Verifica se o PIN existe na sessão antes de comparar
    if (!isset($_SESSION['user_pin']) || !password_verify($pin, $_SESSION['user_pin'])) {
        $_SESSION['msg'] = "PIN incorreto!";
        $_SESSION['msg_type'] = 'error';
        header("Location: transferir_fichas.php");
        exit();
    }

    try {
        $stmt = $pdo->prepare("SELECT user FROM usersblock WHERE user = ?");
        $stmt->execute([$jogador_destino]);
        if ($stmt->rowCount() === 0) {
            $_SESSION['msg'] = "Jogador destino não encontrado!";
            $_SESSION['msg_type'] = 'error';
            header("Location: transferir_fichas.php");
            exit();
        }
    } catch (PDOException $e) {
        $_SESSION['msg'] = "Erro ao verificar jogador: " . $e->getMessage();
        $_SESSION['msg_type'] = 'error';
        header("Location: transferir_fichas.php");
        exit();
    }

    try {
        $pdo->beginTransaction();

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
        $stmt->execute([$jogador_atual]);
        $fichas_disponiveis = $stmt->fetchColumn();

        if ($fichas_disponiveis < $quantidade) {
            $pdo->rollBack();
            $_SESSION['msg'] = "Você só tem $fichas_disponiveis fichas disponíveis!";
            $_SESSION['msg_type'] = 'error';
            header("Location: transferir_fichas.php");
            exit();
        }

        // Usa diretamente o valor de $quantidade no SQL
        $limite = intval($quantidade);
        $sql_transferencia = "UPDATE fichaspersonagens 
                             SET jogador = ? 
                             WHERE jogador = ? AND situacao = '1' 
                             LIMIT $limite";
        $stmt = $pdo->prepare($sql_transferencia);
        $stmt->execute([$jogador_destino, $jogador_atual]);

        $stmt = $pdo->query("SELECT MAX(chave) FROM transferencias");
        $ultima_chave = $stmt->fetchColumn();
        $nova_chave = $ultima_chave ? $ultima_chave + 1 : 1;

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM transferencias WHERE chave = ?");
        $stmt->execute([$nova_chave]);
        if ($stmt->fetchColumn() > 0) {
            $nova_chave = $pdo->query("SELECT MAX(chave)+1 FROM transferencias")->fetchColumn();
        }

        $info_transferencia = "$quantidade fichas transferidas";

        $sql_insert = "INSERT INTO transferencias 
                      (tipo, transferiu, recebeu, informacoes, chave, val) 
                      VALUES 
                      ('ficha', ?, ?, ?, ?, 1)";
        $stmt = $pdo->prepare($sql_insert);
        $stmt->execute([$jogador_atual, $jogador_destino, $info_transferencia, $nova_chave]);

        $info_sistema = "O usuário $jogador_atual transferiu $quantidade fichas para o jogador $jogador_destino";
        $sql_info = "INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
                    VALUES (?, ?, ?, 'transferencia ficha', NOW())";
        $stmt = $pdo->prepare($sql_info);
        $stmt->execute([$info_sistema, $jogador_atual, $jogador_destino]);

        $pdo->commit();

        // Mensagem de sucesso com nome em destaque azul (usando a classe criada anteriormente)
        $_SESSION['msg'] = "Transferência de $quantidade fichas para <span class='highlight-neon-blue'>$jogador_destino</span> realizada com sucesso!";
        $_SESSION['msg_type'] = 'success';
        header("Location: transferir_fichas.php");
        exit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro na transferência: " . $e->getMessage();
        $_SESSION['msg_type'] = 'error';
        header("Location: transferir_fichas.php");
        exit();
    }
}

try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
    $stmt->execute([$jogador_atual]);
    $total_fichas = $stmt->fetchColumn();
} catch (PDOException $e) {
    $total_fichas = 0;
    $_SESSION['msg'] = "Erro ao consultar fichas: " . $e->getMessage();
    $_SESSION['msg_type'] = 'error';
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transferência de Fichas - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
    </head>
<body>
    <div class="light-rays"></div>

    <div class="container"> 
        
        <div class="card" style="margin-top: 30px; margin-bottom: 50px;">
            
            <div class="listing-header-centered">
                <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); margin-bottom: 25px; font-size: 2rem;">
                    RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder
                </h1>
                
                <div class="btn-group btn-container-center" style="margin-bottom: 25px;">
                    <center>
                    <a href="../admpersonagens.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Administração de Fichas & Personagens</button>
                    </a><br>
                    <a href="../dashboard.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                    </a>
                    </center>
                </div>

                <h2 style="color: white; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 15px;">
                    Transferência de Fichas
                </h2>

                <p class="listing-intro">
                    Envie suas fichas disponíveis para outros jogadores. Esta operação requer seu PIN de segurança.
                </p>
            </div>
            <?php if (isset($_SESSION['msg'])): ?>
                <div class="message-neon <?= (isset($_SESSION['msg_type']) && $_SESSION['msg_type'] == 'success') ? 'success' : 'error' ?>">
                    <?= $_SESSION['msg'] ?>
                </div>
                <?php 
                    unset($_SESSION['msg']); 
                    unset($_SESSION['msg_type']);
                ?>
            <?php endif; ?>

            <div class="fichas-counter" id="contador-fichas">
                Suas fichas disponíveis para transferência:<br>
                <span class="highlight-neon"><?= $total_fichas ?> fichas</span>
            </div>

            <div class="form-stack-container">
                <form method="POST">
                    
                    <div>
                        
                        <label for="jogador_destino"><CENTER>Nome do Jogador Destino</label>
                       <CENTER> <input type="text" id="jogador_destino" name="jogador_destino" required 
                               placeholder="Digite o nome do jogador...">
                    </div>
                    
                    <div>
                        <label for="quantidade"><CENTER>Quantidade de Fichas:</label>
                        <input type="number" id="quantidade" name="quantidade" min="1" max="<?= $total_fichas ?>" required
                               placeholder="Digite a quantidade..." style="width: 100%; padding: 15px; background-color: rgba(0, 0, 20, 0.8); border: 2px solid var(--primary); border-radius: 8px; color: var(--light-text); font-size: 1.1rem; box-shadow: 0 0 5px rgba(0, 0, 255, 0.3); outline: none; transition: all 0.3s ease; text-align: center;">
                    </div>
                    
                    <div>
                        <label for="pin"><CENTER>Código PIN (4 dígitos):</label>
                        <input type="password" id="pin" name="pin" maxlength="4" required
                               placeholder="Digite seu PIN..." style="width: 100%; padding: 15px; background-color: rgba(0, 0, 20, 0.8); border: 2px solid var(--primary); border-radius: 8px; color: var(--light-text); font-size: 1.1rem; box-shadow: 0 0 5px rgba(0, 0, 255, 0.3); outline: none; transition: all 0.3s ease; text-align: center;">
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <button type="submit" class="btn-transferir-neon" onclick="return confirm('ATENÇÃO: Confirma a transferência dessas fichas? Esta ação é irreversível.');">
                            REALIZAR TRANSFERÊNCIA
                        </button>
                    </div>
                </form>
            </div>
            </div> <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> </body>
</html>