<?php
session_start();
require 'conexao.php';

// 1. Verificação de Acesso
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// 2. Inicialização de Variáveis
$msgsis2 = $_SESSION['msg2'] ?? '';
$user_id = $_SESSION['user_name'];

// Preços
$precomadeira = 27; $_SESSION['precomadeira'] = $precomadeira;
$precocarne = 36; $_SESSION['precocarne'] = $precocarne;

$total_notificacoes = 0;
$personagemAtivo = null; 
$messages = [];
$situacao = 'Nenhum'; 
$local = '';
$paralisado = date('Y-m-d H:i:s'); 
$tipolocal = 'city'; 
$norte = ''; $leste = ''; $sul = ''; $oeste = ''; 
$horarioAtual = date('Y-m-d H:i:s');
$hp_atual = 100; $hp_max = 100; 
$row = []; 

// 3. Notificações
$sqlCountNotificacoes = "SELECT COUNT(*) AS total_notificacoes FROM notificacoes_jogo WHERE user2 = :user_name AND vz2 = 0";
$stmtCountNotificacoes = $pdo->prepare($sqlCountNotificacoes);
$stmtCountNotificacoes->bindParam(':user_name', $user_id, PDO::PARAM_STR);
$stmtCountNotificacoes->execute();
$total_notificacoes = $stmtCountNotificacoes->fetch(PDO::FETCH_ASSOC)['total_notificacoes'];

// 4. Modal Local
if (isset($_GET['location'])) {
    $location = $_GET['location'];
    $sqlLocation = "SELECT descricao FROM mapasmed WHERE nome = :location";
    $stmtLocation = $pdo->prepare($sqlLocation);
    $stmtLocation->bindParam(':location', $location, PDO::PARAM_STR);
    $stmtLocation->execute();
    $locationInfo = $stmtLocation->fetch(PDO::FETCH_ASSOC);
    if ($locationInfo) { echo $locationInfo['descricao']; exit(); }
}

// 5. Consulta Personagem Ativo
$sql = "SELECT * FROM personagens WHERE jogador = :user_id AND ativo = 1 LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $personagemAtivo = $row; 
    
    $personagem_id = $row['id'];
    $nomePersonagem = $row['personagem'];
    $situacao = $row['situacao'] ?? 'livre'; 
    $local = $row['local'];
    $paralisado = $row['paralisado'];
    $prata = $row['prata'];
    $soldados = $row['soldados'];
    $carne = $row['carne'];
    $madeira = $row['madeira'];
    $atk = $row['atk'];
    $def = $row['def'];
    $cla = $row['cla'];
    $hp_atual = $row['hp_atual'] ?? 100; 
    $hp_max = $row['hp_max'] ?? 100;   
    
    $_SESSION['personagem'] = $personagem_id;
    $_SESSION['personagem_nome'] = $nomePersonagem;
    $_SESSION['local'] = $local;
    $_SESSION['situacao'] = $situacao;
    $_SESSION['carne'] = $carne;
    $_SESSION['madeira'] = $madeira;
    $_SESSION['soldados'] = $soldados;
    $_SESSION['prata'] = $prata;

    // Dados do Local
    $sqlLocal = "SELECT tipo, n, l, s, o FROM mapasmed WHERE nome = :local";
    $stmtLocal = $pdo->prepare($sqlLocal);
    $stmtLocal->bindParam(':local', $local, PDO::PARAM_STR);
    $stmtLocal->execute();
    $local_info = $stmtLocal->fetch(PDO::FETCH_ASSOC);
    
    if ($local_info) {
        $tipolocal = $local_info['tipo'];
        $norte = $local_info['n'];
        $leste = $local_info['l'];
        $sul = $local_info['s'];
        $oeste = $local_info['o'];
    }
    
    // 6. HISTÓRICO DE AÇÕES (LIMITADO A 30)
    $sqlMessages = "SELECT id, acao, dataehora, vz FROM acoespersonagens WHERE personagem = :personagem ORDER BY dataehora DESC LIMIT 30";
    $stmtMessages = $pdo->prepare($sqlMessages);
    $stmtMessages->bindParam(':personagem', $nomePersonagem, PDO::PARAM_STR);
    $stmtMessages->execute();
    $messages = $stmtMessages->fetchAll(PDO::FETCH_ASSOC);
    
    // Update VZ
    $idsParaAtualizar = array_column(array_filter($messages, function($m) { return $m['vz'] == 0; }), 'id');
    if (!empty($idsParaAtualizar)) {
        $placeholders = implode(',', array_fill(0, count($idsParaAtualizar), '?'));
        $sqlUpdate = "UPDATE acoespersonagens SET vz = 1 WHERE id IN ($placeholders)";
        $stmtUpdate = $pdo->prepare($sqlUpdate);
        $stmtUpdate->execute($idsParaAtualizar);
    }
}

function formatarTermino($data) {
    if (empty($data) || strtotime($data) === false || strtotime($data) < time()) { return "Concluído"; }
    return date('d/m/Y H:i', strtotime($data));
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RPG ERA MEDIEVAL: Dervian</title>
    <link rel="stylesheet" href="css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="light-rays"></div>

    <div class="container">
        
        <header class="header-game">
             <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); font-size: 2rem; text-align: center; margin-bottom: 10px;">
                RPG ERA MEDIEVAL: Ferro & Fogo
             </h1>
             
             <div class="btn-group navigation">
                <a href="dashboard.php"><button style="width: auto;">Menu Principal</button></a>
                <a href="pagina_notificacoesjogo.php"><button style="width: auto;">Notificações <?= ($total_notificacoes >= 1) ? '<span class="notification-badge">'.$total_notificacoes.'</span>' : '' ?></button></a>
                <button onclick="confirmarSaida()" class="btn-danger" style="width: auto;">Sair</button>
            </div>
            <hr style="margin-top: 15px;">
        </header>

        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-msg-box">
                <?= htmlspecialchars($_SESSION['msg']) ?>
            </div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <main class="game-grid">
            
            <section class="game-panel">
                <h2 class="panel-title">Seu Personagem</h2>
                
                <?php if ($personagemAtivo): ?>
                    <div class="character-info">
                        <div class="health-bar-container">
                            <div class="health-bar-fill" style="width: <?= ($hp_atual / $hp_max) * 100 ?>%;"></div>
                            <span class="health-bar-text">HP: <?= $hp_atual ?> / <?= $hp_max ?></span>
                        </div>

                        <div class="info-card">
                            <h3>Informações</h3>
                            <p><strong>Nome:</strong> <span><?= $row['personagem']; ?></span></p>
                            <p><strong>Reputação:</strong> <span><?= $row['reputacao']; ?></span></p>
                            <p><strong>Local:</strong> <span><?= $row['local']; ?></span></p>
                            <p><strong>Situação:</strong> <span class="<?= ($situacao == "livre" || $situacao == '') ? 'status-free' : 'status-busy'; ?>"><?= $row['situacao']; ?></span></p>
                            <?php if ($situacao != "livre" && $situacao != ''): ?>
                                <p><strong>Término:</strong> <span><?= formatarTermino($paralisado); ?></span></p>
                            <?php endif; ?>
                        </div>
                        
                        <div class="info-card">
                            <h3>Recursos</h3>
                            <ul class="resource-list">
                                <li class="resource-item"><span class="resource-name">Prata:</span> <span class="resource-value"><?= $row['prata']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Ouro:</span> <span class="resource-value"><?= $row['ouro']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Carne:</span> <span class="resource-value"><?= $row['carne']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Madeira:</span> <span class="resource-value"><?= $row['madeira']; ?></span></li>
                            </ul>
                        </div>
                        
                        <div class="info-card">
                            <h3>Militar</h3>
                            <ul class="resource-list">
                                <li class="resource-item"><span class="resource-name">Soldados:</span> <span class="resource-value"><?= $row['soldados']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Ataque:</span> <span class="resource-value"><?= $row['atk']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Defesa:</span> <span class="resource-value"><?= $row['def']; ?></span></li>
                            </ul>
                        </div>

                        <div class="info-card">
                            <h3>Histórico</h3>
                            <div class="actions-list">
                                <?php if (!empty($messages)): ?>
                                    <?php foreach ($messages as $message): ?>
                                        <div class="action-item">
                                            <span class="action-description">
                                                <?= !empty($message['acao']) ? htmlspecialchars($message['acao']) : "Ação registrada" ?>
                                            </span>
                                            <div class="action-time">
                                                <?= date('d/m H:i', strtotime($message['dataehora'])) ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="action-item"><span class="action-description">Nenhuma ação recente.</span></div>
                                <?php endif; ?>
                            </div>
                        </div>

                    <?php else: ?>
                        <div class="info-card" style="text-align: center;">
                            <h3 style="color: var(--danger-color);">Nenhum Personagem Ativo</h3>
                            <p>Por favor, <a href="admpersonagens/ativarpersonagens.php" style="color: var(--neon-bright);">ative um personagem</a>.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </section>
            
            <section class="map-panel">
                <h2 class="panel-title">Mapa de Dervian</h2>
                <div class="map-container">
                    <?php
                    $local = $local ?? ''; 
                    $sqlMap = "SELECT nome, tipo FROM mapasmed LIMIT 36";
                    $stmtMap = $pdo->query($sqlMap);
                    
                    while ($row_map = $stmtMap->fetch(PDO::FETCH_ASSOC)) {
                        $nome = $row_map["nome"];
                        $tipo = $row_map["tipo"]; // ex: 'city', 'mar', 'mata'
                        $isCurrent = ($nome == $local);
                        
                        // Caminho da imagem (ajuste se a pasta for diferente)
                        // Supondo que a pasta 'fts' está na raiz, voltamos um nível se necessário ou usamos caminho absoluto
                        $img_src = "fts/mapa/terreno/" . $tipo . ".png"; 

                        // Renderiza o quadrado com a imagem de fundo
                        echo '<div class="map-square" onclick="showLocationDescription(\''.$nome.'\')">';
                        echo '<img src="'.$img_src.'" alt="'.$nome.'" class="map-bg-img">';
                        
                        // Nome do local (opcional: pode remover se quiser ver só o mapa)
                        echo '<p class="map-name">'.$nome.'</p>';
                        
                        // Marcador do personagem
                        if ($isCurrent) {
    // Ajuste o caminho "fts/personagem.png" se sua imagem estiver em outro lugar
    echo '<img src="personagem.png" class="map-personagem-marker" alt="Você">'; 
}
                        echo '</div>';
                    }
                    ?>
                </div>
            </section>
            
            <section class="actions-panel">
                
                <div class="action-section" style="border-left-color: var(--neon-bright);">
                    <h3 class="panel-title" style="text-align: left; font-size: 1.2rem;">Movimentação</h3>
                    
                    <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                        <form action="moverperson.php" method="post" class="movimentacao-form-grid">
                            <input type="hidden" name="mover" value="1">
                            <?php if (!empty($norte)): ?><button type="submit" name="direcao" value="<?= $norte ?>" class="btn" style="grid-column: 2 / 3;" onclick="return confirm('Mover para Norte?')"><i class="fas fa-arrow-up"></i></button><?php endif; ?>
                            <?php if (!empty($oeste)): ?><button type="submit" name="direcao" value="<?= $oeste ?>" class="btn" style="grid-column: 1 / 2;" onclick="return confirm('Mover para Oeste?')"><i class="fas fa-arrow-left"></i></button><?php endif; ?>
                            <?php if (!empty($leste)): ?><button type="submit" name="direcao" value="<?= $leste ?>" class="btn" style="grid-column: 3 / 4;" onclick="return confirm('Mover para Leste?')"><i class="fas fa-arrow-right"></i></button><?php endif; ?>
                            <?php if (!empty($sul)): ?><button type="submit" name="direcao" value="<?= $sul ?>" class="btn" style="grid-column: 2 / 3;" onclick="return confirm('Mover para Sul?')"><i class="fas fa-arrow-down"></i></button><?php endif; ?>
                        </form>
                        
                        <?php if (isset($tipolocal) && $tipolocal != "city"): ?>
                            <button type="button" class="btn-full-width-neon" onclick="abrirModalPersonagens()">
                                <i class="fas fa-users"></i> Quem está no local
                            </button>
                        <?php endif; ?>
                        
                    <?php else: ?>
                        <div class="action-section" style="border: none; box-shadow: none;">
                            <p style="color: var(--danger-color); font-weight: bold;">Ocupado: <span class="status-busy"><?= $situacao; ?></span></p>
                            <p style="margin-top: 5px;">Término: <span style="color: var(--prata);"><?= formatarTermino($paralisado); ?></span></p>
                            
                            <?php
                            $action = ''; $buttonText = '';
                            if ($horarioAtual >= $paralisado) {
                                if ($situacao == "trabalhando") { $action = "pegarpg.php"; $buttonText = "Pegar Pagamento"; }
                                elseif (strpos($situacao, 'treinando') !== false) { $action = "finalisartreino.php"; $buttonText = "Finalizar Treino"; }
                                else { $action = "personagemlivre.php"; $buttonText = "Concluir Ação"; }
                            }
                            if ($action && $buttonText): ?>
                                <form action="<?= $action ?>" method="POST" style="margin-top: 15px;">
                                    <input type="hidden" name="finalizar_acao" value="1">
                                    <input type="hidden" name="local" value="<?= $local ?>">
                                    <button type="submit" class="action-btn-neon btn-success-neon" style="width: 100%;"><?= $buttonText ?></button>
                                </form>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                    
                    <?php if (isset($tipolocal) && $tipolocal == "city"): ?>
                        <div class="action-section" style="border-left-color: var(--success-color);">
                            <h3 style="color: var(--primary); font-size: 1.1rem;">Cidade</h3>
                            
                            <form action="trabalhar.php" method="POST" class="action-form">
                                <button type="submit" class="action-btn-neon" name="trabalhar" onclick="return confirm('Trabalhar?')"><i class="fas fa-hammer"></i> Trabalhar</button>
                            </form>
                            
                            <h4 style="color:#ccc; margin-top:15px;">Contratar Soldados (80$)</h4>
                            <form action="contratar.php" method="POST" class="action-form">
                                <input type="number" name="quantidade" min="1" placeholder="Qtd" class="action-input-neon">
                                <button type="submit" class="action-btn-neon" name="contratar">Contratar</button>
                            </form>

                            <?php if ($soldados >= 1): ?>
                                <h4 style="color:#ccc; margin-top:15px;">Dispensar Soldados</h4>
                                <form action="dispensarsoldados.php" method="POST" class="action-form">
                                    <input type="number" name="quantidade" min="1" max="<?= $soldados ?>" placeholder="Qtd" class="action-input-neon">
                                    <button type="submit" class="action-btn-neon btn-danger-neon" name="dispensar">Dispensar</button>
                                </form>
                            <?php endif; ?>

                            <?php if ($carne >= 1): ?>
                                <h4 style="color:#ccc; margin-top:15px;">Vender Carne (<?= $precocarne ?>$)</h4>
                                <form action="vendercarne.php" method="POST" class="action-form">
                                    <input type="number" name="quantidade" min="1" max="<?= $carne ?>" placeholder="Qtd" class="action-input-neon">
                                    <button type="submit" class="action-btn-neon btn-warning-neon" name="vendercarne">Vender</button>
                                </form>
                            <?php endif; ?>

                            <?php if ($madeira >= 1): ?>
                                <h4 style="color:#ccc; margin-top:15px;">Vender Madeira (<?= $precomadeira ?>$)</h4>
                                <form action="vendermadeira.php" method="POST" class="action-form">
                                    <input type="number" name="quantidade" min="1" max="<?= $madeira ?>" placeholder="Qtd" class="action-input-neon">
                                    <button type="submit" class="action-btn-neon btn-warning-neon" name="vendermadeira">Vender</button>
                                </form>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($tipolocal) && ($tipolocal == "campo" || $tipolocal == "mata")): ?>
                        <div class="action-section" style="border-left-color: var(--primary);">
                            <h3 style="color: var(--primary); font-size: 1.1rem;">Exploração</h3>
                            
                            <?php if ($tipolocal == "campo"): ?>
                                <form action="treinaratk.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="treinar"><i class="fas fa-fist-raised"></i> Treinar Ataque</button>
                                </form>
                                <form action="treinardef.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="treinar"><i class="fas fa-shield-alt"></i> Treinar Defesa</button>
                                </form>
                            <?php endif; ?>
                            
                            <?php if ($tipolocal == "mata"): ?>
                                <form action="caca.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="caca"><i class="fas fa-paw"></i> Caçar</button>
                                </form>
                                <form action="lenhar.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="lenhar"><i class="fas fa-tree"></i> Coletar Madeira</button>
                                </form>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                
                <?php if ($situacao !== 'escondido' && $situacao !== 'fugindo e reagrupando soldados'): ?>
                    <div class="action-section" style="border-left-color: var(--neon-bright);">
                        <h3 style="color: var(--primary); text-align: left; font-size: 1.1rem; border-bottom: 1px dashed var(--primary);"><center><font color="white">Chat local</font></center></h3>
                        
                        <div class="combat-iframe" style="height: 350px; border: none;">
                            <iframe src="chat_firebase.php" style="width: 100%; height: 100%; border: none;"></iframe>
                        </div>

                    </div>
                <?php endif; ?>

            </section>
        </main>
        <center>
        <footer class="footer-simple-medieval" style="margin-top: 30px;">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; 2025 Todos os direitos reservados.</p>
            </div>
        </footer></center>
    </div>
    
    <div id="locationModal" class="modal"><div class="modal-content"><span class="close-modal" onclick="closeModal()">&times;</span><h2 id="modalLocationName" style="color: var(--neon-bright);"></h2><p id="modalLocationDescription" style="color: var(--light-text);"></p></div></div>
    <div id="modalPersonagens" class="modal"><div class="modal-content"><span class="close-modal" onclick="fecharModalPersonagens()">&times;</span><h2 style="color: var(--neon-bright);">Personagens</h2><div id="conteudoModal" style="max-height: 400px; overflow-y: auto; margin-top: 15px; color: var(--light-text);"></div></div></div>

    <script>
        function confirmarSaida() { if (confirm("Tem certeza que deseja sair?")) { window.location.href = "logout.php"; } }
        function abrirModalPersonagens() { const m = document.getElementById('modalPersonagens'); const c = document.getElementById('conteudoModal'); m.style.display = 'block'; c.innerHTML = '<p>Carregando...</p>'; fetch('jogo/quemestanolocal.php', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: 'local=' + encodeURIComponent('<?php echo isset($local) ? $local : ''; ?>') }).then(r => r.text()).then(d => { c.innerHTML = d; }); }
        function fecharModalPersonagens() { document.getElementById('modalPersonagens').style.display = 'none'; }
        function showLocationDescription(n) { fetch('?location=' + encodeURIComponent(n)).then(r => r.text()).then(d => { document.getElementById('modalLocationName').textContent = n; document.getElementById('modalLocationDescription').textContent = d; document.getElementById('locationModal').style.display = 'block'; }); }
        function closeModal() { document.getElementById('locationModal').style.display = 'none'; }
        window.onclick = function(e) { if(e.target == document.getElementById('locationModal')) closeModal(); if(e.target == document.getElementById('modalPersonagens')) fecharModalPersonagens(); }
        setTimeout(function(){ location.reload(); }, 30000);
        function recarregarChat() { const i = document.getElementById('chatIframe'); if(i) i.src = i.src; }
        document.addEventListener('DOMContentLoaded', function() { setInterval(recarregarChat, 5000); });
    </script>
</body>
</html>