<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit; // Adicione exit após redirecionar
}

// Inicializa variáveis de sessão para evitar erros
$_SESSION['msg'] = $_SESSION['msg'] ?? "";
$_SESSION['msg2'] = $_SESSION['msg2'] ?? "";
$msgsis2 = $_SESSION['msg2'];

$user_id = $_SESSION['user_id']; // Corrigido para user_id se for o ID numérico
$user_name = $_SESSION['user_name'];
$_SESSION['vendido'] = "0";

// --- PHP PARA CÁLCULO DE SALDO ---
try {
    $wallet = $_SESSION['user_wallet'];

    // Saldo enviado
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_enviado FROM mempool WHERE remetente = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $saldo_enviado = $stmt->fetch(PDO::FETCH_ASSOC)['total_enviado'] ?? 0;

    // Saldo recebido
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_recebido FROM mempool WHERE destinatario = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $saldo_recebido = $stmt->fetch(PDO::FETCH_ASSOC)['total_recebido'] ?? 0;

    // Saldo carteira
    $saldo_carteira = bcsub($saldo_recebido, $saldo_enviado, 2);
    $saldo_carteira = max($saldo_carteira, "0.00"); // Garante que não seja negativo

    $_SESSION['latillas'] = $saldo_carteira;
    $_SESSION['saldolivre'] = $saldo_carteira;
    $_SESSION['saldolivre2'] = $saldo_carteira;

} catch (PDOException $e) {
    $saldo_carteira = "Erro";
    error_log("Erro ao calcular saldo: " . $e->getMessage());
}

// --- PHP PARA CONTAGEM DE FICHAS ---
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
    $stmt->execute([$user_name]);
    $fichas_disponiveis = $stmt->fetchColumn();
} catch (Exception $e) {
    $fichas_disponiveis = "Erro";
    error_log("Erro ao contar fichas: " . $e->getMessage());
}

// --- PHP PARA CONTAGEM DE PERSONAGENS ---
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM personagens WHERE jogador = ?");
    $stmt->execute([$user_name]);
    $quantidadepersonagens = $stmt->fetchColumn();
} catch (Exception $e) {
    $quantidadepersonagens = "Erro";
    error_log("Erro ao contar personagens: " . $e->getMessage());
}

// --- PHP PARA CONTAGEM DE NOTIFICAÇÕES ---
$sqlCountNotificacoes = "SELECT COUNT(*) FROM notificacoes_sis WHERE user2 = :user_name AND vz2 = 0";
$stmtCountNotificacoes = $pdo->prepare($sqlCountNotificacoes);
$stmtCountNotificacoes->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmtCountNotificacoes->execute();
$total_notificacoes = $stmtCountNotificacoes->fetchColumn();

// --- PHP PARA NOTÍCIAS ---
$queryNoticias = "SELECT id, assunto, titulo, noticia, img, datacriacao 
                  FROM noticias 
                  WHERE datafim IS NULL OR datafim > NOW()
                  ORDER BY datacriacao DESC";
$stmtNoticias = $pdo->query($queryNoticias);
$noticias = $stmtNoticias->fetchAll(PDO::FETCH_ASSOC);

$default_images = [
    'https://i.imgur.com/JQ6ZxGm.jpg',
    'https://i.imgur.com/8QZQZQZ.jpg',
    'https://i.imgur.com/9Q9Q9Q9.jpg'
];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Painel RPG Medieval</title>
  <link rel="stylesheet" href="css/dashboard.css">
</head>
<body>
  <div class="light-rays"></div>

  <div class="container">
    <center>
      <img class="bn" src="bn.png" alt="Banner RPG Medieval"><br><br>
    </center>

    <div class="grid-container-3col grid-main-dashboard">
      
      <div class="card player-info">
        <h3>Dados do Jogador</h3>
        <hr>
        <p><strong>Jogador:</strong> <span class="highlight"><?php echo htmlspecialchars($user_name); ?></span></p>
        <p><strong>Wallet:</strong> <span class="highlight-wallet"><font color="#007bff"><b><?php echo htmlspecialchars($wallet); ?></b></font></span></p>
        <p><strong>Saldo:</strong> <span class="highlight-success">R$ <?php echo htmlspecialchars($saldo_carteira); ?></span></p>
        <p><strong>Fichas:</strong> <span class="highlight"><?php echo htmlspecialchars($fichas_disponiveis); ?> Ficha/s</span></p>
        <p><strong>Personagens:</strong> <span class="highlight"><?php echo htmlspecialchars($quantidadepersonagens); ?> personagem(ns)</span></p>
      </div>

      <div class="card news-container">
        <h2 class="news-header">Últimas Notícias</h2>
        <div class="news-scroll">
        <?php if (empty($noticias)): ?>
    <div class="no-news">Nenhuma notícia disponível no momento.</div>
<?php else: ?>
    <?php foreach ($noticias as $noticia):
        $img_src = !empty($noticia['img']) ? $noticia['img'] : $default_images[array_rand($default_images)];
    ?>
    <div class="news-item">
        <div class="news-image-container">
            <img src="<?= htmlspecialchars($img_src, ENT_QUOTES, 'UTF-8') ?>" alt="<?= htmlspecialchars($noticia['titulo'], ENT_QUOTES, 'UTF-8') ?>" class="news-image">
        </div>
        <div class="news-content">
       <h1><b><font color="#007bff">
    <?php if (!empty($noticia['titulo'])): ?>
        <p class="news-text">
            <?= nl2br(mb_convert_encoding($noticia['titulo'], 'UTF-8', 'Windows-1252')) ?>
        </p>
    <?php endif; ?>
</font></b></h1>

<?php if (!empty($noticia['noticia'])): ?>
    <p class="news-text">
        <?= nl2br(mb_convert_encoding($noticia['noticia'], 'UTF-8', 'Windows-1252')) ?>
    </p>
<?php endif; ?>
            
            <div class="news-date"><?= date('d/m/Y H:i', strtotime($noticia['datacriacao'])) ?></div>
        </div>
    </div>
    <?php endforeach; ?>
<?php endif; ?>


        </div>
      </div>

      <div class="card button-menu">
        <h3>Menu</h3>
        <hr>
        <div class="btn-group">
          <button onclick="window.location.href='faleconosco.php'">Fale Conosco</button>
          
          <?php $link_notificacoes = 'pagina_notificacoes.php'; ?>
          <button onclick="window.location.href='<?= $link_notificacoes ?>'">
            Notificações
            <?php if ($total_notificacoes > 0): ?>
              <span class="notification-badge"><?= $total_notificacoes ?></span>
            <?php endif; ?>
          </button>
          
          <a href="admpersonagens.php"><button>Administração de Personagens</button></a>
          <a href="dashboardmed.php"><button>Jogo</button></a>
          <a href="mercado/mercado.php"><button>Mercado</button></a>
          <a href="nossoprojeto.php"><button>Nosso Projeto</button></a>
            <a href="nossoprojeto.php"><button>Analisar gráfico</button></a>
        </div>
      </div>
    </div>

    <div class="container-azul">
      <div class="grid-container-3col grid-market">
        
        <a href="javascript:void(0);" class="card card-link" id="abrirModalLink">
          <h4>Ordens de Venda</h4>
          <div class="card-content-include">
            <?php include('mercado/pqnlistaordensvenda.php'); ?>
          </div>
        </a>

        <a href="graficow.php" class="card card-link">
          <h4>Gráfico de Mercado</h4>
          <div class="card-content-include">
            <?php include('grafico.php'); ?>
          </div>
        </a>

        <a href="mercado/ordenscompra.php" class="card card-link">
          <h4>Ordens de Compra</h4>
          <div class="card-content-include">
            <?php include('mercado/pqnlistaordenscompras.php'); ?>
          </div>
        </a>
      </div>
    </div>

    <div class="grid-container-3col grid-info">
      
      <div class="card info-box">
        <h4>Nosso Projeto</h4>
        <p>Nosso projeto, está em fase inicial. Estamos trabalhando com total dedicação, no seu desenvolvimento, para entregar um sistema robusto, seguro, alinhado a um jogo imersivo, complexo e emocionante.</p>
        <p>Em breve teremos um sistema bem mais desenvolvido, e um jogo bem mais diversificado, estamos apenas começando.</p>
      </div>

      <div class="card button-menu">
        <h3>Ações</h3>
        <hr>
        <div class="btn-group">
          <a href="graficow.php"><button>Analisar Gráfico</button></a>
          <a href="nossoprojeto.php"><button>Nosso Projeto</button></a>
          <a href="#"><button>Livro NFT</button></a>
          <a href="javascript:void(0);" onclick="confirmarSaida();"><button class="btn-danger">Sair</button></a>
        </div>
      </div>
      
      <div class="card info-box">
        <h4>Oportunidade</h4>
        <p>Aproveite o período de lançamento, para garantir os seus NFT's, a preços iniciais, custando valores baixíssimos, quase simbólicos. Conforme o jogo evoluir e o mercado crescer, o valor dos NFTs irão aumentar.</p>
        <p>Não perca essa oportunidade de se juntar a nós, fazer parte da nossa comunidade, participar deste projeto, principalmente agora, no início. </p>
      </div>
    </div>

  
  
  <footer class="footer-simple-medieval">
    <div class="footer-content">
        <h4>⚔️ RPG ERA MEDIEVAL: FOGO E FERRO PELO PODER ⚔️</h4>
        <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados. Construindo lendas desde 2024.</p>
    </div>
</footer>


  </div> 
  
  <div id="modalVendas" class="modal">
    <div class="modal-content">
      <span class="close">&times;</span>
      <h2>Ordens de Vendas de NFT's</h2>
      <div class="btn-group">
        <a href="mercado/ordens_venda.php"><button>Vendas de Personagens</button></a>
        <a href="fichas/listavendadefichas.php"><button>Vendas de Fichas</button></a>
      </div>
    </div>
  </div>

  <script>
    // Script para confirmar saída
    function confirmarSaida() {
        if (confirm("Tem certeza que deseja sair?")) {
            window.location.href = "logout.php";
        }
    }

    // Script do Modal
    const modal = document.getElementById('modalVendas');
    const btnAbrirModal = document.getElementById('abrirModalLink');
    const btnFecharModal = document.querySelector('.modal .close');

    btnAbrirModal.onclick = function() {
      modal.style.display = 'flex';
    }
    btnFecharModal.onclick = function() {
      modal.style.display = 'none';
    }
    window.onclick = function(event) {
      if (event.target === modal) {
        modal.style.display = 'none';
      }
    }
  </script>
</body>
</html>
