<?php
session_start();
// Ajuste o caminho para o conexao.php se necessário
require '../conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// --- LÓGICA PHP MANTIDA INTACTA ---

// Processar transferência de personagem
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['transferir_personagem'])) {
    $personagem_id = $_POST['personagem_id'];
    $novo_jogador = trim($_POST['novo_jogador']);
    
    try {
        $pdo->beginTransaction();
        
        // 1. Verificar se o personagem ainda existe e pertence ao jogador atual
        $stmt = $pdo->prepare("SELECT * FROM personagens WHERE id = ? AND jogador = ?");
        $stmt->execute([$personagem_id, $user_name]);
        $personagem = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$personagem) {
            throw new Exception("Personagem não encontrado ou não pertence a você!");
        }
        
        // 2. Verificar se o novo jogador existe e é diferente do atual
        if ($novo_jogador === $user_name) {
            throw new Exception("Você não pode transferir para si mesmo!");
        }
        
        $stmt = $pdo->prepare("SELECT user FROM usersblock WHERE user = ?");
        $stmt->execute([$novo_jogador]);
        $jogador_existe = $stmt->fetchColumn();
        
        if (!$jogador_existe) {
            throw new Exception("Jogador destino não encontrado!");
        }
        
        // 3. Registrar na tabela infossistema
        $info = "O jogador {$user_name} transferiu o personagem {$personagem['personagem']} (ID: {$personagem['id']}) para o jogador {$novo_jogador}. ";
        $info .= "Dados: Soldados={$personagem['soldados']}, Ouro={$personagem['ouro']}, Prata={$personagem['prata']}, ";
        $info .= "Cargo={$personagem['cargo']}, Criado em={$personagem['datacriacao']}";
        
        $stmt = $pdo->prepare("INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
                             VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute([
            $info,
            $user_name,
            $novo_jogador,
            'Transferência de Personagem'
        ]);
        
        // 4. Atualizar o dono do personagem
        $stmt = $pdo->prepare("UPDATE personagens SET jogador = ?, datamovimentacao = NOW() WHERE id = ?");
        $stmt->execute([$novo_jogador, $personagem_id]);
        
        $pdo->commit();
        
        echo "<script>
                alert('Personagem transferido com sucesso!');
                window.location.href = window.location.pathname;
              </script>";
        exit();
        
    } catch (Exception $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo "<script>alert('Erro: ".addslashes($e->getMessage())."');</script>";
    }
}

// Buscar todos os personagens do jogador em ordem alfabética
$stmt = $pdo->prepare("SELECT id, personagem FROM personagens WHERE jogador = ? ORDER BY personagem ASC");
$stmt->execute([$user_name]);
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transferir Personagens - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
    <script>
        function confirmarTransferencia(form) {
            const select = form.personagem_id;
            const personagem = select.options[select.selectedIndex].text;
            const novoJogador = form.novo_jogador.value;
            
            if (!personagem || select.value === "" || !novoJogador) {
                alert('Por favor, preencha todos os campos!');
                return false;
            }
            
            if (confirm(`ATENÇÃO EXTREMA: CONFIRMAR TRANSFERÊNCIA\n\nVocê está prestes a transferir o personagem:\n>> ${personagem} <<\n\nPara o jogador:\n>> ${novoJogador} <<\n\nEsta ação é IRREVERSÍVEL! Você perderá o acesso a este personagem.\n\nDeseja continuar?`)) {
                return true;
            }
            return false;
        }
    </script>
</head>
<body>
    <div class="light-rays"></div>

    <div class="container"> 
        
        <div class="card" style="margin-top: 30px; margin-bottom: 50px;">
            
            <div class="listing-header-centered">
                <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); margin-bottom: 25px; font-size: 2rem;">
                    RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder
                </h1>
                
                     <div class="btn-group btn-container-center" style="margin-bottom: 25px;"><center>
                    <a href="../admpersonagens.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Administração de Fichas & Personagens</button>
                    </a><br>
                    <a href="../dashboard.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                    </a>
                    </center>
                </div>

                <h2 style="color: white; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 15px;">
                    Transferir Personagens
                </h2>

                <p class="listing-intro">
                    Envie um de seus personagens para outro jogador. Atenção: Esta ação não pode ser desfeita!
                </p>
            </div>
            <?php if (empty($personagens)): ?>
                <div class="sem-personagens-neon" style="text-align: center; padding: 30px; color: #ccc; font-size: 1.2rem;">
                    <p>Você não possui personagens para transferir.</p>
                </div>
            <?php else: ?>
                <div class="form-stack-container">
                    <form method="POST" onsubmit="return confirmarTransferencia(this)">
                        
                        <div>
                            <label for="personagem_id">Selecione o Personagem a Transferir:</label>
                            <select name="personagem_id" id="personagem_id" required class="form-select-neon">
                                <option value="">-- Selecione um personagem --</option>
                                <?php foreach ($personagens as $p): ?>
                                    <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['personagem']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div>
                            <label for="novo_jogador">Jogador de Destino (Nome exato):</label>
                            <input type="text" name="novo_jogador" id="novo_jogador" maxlength="25" required 
                                   placeholder="Digite o nome do jogador destino...">
                        </div>
                        
                        <div style="margin-top: 20px;">
                            <button type="submit" name="transferir_personagem" class="btn-transferir-neon">
                                TRANSFERIR PERSONAGEM
                            </button>
                        </div>
                    </form>
                </div>
            <?php endif; ?>
            </div> <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> </body>
</html>