<?php
session_start();
// Ajuste o caminho para o conexao.php se necessário
require '../conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// --- LÓGICA PHP MANTIDA INTACTA ---

// Configurações de paginação
$por_pagina = 10;
$pagina = isset($_GET['pagina']) ? max(1, intval($_GET['pagina'])) : 1;
$offset = ($pagina - 1) * $por_pagina;

// Processar transformação de personagem em ficha
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['transformar_ficha'])) {
    $personagem_id = $_POST['personagem_id'];
    $datahora_atual = date('Y-m-d H:i:s');
    
    try {
        $pdo->beginTransaction();
        
        // 1. Pegar TODOS os dados do personagem
        $stmt = $pdo->prepare("SELECT * FROM personagens WHERE id = ? AND jogador = ?");
        $stmt->execute([$personagem_id, $user_name]);
        $personagem = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$personagem) {
            throw new Exception("Personagem não encontrado!");
        }
        
        // 2. Gerar hash e link únicos
        $tentativas = 0;
        do {
            $hash = bin2hex(random_bytes(16));
            $link = bin2hex(random_bytes(8));
            
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE hash = ? OR link = ?");
            $stmt->execute([$hash, $link]);
            $tentativas++;
            
            if ($tentativas > 5) {
                throw new Exception("Não foi possível gerar identificadores únicos para a ficha");
            }
        } while ($stmt->fetchColumn() > 0);
        
        // 3. Criar a ficha primeiro para obter o ID
        $stmt = $pdo->prepare("INSERT INTO fichaspersonagens 
                             (jogador, situacao, hash, link, responsavel, data, descricao, preco, validade) 
                             VALUES (?, '1', ?, ?, ?, ?, ?, 0, ?)");
        $validade = date('Y-m-d H:i:s', strtotime('+1 year'));
        $stmt->execute([
            $user_name,
            $hash,
            $link,
            $user_name,
            $datahora_atual,
            "Ficha gerada do personagem {$personagem['personagem']}",
            $validade
        ]);
        
        $ficha_id = $pdo->lastInsertId();
        
        // 4. Pegar TODOS os dados da ficha recém-criada
        $stmt = $pdo->prepare("SELECT * FROM fichaspersonagens WHERE id = ?");
        $stmt->execute([$ficha_id]);
        $ficha = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // 5. Registrar no infossistema com TODOS os dados
        $informacao = "TRANSFORMAÇÃO DE PERSONAGEM EM FICHA\n\n";
        $informacao .= "DADOS DO JOGADOR:\n";
        $informacao .= "ID: $user_id\n";
        $informacao .= "Nome: $user_name\n\n";
        
        $informacao .= "DADOS DO PERSONAGEM:\n";
        foreach ($personagem as $campo => $valor) {
            $informacao .= "$campo: " . (is_null($valor) ? 'NULL' : $valor) . "\n";
        }
        
        $informacao .= "\nDADOS DA FICHA GERADA:\n";
        foreach ($ficha as $campo => $valor) {
            $informacao .= "$campo: " . (is_null($valor) ? 'NULL' : $valor) . "\n";
        }
        
        $informacao .= "\nData/Hora: $datahora_atual";
        
        $stmt = $pdo->prepare("INSERT INTO infossistema 
                             (informacao, p1, p2, origem, dataehora) 
                             VALUES (?, ?, ?, 'Transformação', ?)");
        $stmt->execute([
            $informacao,
            $user_name,
            $personagem['personagem'],
            $datahora_atual
        ]);
        
        // 6. Apagar o personagem
        $stmt = $pdo->prepare("DELETE FROM personagens WHERE id = ?");
        $stmt->execute([$personagem_id]);
        
        $pdo->commit();
        
        echo "<script>
                alert('Personagem transformado em ficha com sucesso!\\nID da Ficha: $ficha_id\\nHash: $hash');
                window.location.href = window.location.pathname;
              </script>";
        exit();
        
    } catch (Exception $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo "<script>alert('Erro: ".addslashes($e->getMessage())."');</script>";
    }
}

// Contar total de personagens
$stmt = $pdo->prepare("SELECT COUNT(*) FROM personagens WHERE jogador = ?");
$stmt->execute([$user_name]);
$total_personagens = $stmt->fetchColumn();

// Listar personagens do jogador com paginação
$sql = "SELECT id, personagem, soldados, ouro, prata, cargo, datacriacao 
        FROM personagens 
        WHERE jogador = ? 
        ORDER BY datacriacao DESC 
        LIMIT " . intval($por_pagina) . " OFFSET " . intval($offset);

$stmt = $pdo->prepare($sql);
$stmt->execute([$user_name]);
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total_paginas = ceil($total_personagens / $por_pagina);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transformar Personagem em Ficha - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
</head>
<body>
    <div class="light-rays"></div>

    <div class="container"> 
        
        <div class="card" style="margin-top: 30px; margin-bottom: 50px;">
            
            <div class="listing-header-centered">
                <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); margin-bottom: 25px; font-size: 2rem;">
                    RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder
                </h1>
                
                <div class="btn-group btn-container-center" style="margin-bottom: 25px;"><center>
                    <a href="../admpersonagens.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Administração de Fichas & Personagens</button>
                    </a><br>
                    <a href="../dashboard.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                    </a>
                    </center>
                </div>

                <h2 style="color: white; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 15px;">
                    Transformar Personagem em Ficha
                </h2>

                <p class="listing-intro">
                    <b><font color="yellow">Atenção:</font> <font color="red">Esta ação é irreversível! Ao transformar um personagem em ficha, ele será excluído permanentemente e irreversivelmente, e você receberá uma ficha.</font></b>
                </p>
            </div><br>
            <div class="personagens-list-container">
                
                <?php if (empty($personagens)): ?>
                    <div class="sem-personagens-neon">
                        <p>Você não possui personagens para transformar em fichas.</p>
                    </div>
                <?php else: ?>
                    
                    <?php foreach ($personagens as $p): ?>
                        <form method="POST">
                            <input type="hidden" name="personagem_id" value="<?= $p['id'] ?>">
                            
                            <div class="personagem-neon-card" style="border-left-color: var(--primary);">
                                
                                <div class="personagem-header-neon">
                                    <div class="personagem-nome-neon" style="color: var(--primary);">
                                        Personagem: <?= htmlspecialchars($p['personagem']) ?>
                                    </div>
                                    
                                    <button type="submit" name="transformar_ficha" class="btn-transformar-neon" 
                                            onclick="return confirm('ATENÇÃO EXTREMA:\n\nTem certeza absoluta que deseja transformar o personagem \'<?= addslashes($p['personagem']) ?>\' em uma ficha?\n\nEsta ação é IRREVERSÍVEL! O personagem será excluído e você receberá uma ficha.')">
                                        Transformar
                                    </button>
                                </div>
                                
                                <div class="personagem-detalhes-grid">
                                    <div class="detalhe-item-neon"><span class="icon">🛡️</span> Soldados: <?= $p['soldados'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">💰</span> Ouro: <?= $p['ouro'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">💍</span> Prata: <?= $p['prata'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">🎖️</span> Cargo: <?= $p['cargo'] ? htmlspecialchars($p['cargo']) : 'Nenhum' ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">📅</span> Criado em: <?= date('d/m/Y H:i', strtotime($p['datacriacao'])) ?></div>
                                </div>

                            </div> </form>
                    <?php endforeach; ?>
                    
                    <?php if ($total_paginas > 1): ?>
                        <div class="pagination-neon">
                            <?php if ($pagina > 1): ?>
                                <a href="?pagina=<?= $pagina-1 ?>">« Anterior</a>
                            <?php endif; ?>
                            
                            <?php 
                            $inicio = max(1, $pagina - 2);
                            $fim = min($total_paginas, $pagina + 2);
                            
                            if ($inicio > 1) echo '<span style="color:var(--primary); padding: 10px;">...</span>';
                            
                            for ($i = $inicio; $i <= $fim; $i++): ?>
                                <?php if ($i == $pagina): ?>
                                    <a href="?pagina=<?= $i ?>" class="active"><?= $i ?></a>
                                <?php else: ?>
                                    <a href="?pagina=<?= $i ?>"><?= $i ?></a>
                                <?php endif; ?>
                            <?php endfor;
                            
                            if ($fim < $total_paginas) echo '<span style="color:var(--primary); padding: 10px;">...</span>';
                            ?>
                            
                            <?php if ($pagina < $total_paginas): ?>
                                <a href="?pagina=<?= $pagina+1 ?>">Próxima »</a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                <?php endif; ?>
            </div> </div> <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> </body>
</html>