<?php
session_start();
// Ajuste o caminho para o conexao.php se necessário
require '../conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// --- LÓGICA PHP MANTIDA INTACTA ---

// Configurações de paginação
$por_pagina = 10;
$pagina = isset($_GET['pagina']) ? max(1, intval($_GET['pagina'])) : 1;
$offset = ($pagina - 1) * $por_pagina;

// Processar ativação de personagem
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ativar_personagem'])) {
    $personagem_id = $_POST['personagem_id'];
    
    try {
        $pdo->beginTransaction();
        
        // 1. Desativar todos os personagens do jogador
        $stmt = $pdo->prepare("UPDATE personagens SET ativo = 0, situacao = 0 WHERE jogador = ?");
        $stmt->execute([$user_name]);
        
        // 2. Ativar apenas o personagem selecionado
        // OBS: Mantive 'situacao = 1' que é o padrão para 'livre' no seu sistema
        $stmt = $pdo->prepare("UPDATE personagens SET ativo = 1, situacao = '1' WHERE id = ? AND jogador = ?");
        $stmt->execute([$personagem_id, $user_name]);
        
        $pdo->commit();
        
        // JavaScript para alerta e reload (Mantido do seu código)
        echo "<script>
                alert('Personagem ativado com sucesso!');
                window.location.href = window.location.pathname;
              </script>";
        exit();
        
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "<script>alert('Erro: ".addslashes($e->getMessage())."');</script>";
    }
}

// Contar total de personagens
$stmt = $pdo->prepare("SELECT COUNT(*) FROM personagens WHERE jogador = ?");
$stmt->execute([$user_name]);
$total_personagens = $stmt->fetchColumn();

// Listar personagens do jogador com paginação (ativo primeiro)
$sql = "SELECT id, personagem, soldados, ouro, prata, cargo, local, reputacao, atk, def, ativo, situacao 
        FROM personagens 
        WHERE jogador = ? 
        ORDER BY ativo DESC, id DESC 
        LIMIT " . intval($por_pagina) . " OFFSET " . intval($offset);

$stmt = $pdo->prepare($sql);
$stmt->execute([$user_name]);
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total_paginas = ceil($total_personagens / $por_pagina);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Personagens - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
    </head>
<body>
    <div class="light-rays"></div>

    <div class="container"> 
        
        <div class="card" style="margin-top: 30px; margin-bottom: 50px;">
            
            <div class="listing-header-centered">
                <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); margin-bottom: 25px; font-size: 2rem;">
                    RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder
                </h1>
                   <center>
                <div class="btn-group btn-container-center" style="margin-bottom: 25px;">
                    <center>
                    <a href="../admpersonagens.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Administração de Fichas & Personagens</button>
                    </a>
                <br>
                   <a href="../dashboard.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                    </a>
                    </ccenter>
                </div>

                <h2 style="color: white; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 15px;">
                    Ativar Personagens
                </h2>

                <p class="listing-intro">
                    Ative um personagem; você só pode ativar um por vez<br>Você possui <strong><?= $total_personagens ?></strong> personagem(ns)
                </p>
            </div><br><br>
            <div class="personagens-list-container">
                
                <?php if (empty($personagens)): ?>
                    <div class="sem-personagens-neon">
                        <p>Você não possui personagens cadastrados.</p>
                        <div class="btn-group" style="margin-top: 20px; display: inline-block;">
                            <a href="criarpersonagem.php"><button>Criar Novo Personagem</button></a>
                        </div>
                    </div>
                <?php else: ?>
                    
                    <?php foreach ($personagens as $p): 
                        $estaAtivo = $p['ativo'] == 1;
                        // Define a classe do card baseada no status
                        $classe_card = $estaAtivo ? 'personagem-ativo-neon' : 'personagem-inativo-neon';
                    ?>
                        <form method="POST">
                            <input type="hidden" name="personagem_id" value="<?= $p['id'] ?>">
                            
                            <div class="personagem-neon-card <?= $classe_card ?>">
                                
                                <div class="personagem-header-neon">
                                    <div class="personagem-nome-neon">
                                        <?= htmlspecialchars($p['personagem']) ?>
                                        <span class="<?= $estaAtivo ? 'status-badge-ativo' : 'status-badge-inativo' ?>">
                                            (<?= $estaAtivo ? 'ATIVO' : 'INATIVO' ?>)
                                        </span>
                                    </div>
                                    
                                    <?php if (!$estaAtivo): ?>
                                        <button type="submit" name="ativar_personagem" class="btn-ativar-neon">
                                            Ativar Este Personagem
                                        </button>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="personagem-detalhes-grid">
                                    <div class="detalhe-item-neon"><span class="icon">📍</span> Local: <?= htmlspecialchars($p['local']) ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">🛡️</span> Soldados: <?= $p['soldados'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">💰</span> Ouro: <?= $p['ouro'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">💍</span> Prata: <?= $p['prata'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">🎖️</span> Cargo: <?= $p['cargo'] ? htmlspecialchars($p['cargo']) : 'Nenhum' ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">⭐</span> Reputação: <?= $p['reputacao'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">⚔️</span> Ataque: <?= $p['atk'] ?></div>
                                    <div class="detalhe-item-neon"><span class="icon">🛡️</span> Defesa: <?= $p['def'] ?></div>
                                </div>

                            </div> </form>
                    <?php endforeach; ?>
                    
                    <?php if ($total_paginas > 1): ?>
                        <div class="pagination-neon">
                            <?php if ($pagina > 1): ?>
                                <a href="?pagina=<?= $pagina-1 ?>">« Anterior</a>
                            <?php endif; ?>
                            
                            <?php 
                            $inicio = max(1, $pagina - 2);
                            $fim = min($total_paginas, $pagina + 2);
                            
                            if ($inicio > 1) echo '<span style="color:var(--primary); padding: 10px;">...</span>';
                            
                            for ($i = $inicio; $i <= $fim; $i++): ?>
                                <?php if ($i == $pagina): ?>
                                    <a href="?pagina=<?= $i ?>" class="active"><?= $i ?></a>
                                <?php else: ?>
                                    <a href="?pagina=<?= $i ?>"><?= $i ?></a>
                                <?php endif; ?>
                            <?php endfor;
                            
                            if ($fim < $total_paginas) echo '<span style="color:var(--primary); padding: 10px;">...</span>';
                            ?>
                            
                            <?php if ($pagina < $total_paginas): ?>
                                <a href="?pagina=<?= $pagina+1 ?>">Próxima »</a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                <?php endif; ?>
            </div> </div> <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> </body>
</html>