<?php
session_start();
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $jogador = $_SESSION["user_name"];
    $gameselect = $_SESSION['gameselect'];
    $dataHoraDesistencia = $_POST["dataehora"]; // Obtém a data e hora da desistência
    $msg = "O $jogador desistiu.";
    
    include 'conexao.php'; // Sua conexão com o banco de dados
    
    try {
        // Consulta para obter os valores das colunas p1 e p2 do jogo
        $stmt = $pdo->prepare("SELECT p1, p2 FROM games WHERE game = :gameselect");
        $stmt->bindParam(':gameselect', $gameselect, PDO::PARAM_INT);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $p1 = $row['p1'];
        $p2 = $row['p2'];
        
        // Determina o adversário
        $adversario = ($jogador == $p1) ? $p2 : $p1;
        
        $msg = "O jogador $jogador desistiu.";
        
        // Atualiza a coluna vencedor e played com os valores adequados
        $stmt = $pdo->prepare("UPDATE games SET vencedor = :adversario, played = :dataehora, msg = :msg WHERE game = :gameselect");
$stmt->bindParam(':adversario', $adversario, PDO::PARAM_STR); // Use PDO::PARAM_STR para VARCHAR
$stmt->bindParam(':dataehora', $dataHoraDesistencia, PDO::PARAM_STR);
$stmt->bindParam(':gameselect', $gameselect, PDO::PARAM_INT);
$stmt->bindParam(':msg', $msg, PDO::PARAM_STR);

        if ($stmt->execute()) {
            echo "$gameselect Desistência registrada com sucesso.";
        } else {
            echo "Erro ao registrar a desistência.";
        }
    } catch (PDOException $e) {
        echo "Erro na consulta: " . $e->getMessage();
    }
}
?>
