<?php
session_start();
require '../conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location:../login.php");
}
$_SESSION['msg'] = "";
$msgsis2 = $_SESSION['msg2'];
$user_id = $_SESSION['user_name'];
?>



<!DOCTYPE html>
<html>
<head>
    <title>Painel de Controle</title>
<link rel="stylesheet" type="text/css" href="../style.css">

<style>

    .pagination {
    width: 58%;
    height: auto;
        background-color: #f2f2f2;
        padding: 10px;
        text-align: center;
    }

    .pagination a {
        text-decoration: none;
        display: inline-block;
        padding: 5px 10px;
        margin: 3px;
        background-color: #ffffff;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    .pagination a:hover {
        background-color: #ddd;
    }

    .pagination .current {
        background-color: #4caf50;
        color: white;
    }

    .pagination .disabled {
        pointer-events: none;
        color: #ccc;
    }


.link-verde {
    text-decoration: none;
    color: green;
}

.link-vermelho {
    text-decoration: none; /* Remove o sublinhado */
    color: red; /* Define a cor vermelha */
}


    /* CSS para o contêiner das tabelas */
.table-container {
    display: flex;
    justify-content: space-between; /* Distribui as tabelas uniformemente */
}

/* CSS para cada tabela */
.table-container table {
    width: 30%; /* Largura de cada tabela */
    border-collapse: collapse;
    border: 1px solid white; /* Borda branca */
    padding: 15px;
    text-align: left;
}


/* Estilo comum para tabelas, células, etc. */
table {
    border-collapse: collapse;
    border: 1px solid white; /* Borda branca */
}

th, td {
    padding: 15px;
    text-align: left;
}

/* Para evitar que as tabelas afetem outros elementos na página, adicione um clearfix */
.clearfix::after {
    content: "";
    clear: both;
    display: table;
}

    
    

        table {
            border-collapse: collapse;
            width: 60%;
            margin: 0 auto; /* Centraliza horizontalmente */
        }

        table, th, td {
            border: 1px solid white; /* Borda branca */
        }

        th, td {
            padding: 6px;
            text-align: left;
        }

        th {
            /* background-color: #f2f2f2; cor de fundo para cabeçalhos */
        }

    </style>
</head>
<body>
<center>
<img class="bn" src="bn.png" alt=""><br><br>
<a href="../dashboard.php"><button class="btnmenu">Menu principal</button></a><br>



<h1>Personagens à Venda</h1>

<?php
// Inclua o seu código de conexão com o banco de dados aqui

// Defina o número máximo de itens por página
$itensPorPagina = 10;

// Obtenha o número total de itens
$sqlTotal = "SELECT COUNT(*) FROM ordem_vendas";
$stmtTotal = $pdo->prepare($sqlTotal);
$stmtTotal->execute();
$totalItens = $stmtTotal->fetchColumn();

// Calcule o número total de páginas
$totalPaginas = ceil($totalItens / $itensPorPagina);

// Obtenha a página atual da URL, ou defina como 1 se não houver valor
$paginaAtual = isset($_GET['pagina']) ? $_GET['pagina'] : 1;

// Calcule o índice do primeiro item a ser exibido
$indicePrimeiroItem = ($paginaAtual - 1) * $itensPorPagina;

// Consulta SQL com limitação para a página atual
$sql = "SELECT * FROM ordem_vendas ORDER BY valor ASC LIMIT :indicePrimeiroItem, :itensPorPagina";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':indicePrimeiroItem', $indicePrimeiroItem, PDO::PARAM_INT);
$stmt->bindParam(':itensPorPagina', $itensPorPagina, PDO::PARAM_INT);
$stmt->execute();

// Exibir uma tabela com os resultados
echo "<table border='1'>";
echo "<tr><th>Personagem</th><th>Valor</th><th>Data de Publicação</th><th>Ação</th></tr>";

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $personagem = $row['personagem'];
    $valor = $row['valor'];
    $data_publicacao = $row['dataehora'];

    echo "<tr>";
    echo "<td>$personagem</td>";
    echo "<td>R$ $valor</td>"; // Formatando o valor como moeda
    echo "<td>$data_publicacao</td>";
    echo "<td>";

    // Verifique se o jogador da ordem de venda é o mesmo que o usuário logado
    if ($_SESSION['user_name'] == $row['jogador']) {
        echo "<a href='apagarordemv.php?id=" . $row['id'] . "' class='link-vermelho' onclick=\"return confirm('Tem certeza de que deseja apagar esta ordem de compra?');\">Apagar</a>";
    } else {
        echo "<a href='comprandopersonagem.php?id=" . $row['id'] . "' class='link-verde' onclick=\"return confirm('Tem certeza de que deseja comprar este personagem?');\">Comprar</a>";
    }

    echo "</td>";
    echo "</tr>";
}

echo "</table>";

// Exibir a paginação
echo '<br><br><div class="pagination">';
if ($paginaAtual > 1) {
    echo '<a href="?pagina=1">&lt;&lt;</a>'; // Primeira página
    echo '<a href="?pagina=' . ($paginaAtual - 1) . '">&lt;</a>'; // Página anterior
}

for ($i = 1; $i <= $totalPaginas; $i++) {
    if ($i == $paginaAtual) {
        echo '<span class="current">' . $i . '</span>'; // Página atual
    } else {
        echo '<a href="?pagina=' . $i . '">' . $i . '</a>'; // Outras páginas
    }
}

if ($paginaAtual < $totalPaginas) {
    echo '<a href="?pagina=' . ($paginaAtual + 1) . '">&gt;</a>'; // Próxima página
    echo '<a href="?pagina=' . $totalPaginas . '">&gt;&gt;</a>'; // Última página
}

echo '</div>';
?>
