<?php
session_start();
require '../conexao.php';

// Verifique se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location:../login.php");
    exit;
}

// Verifique se o parâmetro 'id' foi enviado
if (isset($_GET['id'])) {
    $orderId = $_GET['id'];
    
    
  

    // Verifique se o usuário logado é o dono da ordem de compra
    $userId = $_SESSION['user_name'];
    $sql = "SELECT * FROM ordens_compra WHERE id = :orderId AND user = :userId";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':orderId', $orderId, PDO::PARAM_INT);
    $stmt->bindParam(':userId', $userId, PDO::PARAM_STR);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
    
  
    // Consultar a tabela ordens_compra usando o ID
$id = $orderId; // Certifique-se de que $id esteja definido corretamente
$sql = "SELECT * FROM ordens_compra WHERE id = :id";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':id', $id, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetch(PDO::FETCH_ASSOC);


if ($row) {
    // Obter os valores das colunas
    
    
    
    
    $quantidade = $row['quantidade'];
    $valor = $row['valor'];
    $referencia = $row['dataehora'];

    // Calcular o resultado
    $resultado = bcmul($quantidade, $valor, 2);

    // Inserir na tabela mempool
    $destinatario = $_SESSION['user_wallet'];

        $newreferencia = "Apagou a ordem de compra, criada em $newreferencia";
    
    
    
    $sqlMempool = "INSERT INTO mempool (destinatario, valor, referencia) VALUES (:destinatario, :valor, :referencia)";
    $stmtMempool = $pdo->prepare($sqlMempool);
    $stmtMempool->bindParam(':destinatario', $destinatario, PDO::PARAM_STR);
    $stmtMempool->bindParam(':valor', $resultado, PDO::PARAM_STR);
    $stmtMempool->bindParam(':referencia', $newreferencia, PDO::PARAM_STR);

    if ($stmtMempool->execute()) {
        // Inserido na tabela mempool com sucesso
        // Você pode adicionar código adicional aqui, se necessário
    } else {
        echo "Erro ao inserir dados na tabela mempool: " . $stmtMempool->errorInfo()[2];
        exit;
    }
    
    
    
    
    
    
} else {
    echo "Ordem de compra não encontrada.";

}

    
        // O usuário é o dono da ordem de compra, então pode apagar
        $sqlDelete = "DELETE FROM ordens_compra WHERE id = :orderId";
        $stmtDelete = $pdo->prepare($sqlDelete);
        $stmtDelete->bindParam(':orderId', $orderId, PDO::PARAM_INT);

        if ($stmtDelete->execute()) {
        
        
            // Ordem de compra apagada com sucesso
            $_SESSION['msg'] = "Ordem de compra apagada com sucesso.";
        } else {
            $_SESSION['msg'] = "Erro ao apagar a ordem de compra.";
        }
    } else {
        $_SESSION['msg'] = "Você não tem permissão para apagar esta ordem de compra.";
    }
} else {
    $_SESSION['msg'] = "Parâmetro 'id' não especificado.";
}

// Redirecione de volta para a página de ordens de compra
header("Location: ordenscompra.php");
exit;
 ?>