<?php
session_start();
require 'conexao.php';
// Falta volocar a direção certa pra onde foi e impedir o jogador de mover pro mar e/ou após o limite do mapa.
if (isset($_POST['mover'])) {
    $direcao = $_POST['direcao'];
    $nomePersonagem = $_SESSION['personagem']; // Obtém o nome do personagem da sessão
    $livre = "livre";
    $user_name = $_SESSION['user_name'];

    if ($direcao == '') { 
        header("Location: dashboardmed.php");
        exit;
    }

    try {
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Obtém o ID do personagem e sua localização atual
        $sql = "SELECT id, local FROM personagens WHERE id = :nomePersonagem";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':nomePersonagem', $nomePersonagem, PDO::PARAM_STR);
        $stmt->execute();
        $personagemData = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$personagemData) {
            echo "Personagem não encontrado!";
            exit;
        }

        $personagemId = $personagemData['id'];
        $origem = $personagemData['local'];

        // Verifica o tempo do último movimento
        $sql = "SELECT data FROM movpersonagens WHERE personagem = :personagemId ORDER BY data DESC LIMIT 1";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':personagemId', $personagemId, PDO::PARAM_INT);
        $stmt->execute();
        $ultimoMovimento = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($ultimoMovimento) {
            $tempoUltimoMovimento = strtotime($ultimoMovimento['data']);
            $tempoAtual = time();
            
            if (($tempoAtual - $tempoUltimoMovimento) < 30) {
                $_SESSION['msg'] = "Ainda não pode se mover! Aguarde mais " . (30 - ($tempoAtual - $tempoUltimoMovimento)) . " segundos.";
                header("Location: dashboardmed.php");
                exit;
            }
        }

        // Obtém o nome da nova localização
        $sql = "SELECT nome FROM mapasmed WHERE id2 = :direcao";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':direcao', $direcao, PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Verifica se o destino é válido e não vazio
        if (!$result || empty($result['nome'])) {
            $_SESSION['msg'] = "Você não pode se mover para esse destino.";
            header("Location: dashboardmed.php");
            exit;
        }

        $destino = $result['nome'];

        // Armazena o movimento na tabela movpersonagens
        $sql = "INSERT INTO movpersonagens (personagem, direção, origem, destino, jogador, data) 
                VALUES (:personagemId, :direcao, :origem, :destino, :jogador, NOW())";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':personagemId', $personagemId, PDO::PARAM_INT);
        $stmt->bindParam(':direcao', $direcao, PDO::PARAM_STR);
        $stmt->bindParam(':origem', $origem, PDO::PARAM_STR);
        $stmt->bindParam(':destino', $destino, PDO::PARAM_STR);
        $stmt->bindParam(':jogador', $user_name, PDO::PARAM_STR);
        $stmt->execute();

        // Atualiza a localização do personagem
        $sql = "UPDATE personagens SET situacao = :livre, local = :destino WHERE id = :personagemId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':livre', $livre, PDO::PARAM_STR);
        $stmt->bindParam(':destino', $destino, PDO::PARAM_STR);
        $stmt->bindParam(':personagemId', $personagemId, PDO::PARAM_INT);
        $stmt->execute();

        header("Location: dashboardmed.php");
        exit;
    } catch (PDOException $e) {
        echo "Erro: " . $e->getMessage();
    }
}
?>
