<?php
include 'conexao.php';

// Consulta principal
$query = "
    (SELECT 'personagem' AS tipo, personagem AS nome, valor 
     FROM ordem_vendas 
     WHERE valor IS NOT NULL
     ORDER BY valor ASC 
     LIMIT 5)
    
    UNION ALL
    
    (SELECT 'ficha' AS tipo, 'Ficha' AS nome, preco AS valor 
     FROM fichaspersonagens 
     WHERE situacao = 'vendendo' AND preco IS NOT NULL
     ORDER BY preco ASC 
     LIMIT 5)
    
    ORDER BY valor ASC 
    LIMIT 5
";

try {
    $result = $pdo->query($query);
    $vendas = $result->fetchAll(PDO::FETCH_ASSOC);
    $rowCount = count($vendas);
} catch (PDOException $e) {
    die("Erro na consulta: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Ordens de Venda</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 10px;
            padding: 0;
            background-color: #f5f5f5;
        }
        .vendas-container {
            min-width: 215px;
            max-width: 215px;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .vendas-header {
            background-color: #343a40;
            color: white;
            padding: 10px;
            font-size: 14px;
            text-align: center;
        }
        .venda-item {
            padding: 8px 10px;
            border-bottom: 1px solid #eee;
            font-size: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .no-data {
            padding: 15px;
            text-align: center;
            color: #6c757d;
            font-style: italic;
        }
        .tipo-badge {
            display: inline-flex;
            justify-content: center;
            align-items: center;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            font-size: 10px;
            font-weight: bold;
            margin-right: 5px;
        }
        .badge-personagem {
            background-color: #007bff;
            color: white;
        }
        .badge-ficha {
            background-color: #ffc107;
            color: #343a40;
        }
        .venda-nome {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 130px;
            color: #000; /* Texto sempre preto */
        }
        .venda-valor {
            font-weight: bold;
            color: #28a745;
        }
    </style>
</head>
<body>

<div class="vendas-container">
    <div class="vendas-header">Fichas/Personagens a venda</div>
    
    <?php if($rowCount > 0): ?>
        <?php foreach($vendas as $venda): ?>
        <div class="venda-item">
            <div style="display: flex; align-items: center;">
                <span class="tipo-badge <?= $venda['tipo'] == 'personagem' ? 'badge-personagem' : 'badge-ficha' ?>">
                    <?= strtoupper(substr($venda['tipo'], 0, 1)) ?>
                </span>
                <span class="venda-nome">
                    <?= htmlspecialchars($venda['nome']) ?>
                </span>
            </div>
            <div class="venda-valor">R$ <?= number_format($venda['valor'], 2, ',', '.') ?></div>
        </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="no-data">Sem dados disponíveis</div>
    <?php endif; ?>
</div>

</body>
</html>