<?php
// Inclui o arquivo de conexão
include 'conexao.php';

// Busca dados das vendas nas últimas 24 horas
$query = "SELECT quantidade, preco, dataehora FROM vendas";

try {
    $result = $pdo->query($query);

    $labels = [];
    $values = [];

    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
    $labels[] = $row['dataehora'];
    $values[] = $row['preco'];
}

} catch (PDOException $e) {
    die("Erro na consulta ao banco de dados: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Gráfico de Variação de Preço de Vendas</title>
    <!-- Inclua os scripts e estilos do Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: black;
            color: white;
        }

        .container {
           width: 80%; 
            margin: auto;
            background-color: black;
            
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            
            
           
            
        }

        .current-price {
            font-size: 24px;
            
            margin-bottom: 10px;
        }
    
    </style>

</head>
<body>
    <div class="container">
        <canvas id="myChart"></canvas>
    </div>

    <script>
        // Arrays de rótulos e valores
        var labels = <?php echo json_encode($labels); ?>;
        var values = <?php echo json_encode($values); ?>;

        // Configuração do gráfico
        var ctx = document.getElementById('myChart').getContext('2d');
        var chart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: labels,
        datasets: [{
            label: 'Preço',
            data: values,
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            borderColor: 'rgba(75, 192, 192, 1)',
            borderWidth: 1,
            fill: true
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: false // para exibir valores negativos no eixo Y
             
            }
        },
        plugins: {
            tooltip: {
                callbacks: {
                    label: function(context) {
                        var label = context.dataset.label || '';
                        if (label) {
                            label += ': ';
                        }
                        if (context.parsed.y !== null) {
                            label += ' $' + context.parsed.y.toFixed(2); // Exibe o valor formatado com duas casas decimais

                            if (context.dataIndex > 0) {
                                var prevValue = values[context.dataIndex - 1];
                                var change = context.parsed.y - prevValue;
                                label += ' (' + (change >= 0 ? '+' : '') + change.toFixed(2) + ')';
                            }
                        }
                        return label;
                    }
                }
            }
        }
    }
});

    </script>
    <center>
    <?php
    
    // Busca o preço mais recente da tabela de vendas
$query = "SELECT preco FROM vendas ORDER BY dataehora DESC LIMIT 1";

try {
    $result = $pdo->query($query);
    $lastPrice = $result->fetchColumn();
} catch (PDOException $e) {
    die("Erro na consulta ao banco de dados: " . $e->getMessage());
}
?>


    <div class="container">
        <h2 class="current-price">Preço atual do personagem: R$ <?php echo number_format($lastPrice, 2); ?></h2>
    </div>
    
</body>
</html>
