<?php
session_start();
require '../conexao.php'; // Inclui o arquivo de conexão

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$jogador_logado = $_SESSION['user_name']; // ID do jogador logado

// Consulta para listar as fichas à venda, ordenadas pelo preço
try {
    $sql = "SELECT * FROM fichaspersonagens WHERE situacao = 'vendendo' ORDER BY preco ASC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $fichas_a_venda = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Erro ao listar fichas: " . $e->getMessage();
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Fichas à Venda</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
</head>
<body>
    <div class="titulo">Fichas à Venda</div>
    <center>
        <?php
        if (isset($_SESSION['msg'])) {
            echo '<p class="mensagem">' . $_SESSION['msg'] . '</p>';
            unset($_SESSION['msg']);
        }
        ?>
    </center>
    <table border="1">
        <tr>
            <th>ID</th>
            <th>Jogador</th>
            <th>Quantidade</th>
            <th>Preço</th>
            <th>Ações</th>
        </tr>
        <?php foreach ($fichas_a_venda as $ficha): ?>
            <tr>
                <td><?= $ficha['id'] ?></td>
                <td><?= $ficha['jogador'] ?></td>
                <td><?= $ficha['quantidade'] ?></td>
                <td>R$ <?= number_format($ficha['preco'], 2, ',', '.') ?></td>
                <td>
                    <?php if ($ficha['jogador'] === $jogador_logado): ?>
                        <form method="POST" action="cancelar_venda.php" style="display:inline;">
                            <input type="hidden" name="id_ficha" value="<?= $ficha['id'] ?>">
                            <button type="submit">Cancelar Venda</button>
                        </form>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>