<?php
session_start();
require '../conexao.php';

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// Processar transferência de personagem
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['transferir_personagem'])) {
    $personagem_id = $_POST['personagem_id'];
    $novo_jogador = trim($_POST['novo_jogador']);
    
    try {
        $pdo->beginTransaction();
        
        // 1. Verificar se o personagem ainda existe e pertence ao jogador atual
        $stmt = $pdo->prepare("SELECT * FROM personagens WHERE id = ? AND jogador = ?");
        $stmt->execute([$personagem_id, $user_name]);
        $personagem = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$personagem) {
            throw new Exception("Personagem não encontrado ou não pertence a você!");
        }
        
        // 2. Verificar se o novo jogador existe e é diferente do atual
        if ($novo_jogador === $user_name) {
            throw new Exception("Você não pode transferir para si mesmo!");
        }
        
        $stmt = $pdo->prepare("SELECT user FROM usersblock WHERE user = ?");
        $stmt->execute([$novo_jogador]);
        $jogador_existe = $stmt->fetchColumn();
        
        if (!$jogador_existe) {
            throw new Exception("Jogador destino não encontrado!");
        }
        
        // 3. Registrar na tabela infossistema
        $info = "O jogador {$user_name} transferiu o personagem {$personagem['personagem']} (ID: {$personagem['id']}) para o jogador {$novo_jogador}. ";
        $info .= "Dados: Soldados={$personagem['soldados']}, Ouro={$personagem['ouro']}, Prata={$personagem['prata']}, ";
        $info .= "Cargo={$personagem['cargo']}, Criado em={$personagem['datacriacao']}";
        
        $stmt = $pdo->prepare("INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) 
                              VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute([
            $info,
            $user_name,
            $novo_jogador,
            'Transferência de Personagem'
        ]);
        
        // 4. Atualizar o dono do personagem
        $stmt = $pdo->prepare("UPDATE personagens SET jogador = ?, datamovimentacao = NOW() WHERE id = ?");
        $stmt->execute([$novo_jogador, $personagem_id]);
        
        $pdo->commit();
        
        echo "<script>
                alert('Personagem transferido com sucesso!');
                window.location.href = window.location.pathname;
              </script>";
        exit();
        
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "<script>alert('Erro: ".addslashes($e->getMessage())."');</script>";
    }
}

// Buscar todos os personagens do jogador em ordem alfabética
$stmt = $pdo->prepare("SELECT id, personagem FROM personagens WHERE jogador = ? ORDER BY personagem ASC");
$stmt->execute([$user_name]);
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transferir Personagens</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        :root {
            --azul-vivo: #0000FF;
            --azul-hover: #1E90FF;
            --verde-ativo: #00AA00;
            --vermelho-inativo: #AA0000;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #1a1a1a;
            color: #e0e0e0;
            margin: 0;
            padding: 20px;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #2a2a2a;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        
        h1, h2 {
            color: var(--azul-vivo);
            text-align: center;
        }
        
        .form-transferencia {
            background-color: #333;
            border-radius: 8px;
            padding: 20px;
            margin: 20px auto 0;
            width: 90%;
            max-width: 500px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
        }
        
        select, input {
            width: 100%;
            padding: 12px;
            border-radius: 6px;
            border: 1px solid #555;
            background-color: #444;
            color: #fff;
            font-size: 16px;
            box-sizing: border-box;
        }
        
        .btn-transferir {
            background-color: var(--azul-vivo);
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
            transition: all 0.3s;
            width: 100%;
            margin-top: 15px;
            font-size: 16px;
        }
        
        .btn-transferir:hover {
            background-color: var(--azul-hover);
            transform: scale(1.02);
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 24px;
        }
   
    /*  CENTRALIZAR SELECT */
    
    select {
        width: 100%;
        padding: 12px;
        border-radius: 6px;
        border: 1px solid #555;
        background-color: #444;
        color: #fff;
        font-size: 16px;
        box-sizing: border-box;
        text-align: center;
        text-align-last: center;
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='white'%3e%3cpath d='M7 10l5 5 5-5z'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 10px center;
        background-size: 20px;
    }
    
    select option {
        text-align: center;
        background-color: #444;
        padding: 10px;
    }
</style>
    <script>
        function confirmarTransferencia(form) {
            const personagem = form.personagem_id.options[form.personagem_id.selectedIndex].text;
            const novoJogador = form.novo_jogador.value;
            
            if (!personagem || !novoJogador) {
                alert('Por favor, preencha todos os campos!');
                return false;
            }
            
            if (confirm(`CONFIRMAR TRANSFERÊNCIA:\n\nPersonagem: ${personagem}\nPara o jogador: ${novoJogador}\n\nEsta ação é irreversível!`)) {
                return true;
            }
            return false;
        }
    </script>
</head>
<body>
<center>
<img class="bn" src="../bn.png" alt=""><br><br>
<h1>Transferir Personagens</h1>
<a href="../dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>
<a href="../admpersonagens.php"><button class="btnmenu">Administração de personagem</button></a><br><br><br>

<div class="container">
    <h2>Transferência de Personagens</h2>
    
    <form method="POST" class="form-transferencia" onsubmit="return confirmarTransferencia(this)">
        <div class="form-group">
            <label for="personagem_id">Selecione o Personagem a trasferir</label>
            <select name="personagem_id" id="personagem_id" required>
                <option value="">-- Selecione um personagem --</option>
                <?php foreach ($personagens as $p): ?>
                    <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['personagem']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="form-group">
            <label for="novo_jogador">Jogador de Destino do personagem</label>
            <input type="text" name="novo_jogador" id="novo_jogador" maxlength="25" required 
                   placeholder="Digite o nome do jogador">
        </div>
        
        <button type="submit" name="transferir_personagem" class="btn-transferir">
            TRANSFERIR PERSONAGEM
        </button>
    </form>
</div>

<div class="footer">
    ⚔️ RPG Era Medieval ⚔️
</div>
</body>
</html>


