<?php
session_start();
require 'conexao.php';

// Verifique se o usuário está logado
if (!isset($_SESSION['user_id'], $_SESSION['user_name'])) {
    header("Location: login.php");
    exit;
}

// Verifique se o ID do campeonato foi enviado
if (!isset($_GET['idcamp']) || empty($_GET['idcamp'])) {
    die("ID do campeonato não foi fornecido.");
}

$idcamp = intval($_GET['idcamp']);
$user_name = $_SESSION['user_name'];
$data_inscricao = date('Y-m-d H:i:s');
$tipoinscricao = 'normal'; // Exemplo de tipo de inscrição

try {
    // Insere na tabela de inscrições
    $stmt = $pdo->prepare("INSERT INTO inscricoes (idcamp, inscrito, data_inscricao, tipoinscricao) VALUES (:idcamp, :inscrito, :data_inscricao, :tipoinscricao)");
    $stmt->bindParam(':idcamp', $idcamp, PDO::PARAM_INT);
    $stmt->bindParam(':inscrito', $user_name, PDO::PARAM_STR);
    $stmt->bindParam(':data_inscricao', $data_inscricao);
    $stmt->bindParam(':tipoinscricao', $tipoinscricao, PDO::PARAM_STR);

    $stmt->execute();

    echo "Inscrição realizada com sucesso!";
    echo "<p><a href='lista_campeonatos.php'>Voltar à Lista de Campeonatos</a></p>";
} catch (PDOException $e) {
    die("Erro ao processar a inscrição: " . $e->getMessage());
}
?>
