<?php
session_start();
require 'conexao.php';

session_start();

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}

?>

<!DOCTYPE html>
<html>
<head>
<style>

   .bordabranca {
            border: 4px solid #fff;
            border-radius: 15px;
            padding: 10px;
            max-width: 90%;
            margin: 0 auto;
            word-wrap: break-word;
        }
        
        .hr {
        border: 8px solid #fff;
            
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        li {
            margin-bottom: 20px; /* Adiciona duas quebras de linha após cada linha da tabela */
        }
        </style>

    <title>Transações</title>
    <link rel="stylesheet" type="text/css" href="style.css">

    
</head>




<body>
<img class="bn" src="bn.png" alt="">   <br><br>
        <div class="titulo">Meus recibos</div>
        <a href="dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>

        <?php
        // Consulta na tabela mempool onde o destinatário é igual à $_SESSION['user_wallet']
        try {
            $stmt = $pdo->prepare("SELECT remetente, valor, dataehora, referencia FROM mempool WHERE destinatario = :destinatario ORDER BY dataehora DESC;");
            $stmt->bindParam(':destinatario', $_SESSION['user_wallet']);
            $stmt->execute();
            $recibos = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if (count($recibos) > 0) {
                echo '<ul>';
                foreach ($recibos as $recibo) {
                    echo '<li><div class="bordabranca">Remetente:<br> ' . $recibo['remetente'] . '<br><hr>Valor:<br>R$ ' . $recibo['valor'] . '<br><hr>Data & Hora: <br>' . $recibo['dataehora'] . '<br><hr>referência:<br>' . $recibo['referencia'] . '</div></li><br><br>'; /* Adiciona duas quebras de linha após cada linha da tabela */
                }
                echo '</ul>';
            } else {
                echo '<p>Nenhum recibo não validado encontrado.</p>';
            }
        } catch (PDOException $e) {
            echo '<p>Erro na consulta: ' . $e->getMessage() . '</p>';
        }
        ?>
    

    <br><br>
    </body>
</html>

