<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    .tabuleiro {
      display: grid;
      grid-template-columns: repeat(12, 50px);
      grid-gap: 2px;
      border: 2px solid black;
      width: 614px;
      margin: 0 auto;
    }
    .celula {
      width: 50px;
      height: 50px;
      background-color: white;
      border: 1px solid black;
      cursor: pointer;
    }
    .preto {
      background-color: black;
    }
    .peca {
      background-color: red;
      border-radius: 50%;
    }
    .peca.selecionada {
      background-color: yellow;
    }
  </style>
  <title>Tabuleiro 12x12</title>
</head>
<body>
  <div class="tabuleiro" id="tabuleiro"></div>
  <script>
    var tabuleiro = document.getElementById("tabuleiro");
    var celulas = [];

    for (var i = 0; i < 12 * 12; i++) {
      var celula = document.createElement("div");
      celula.classList.add("celula");

      celulas.push(celula);
      tabuleiro.appendChild(celula);
    }

    var pecaSelecionada = null;

    for (var i = 0; i < celulas.length; i++) {
      celulas[i].addEventListener("click", function() {
        if (this.classList.contains("peca")) {
          if (pecaSelecionada === this) {
            pecaSelecionada.classList.remove("selecionada");
            pecaSelecionada = null;
          } else {
            if (pecaSelecionada) {
              pecaSelecionada.classList.remove("selecionada");
            }
            pecaSelecionada = this;
            this.classList.add("selecionada");
          }
        } else if (pecaSelecionada) {
          if (this.classList.contains("preto")) {
            return; // Não pode mover para célula preta
          }
          this.classList.add("peca");
          pecaSelecionada.classList.remove("peca", "selecionada");
          pecaSelecionada = null;
        }
      });
    }
  </script>
</body>
</html>
