<?php
session_start();
require 'conexao.php';

// Verifique se o usuário está logado
if (!isset($_SESSION['user_id'], $_SESSION['user_name'])) {
    header("Location: login.php");
    exit;
}

// Verifique se o ID do campeonato foi enviado
if (!isset($_GET['idcamp']) || empty($_GET['idcamp'])) {
    die("ID do campeonato não foi fornecido.");
}

$idcamp = intval($_GET['idcamp']); // Obtém o ID do campeonato
$user_name = $_SESSION['user_name'];
$saldo = $_SESSION['saldo'];

try {
    // Busca os dados do campeonato
    $stmt = $pdo->prepare("SELECT valorficha, valordinheiro, nomedocamp FROM campeonatos WHERE id = :idcamp AND status = 0");
    $stmt->bindParam(':idcamp', $idcamp, PDO::PARAM_INT);
    $stmt->execute();
    $campeonato = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$campeonato) {
        die("Campeonato não encontrado ou já não está disponível para inscrições.");
    }

    $valorficha = $campeonato['valorficha'];
    $valordinheiro = $campeonato['valordinheiro'];

    // Verifica fichas disponíveis para o jogador com o valor específico
    $stmt = $pdo->prepare("SELECT id, quantidade FROM fichas WHERE jogador = :user_name AND preco = :valorficha");
    $stmt->bindParam(':user_name', $user_name, PDO::PARAM_STR);
    $stmt->bindParam(':valorficha', $valorficha, PDO::PARAM_STR);
    $stmt->execute();
    $ficha = $stmt->fetch(PDO::FETCH_ASSOC);

    $tem_fichas = $ficha && $ficha['quantidade'] > 0;

} catch (PDOException $e) {
    die("Erro ao buscar dados: " . $e->getMessage());
}

// Processar inscrição
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['inscrever_ficha'])) {
        if ($tem_fichas) {
            // Diminui 1 ficha do valor correspondente
            $stmt = $pdo->prepare("UPDATE fichas SET quantidade = quantidade - 1 WHERE id = :ficha_id");
            $stmt->bindParam(':ficha_id', $ficha['id'], PDO::PARAM_INT);
            $stmt->execute();

            // Inscreve o jogador
            $stmt = $pdo->prepare("INSERT INTO inscricoes (idcamp, inscrito) VALUES (:idcamp, :user_name)");
            $stmt->bindParam(':idcamp', $idcamp, PDO::PARAM_INT);
            $stmt->bindParam(':user_name', $user_name, PDO::PARAM_STR);
            $stmt->execute();

            header("Location: sucesso.php?msg=inscrito_com_ficha");
            exit;
        } else {
            $erro = "Você não possui fichas suficientes para se inscrever.";
        }
    }

    if (isset($_POST['inscrever_dinheiro'])) {
        if ($saldo >= $valordinheiro) {
            // Diminui o saldo do jogador
            $_SESSION['saldo'] -= $valordinheiro; // Atualiza saldo na sessão
            $stmt = $pdo->prepare("UPDATE usuarios SET saldo = saldo - :valordinheiro WHERE nome = :user_name");
            $stmt->bindParam(':valordinheiro', $valordinheiro, PDO::PARAM_STR);
            $stmt->bindParam(':user_name', $user_name, PDO::PARAM_STR);
            $stmt->execute();

            // Inscreve o jogador
            $stmt = $pdo->prepare("INSERT INTO inscricoes (idcamp, inscrito) VALUES (:idcamp, :user_name)");
            $stmt->bindParam(':idcamp', $idcamp, PDO::PARAM_INT);
            $stmt->bindParam(':user_name', $user_name, PDO::PARAM_STR);
            $stmt->execute();

            header("Location: sucesso.php?msg=inscrito_com_dinheiro");
            exit;
        } else {
            $erro = "Você não possui saldo suficiente para se inscrever.";
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Inscrição no Campeonato</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <h1>Inscrição no Campeonato</h1>
    
    <h2><?php echo htmlspecialchars($campeonato['nomedocamp'] ?? ''); ?></h2>
    <p><strong>Valor da inscrição com ficha:</strong> <?= $valorficha > 0 ? htmlspecialchars($valorficha) . " por ficha" : "Gratuito" ?></p>
    <p><strong>Valor da inscrição com dinheiro:</strong> <?= $valordinheiro > 0 ? "R$ " . htmlspecialchars($valordinheiro) : "Gratuito" ?></p>

    <?php if (isset($erro)): ?>
        <p style="color: red;"><?php echo $erro; ?></p>
    <?php endif; ?>

    <form method="POST">
        <?php if ($valorficha > 0 || $valordinheiro > 0): ?>
            <button type="submit" name="inscrever_ficha" <?= !$tem_fichas ? 'disabled' : '' ?>>Inscrever-se com ficha</button>
            <button type="submit" name="inscrever_dinheiro" <?= $saldo < $valordinheiro ? 'disabled' : '' ?>>Inscrever-se com dinheiro</button>
        <?php else: ?>
            <button type="submit" name="inscrever_gratuito">Inscrever-se gratuitamente</button>
        <?php endif; ?>
    </form>

    <p><a href="dashboard.php">Voltar ao Menu Principal</a></p>
</body>
</html>
