<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
    exit();
}

// Processamento do formulário
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Recebe os dados do formulário
    $nomecamp = isset($_POST['nomecamp']) ? trim($_POST['nomecamp']) : null;
    $informacoes = isset($_POST['descricao']) ? trim($_POST['descricao']) : null;
    $premio1 = isset($_POST['premio1']) ? trim($_POST['premio1']) : null;
    $premio2 = isset($_POST['premio2']) ? trim($_POST['premio2']) : null;
    $premio3= isset($_POST['premio3']) ? trim($_POST['premio3']) : null;
    
    
    $premio4 = isset($_POST['premio4']) ? trim($_POST['premio4']) : null;
    
    $premio5 = isset($_POST['premio5']) ? trim($_POST['premio5']) : null;
    
    
    
    
    
    $minimop = isset($_POST['minimop']) ? trim($_POST['minimop']) : null;
    $maximop = isset($_POST['maximop']) ? trim($_POST['maximop']) : null;
    $duracaoturno = isset($_POST['duracaoturno']) ? trim($_POST['duracaoturno']) : null;
    $minvezpulada = isset($_POST['minvezpulada']) ? trim($_POST['minvezpulada']) : null;
    $automatico = isset($_POST['automatico']) ? $_POST['automatico'] : null;
    $criador = $_SESSION['user_name']; // ID do criador (usuário logado)
    $dataCriacao = date("Y-m-d H:i:s"); // Data e hora de criação do campeonato



    // Validações para garantir que os campos essenciais sejam preenchidos e estejam corretos
    if (empty($nomecamp) || !is_numeric($premio1) || !is_numeric($minimop) || !is_numeric($duracaoturno) || !is_numeric($minvezpulada)) {
        $_SESSION['msg'] = "Por favor, preencha todos os campos corretamente!";
        header("Location: criandocampeonato.php");
        exit();
    }

    // Validação para o campo 'duracaoturno' - precisa ser um número válido
    if (empty($duracaoturno) || !is_numeric($duracaoturno)) {
        $_SESSION['msg'] = "A duração por turno deve ser um número válido!";
        header("Location: criandocampeonato.php");
        exit();
    }

    // Validação para o campo 'minvezpulada' - precisa ser um número válido
    if (empty($minvezpulada) || !is_numeric($minvezpulada)) {
        $_SESSION['msg'] = "O mínimo de vezes que o jogador pode ser pulado deve ser um número válido!";
        header("Location: criandocampeonato.php");
        exit();
    }

    // Preparação da consulta para inserir os dados na tabela 'campeonatos'
    try {
        $stmt = $pdo->prepare("
            INSERT INTO campeonatos (
                nomedocamp, informacoes, 1st, 2st, 3st, 4st, 5st,  minimop, maximop, duracaoturno, minvezpulada, datacriacao, criador, automatico
            ) VALUES (
                :nomecamp, :informacoes, :premio1, :premio2, :premio3, :premio4, :premio5, :minimop, :maximop, :duracaoturno, :minvezpulada, :datacriacao, :criador, :automatico
            )
        ");

        // Vinculação dos parâmetros
        $stmt->bindParam(':nomecamp', $nomecamp);
        $stmt->bindParam(':informacoes', $informacoes);
        $stmt->bindParam(':premio1', $premio1);
        $stmt->bindParam(':premio2', $premio2);
        $stmt->bindParam(':premio3', $premio3);
        $stmt->bindParam(':premio4', $premio4);
        $stmt->bindParam(':premio5', $premio5);
        
        $stmt->bindParam(':minimop', $minimop, PDO::PARAM_INT);
        $stmt->bindParam(':maximop', $maximop, PDO::PARAM_INT);
        $stmt->bindParam(':duracaoturno', $duracaoturno, PDO::PARAM_STR); // Passando como string para DECIMAL
        $stmt->bindParam(':minvezpulada', $minvezpulada, PDO::PARAM_INT);
        $stmt->bindParam(':datacriacao', $dataCriacao);
        $stmt->bindParam(':criador', $criador);
        $stmt->bindParam(':automatico', $automatico, PDO::PARAM_INT);

        // Execute a inserção
        $stmt->execute();

        // Mensagem de sucesso
        $_SESSION['msg'] = "Campeonato criado com sucesso!";
        header("Location: dashboard.php"); // Redireciona para o painel do usuário
        exit();
    } catch (PDOException $e) {
        // Mensagem de erro
        $_SESSION['msg'] = "Erro ao criar o campeonato: " . $e->getMessage();
        header("Location: criandocampeonato.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Criar campeonato</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
  <img class="bn" src="bn.png" alt=""><br><br><br>

  <a href="dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>

  <div class="titulo">Criar campeonato</div>

  <br>

  <?php if (isset($_SESSION['msg'])): ?>
      <div class="msg">
          <span><?php echo $_SESSION['msg']; ?></span>
      </div>
      <?php unset($_SESSION['msg']); ?>
  <?php endif; ?>

  <form method="POST" action="criandocampeonato.php" onsubmit="return confirmarEnvio()">
      <input type="text" name="nomecamp" id="nomecamp" placeholder="Nome do campeonato" maxlength="8" required><br><br>
      <textarea name="descricao" id="descricao" placeholder="Descrição do campeonato" maxlength="9999"></textarea><br><br>
      <input type="number" name="minimop" id="minimop" placeholder="Mínimo de jogadores" maxlength="5" required><br><br>
      <input type="number" name="maximop" id="maximop" placeholder="Máximo de jogadores" maxlength="5"><br><br>
      <input type="number" name="premio1" id="premio1" placeholder="Premio 1° lugar" maxlength="8"><br><br>
      <input type="number" name="premio2" id="premio2" placeholder="Premio 2° lugar" maxlength="8"><br><br>
      <input type="number" name="premio3" id="premio3" placeholder="Premio 3° lugar" maxlength="8"><br><br>
      <input type="number" name="premio4" id="premio4" placeholder="Premio 4° lugar" maxlength="8"><br><br>
      <input type="number" name="premio5" id="premio5" placeholder="Premio 5° lugar" maxlength="8"><br><br>
      <input type="number" name="duracaoturno" id="duracaoturno" placeholder="Duração por turno (minutos)" maxlength="5" step="0.01" required><br><br>
      <input type="number" name="minvezpulada" id="minvezpulada" placeholder="Mínimo de vezes que o jogador pode ser pulado" required><br><br>
      <select name="automatico" required>
          <option value="0">Não</option>
          <option value="1">Sim</option>
      </select><br><br>

      <input type="submit" value="Criar campeonato">
  </form>

  <script>
      function confirmarEnvio() {
          var confirmacao = confirm("Você deseja criar o campeonato?");
          return confirmacao;
      }
  </script>

</body>
</html>
