<?php
session_start();
require 'conexao.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Minerar</title>
<link rel="stylesheet" type="text/css" href="style.css">


    
</head>
<body>
    <h1>Minerar Latilas</h1>

    <h1>Escolha a moeda que vai minerar:</h1>
    <form action="#" method="post">
        <select name="moeda" id="moeda">
            <option value="Latila">Latila</option>
        </select>
    </form>

    <h2>Moeda selecionada: <span id="moedaSelecionada">Latila</span></h2>



<h1> block </h1>



<?php

// Consulta SQL para obter o total de moedas no cofre
try {
    $stmt = $pdo->prepare("SELECT SUM(quantidade) AS total_moedas FROM cofre WHERE validade >= NOW()");
    $stmt->bindParam(':wallet', $_SESSION['user_wallet']);
    $stmt->execute();
    
    $totalMoedasCofre = $stmt->fetch(PDO::FETCH_ASSOC)['total_moedas'];
    
    // Utilize BCMath para garantir 10 casas decimais
    $totalMoedasCofre = bcmul($totalMoedasCofre, 1, 10);
    
    echo "Total de moedas no cofre: " . $totalMoedasCofre;
} catch (PDOException $e) {
    echo "Erro na consulta: " . $e->getMessage();
}
?>

<br><br>



Aqui

<?php
// Realiza a busca no cofre para encontrar todas as linhas com wallet igual à $_SESSION['user_wallet']
try {
    require_once 'conexao.php';

    $userWallet = $_SESSION['user_wallet'];

    $stmt = $pdo->prepare("SELECT quantidade FROM cofre WHERE wallet = :wallet");
    $stmt->bindParam(':wallet', $userWallet);
    $stmt->execute();

    $depositocofre = "0";
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $quantidade = $row['quantidade'];
        $depositocofre = bcadd($depositocofre, $quantidade, 10);
    }

    // Calcula a porcentagem do valor no cofre em relação ao valor total de moedas
    $porcentagemDeposito = bcmul(bcdiv($depositocofre, $totalMoedas, 10), "100", 2);

    echo "<h1>Busca no Cofre</h1>";
    echo "<p>Meus depósitos no cofre: $depositocofre</p>";
    } catch (PDOException $e) {
    echo "Erro na busca no cofre: " . $e->getMessage();
}
?>






<?php
// Supondo que você já tenha o valor de $depositocofre e $totalMoedasCofre

// Utilize BCMath para garantir 10 casas decimais
$porcentagemCofre = bcmul(bcdiv($depositocofre, $totalMoedasCofre, 10), 100, 2);

echo "Porcentagem no cofre: " . $porcentagemCofre . "%";


 ?>



<br><br>




<?php
// Supondo que você já tenha o valor de $porcentagemCofre (representando a porcentagem do valor total do cofre)

// Define a taxa máxima de mineração (30%) com precisão de 10 casas decimais
$taxaMaximaMineracao = '0.3000000000';

// Calcula a taxa de mineração com base na porcentagem da variável $porcentagemCofre
$taxaMineracao = bcmul($taxaMaximaMineracao, bcdiv($porcentagemCofre, 100, 10), 10);

// Multiplica por 100 para obter a porcentagem final
$taxaMineracaoPorcentagem = bcmul($taxaMineracao, 100, 2);

$_SESSION['taxamineracao'] = $taxaMineracaoPorcentagem;

echo "Taxa de mineração: " . $taxaMineracaoPorcentagem . "%";
?>






// TRANCAR FUNDOS


    <?php
session_start();
require 'conexao.php';
bcscale(10);

// Cálculo do saldo na carteira (baseado na blockchain - tabela block)
try {
    $stmt = $pdo->prepare("SELECT SUM(CASE WHEN remetente = :wallet THEN -quantidade WHEN destinatario = :wallet THEN quantidade ELSE 0 END) AS saldo FROM block");
    $stmt->bindParam(':wallet', $_SESSION['user_wallet']);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_carteira = $result['saldo'];

    // Verificar saldo na tabela cofre e subtrair da variável $saldo_carteira
    $stmt = $pdo->prepare("SELECT SUM(quantidade) AS total_cofre FROM cofre WHERE wallet = :wallet");
    $stmt->bindParam(':wallet', $_SESSION['user_wallet']);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_cofre = $result['total_cofre'];

    // Verificar saldo na tabela mempool e subtrair da variável $saldo_carteira
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_mempool FROM mempool WHERE remetente = :wallet");
    $stmt->bindParam(':wallet', $_SESSION['user_wallet']);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_mempool = $result['total_mempool'];

    if ($saldo_mempool !== null) {
        $saldo_carteira = bcsub($saldo_carteira, $saldo_mempool, 10);
    }

    // Calcular o saldo livre
    $saldo_livre = bcsub($saldo_carteira, $saldo_cofre, 10);

    // Definir as cores para os saldos
    $cor_saldo_carteira = $saldo_carteira >= 0 ? 'darkgreen' : 'darkred';
    $cor_saldo_cofre = 'blue';
    $cor_saldo_livre = $saldo_livre >= 0 ? 'limegreen' : 'darkgreen';
    $_SESSION['latillas'] = $saldo_livre;

} catch (PDOException $e) {
    $saldo_carteira = "Erro na consulta: " . $e->getMessage();
    $saldo_cofre = "Erro na consulta: " . $e->getMessage();
    $saldo_livre = "Erro na consulta: " . $e->getMessage();
}

// Processar o envio do formulário
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['quantidade']) && is_numeric($_POST['quantidade'])) {
        $quantidade = $_POST['quantidade'];
        $wallet = $_SESSION['user_wallet'];

        try {
            // Verificar se o usuário tem fundos suficientes na carteira
            $saldo = bcsub($saldo_carteira, $saldo_cofre, 10);
            if (bccomp($saldo, $quantidade) >= 0) {
                // Inserir os dados na tabela cofre
                $validade = date('Y-m-d H:i:s', strtotime('+6 hours'));
                $stmt = $pdo->prepare("INSERT INTO cofre (wallet, quantidade, dataehora, validade) VALUES (:wallet, :quantidade, NOW(), :validade)");
                $stmt->bindParam(':wallet', $wallet);
                $stmt->bindParam(':quantidade', $quantidade);
                $stmt->bindParam(':validade', $validade);

                if ($stmt->execute()) {
                    $mensagem = "Depósito de $quantidade M$ no Cofre de Mineração realizado com sucesso!";
                    $classeMensagem = "mensagem-sucesso";
                } else {
                    $mensagem = "Erro ao realizar o depósito no Cofre de Mineração.";
                    $classeMensagem = "mensagem-erro";
                }
            } else {
                $mensagem = "Saldo insuficiente na carteira.";
                $classeMensagem = "mensagem-erro";
            }
        } catch (PDOException $e) {
            $mensagem = "Erro na consulta: " . $e->getMessage();
            $classeMensagem = "mensagem-erro";
        }
    }
}
?>

<style>
/* Estilos do CSS */
.mensagem-sucesso {
    color: green;
}

.mensagem-erro {
    color: red;
}
</style>

<!-- Exibição dos saldos -->
<div class="saldos">
    <p>Saldo total: <span style="color: <?php echo $cor_saldo_carteira; ?>"><?php echo $saldo_carteira; ?> M$</span></p>
    <p>Saldo trancado no cofre: <span style="color: <?php echo $cor_saldo_cofre; ?>"><?php echo $saldo_cofre; ?> M$</span></p>
    <p>Saldo livre: <span style="color: <?php echo $cor_saldo_livre; ?>"><?php echo $saldo_livre; ?> M$</span></p>
</div>

<!-- Exibição da mensagem de depósito -->
<?php
if (isset($mensagem)) {
    echo "<p class=\"$classeMensagem\" id=\"mensagem\">$mensagem</p>";
}
?>

<!-- Formulário para enviar a quantidade ao cofre -->
<h1>Trancar M$ no Cofre de Mineração</h1>
<form method="post">
    <label for="quantidade">Quantidade:</label>
    <input type="number" id="quantidade" name="quantidade" step="0.0000000001" required>
    <br><br>
    <input type="submit" value="Trancar Moedas">
</form>

<!-- Script para ocultar a mensagem após 3 segundos -->
<script>
setTimeout(function() {
    document.getElementById('mensagem').style.display = 'none';
}, 3000);
</script>







<br><br>

<!-- Botão para minerar -->
<?php
if (bccomp($saldo_cofre, '0.0000000001', 10) > 0) {
    echo '<a href="minerando.php"><button>Minerar</button></a>';
}
?>



<br><br><br><br><br><br><br><br>






    <script>
        // Define a moeda selecionada inicialmente como "Latila"
        let moedaSelecionada = "Latila";

        // Obtém o elemento select pelo id
        let selectMoeda = document.getElementById("moeda");

        // Define o valor inicial do select como "Latila"
        selectMoeda.value = moedaSelecionada;

        // Atualiza a moeda selecionada sempre que o valor do select mudar
        selectMoeda.addEventListener("change", function() {
            moedaSelecionada = selectMoeda.value;
            document.getElementById("moedaSelecionada").innerText = moedaSelecionada;
        });
    </script>
</body>
</html>
