<?php
session_start();
require 'conexao.php';


// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}

?>

<!DOCTYPE html>
<html>
<head>
<style>

   .bordabranca {
            border: 4px solid #fff;
            border-radius: 15px;
            padding: 10px;
            max-width: 90%;
            margin: 0 auto;
            word-wrap: break-word;
        }
        
        .hr {
        border: 8px solid #fff;
            
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        li {
            margin-bottom: 20px; /* Adiciona duas quebras de linha após cada linha da tabela */
        }
        </style>

    <title>Transações</title>
    <link rel="stylesheet" type="text/css" href="style.css">

    
</head>




<body>
<img class="bn" src="bn.png" alt="">   <br><br>
        <div class="titulo">Meus envios</div>
        <a href="dashboard.php"><button>Menu principal</button></a><br><br>

        
        
        
        <?php
        // Consulta na tabela mempool onde o remetente é igual à $_SESSION['user_wallet']
        try {
            $stmt = $pdo->prepare("SELECT destinatario, valor, dataehora, link FROM mempool WHERE remetente = :remetente ORDER BY dataehora DESC;");
            $stmt->bindParam(':remetente', $_SESSION['user_wallet']);
            $stmt->execute();
            $envios = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if (count($envios) > 0) {
                echo '<ul>';
                foreach ($envios as $envio) {
                    echo '<li><div class="bordabranca">Destinatário:<br> ' . $envio['destinatario'] . '<br><hr>Valor: <br>' . $envio['valor'] . '<br><hr>Data/Hora:<br> ' . $envio['dataehora'] . '<br><hr>Link:<br> ' . $envio['link'] . '</div></li><br><br>'; /* Adiciona duas quebras de linha após cada linha da tabela */
                }
                echo '</ul>';
            } else {
                echo '<p>Nenhum envio não validado encontrado.</p>';
            }
        } catch (PDOException $e) {
            echo '<p>Erro na consulta: ' . $e->getMessage() . '</p>';
        }
        ?>
    

    
    
    
    
        
    

    <br><br>
    </body>
</html>

