/**
 * SISTEMA DE RADAR E ALERTAS - RPG MEDIEVAL
 * Arquivo: sistema/scripts/radar_invasao.js
 */

var personagensConhecidos = [];
var primeiraExecucao = true; 
var audioPermitido = false;

// Normalização para evitar erros de digitação/espaços
var situacaoLimpa = RADAR_CONFIG.situacao.trim().toLowerCase();

// Tenta desbloquear o áudio em qualquer clique na página
document.addEventListener('click', function() { audioPermitido = true; }, {once:true});

// --- FUNÇÃO DE ÁUDIO (3x) ---
function tocarAlarme() {
    var contador = 0;
    var maxRepeticoes = 3;
    
    function playSound() {
        if (contador >= maxRepeticoes) return;
        
        try {
            // Usa o caminho definido na configuração
            var audio = new Audio(RADAR_CONFIG.somUrl);
            audio.volume = 0.6; 
            
            var promessa = audio.play();
            if (promessa !== undefined) {
                promessa.then(_ => {
                    contador++;
                    setTimeout(playSound, 1500); 
                }).catch(error => {
                    // console.log("Áudio bloqueado.");
                });
            }
        } catch(e) {}
    }
    
    // Tenta tocar se o usuário já interagiu
    if (audioPermitido) {
        playSound();
    }
}

// --- FUNÇÃO DE TESTE MANUAL ---
function testeVisual() {
    console.log("Teste de alerta acionado.");
    audioPermitido = true; // Força permissão no clique do teste
    criarAlerta("INIMIGO TESTE", "Clã Rival", "9999", "#ff0000", "TESTE DE VISUAL");
}

// --- CRIAR O ALERTA NA TELA ---
function criarAlerta(nome, cla, rep, cor, titulo) {
    var container = document.getElementById('toast-container');
    
    // Recria container se sumiu
    if (!container) {
         container = document.createElement('div');
         container.id = 'toast-container';
         document.body.appendChild(container);
    }

    // Sanitização simples
    var nomeSeguro = String(nome).replace(/</g, "&lt;");
    var claSeguro = String(cla).replace(/</g, "&lt;");

    var div = document.createElement('div');
    div.className = 'toast-alert';
    
    // Cores dinâmicas
    div.style.borderLeftColor = cor;
    div.style.boxShadow = '0 0 15px ' + cor;
    
    div.innerHTML = `
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:5px; border-bottom:1px solid rgba(255,255,255,0.1); padding-bottom:5px;">
            <strong style="color:${cor}; text-transform:uppercase; font-size:0.85em;">${titulo}</strong>
            <span style="font-size:0.7em; color:#ccc;">AGORA</span>
        </div>
        <div style="font-size:1.1em; font-weight:bold; margin:5px 0;">${nomeSeguro}</div>
        <div style="font-size:0.85em; color:#ccc;">
            Clã: <span style="color:#fff;">${claSeguro}</span> <br> Reputação: ${rep}
        </div>
    `;
    
    container.appendChild(div);
    
    // Tocar Alarme
    tocarAlarme();

    // Remove após 6 segundos (com animação de saída)
    setTimeout(function() { 
        div.style.animation = 'saidaSuave 0.5s forwards';
        setTimeout(() => { 
            if(container.contains(div)) container.removeChild(div); 
        }, 500);
    }, 6000);
}

// --- MONITORAMENTO ---
function monitorarChegadas() {
    // Verifica se a string contém "invadindo"
    if (!situacaoLimpa.includes("invadindo")) return;

    var formData = new FormData();
    formData.append('local', RADAR_CONFIG.local);

    fetch(RADAR_CONFIG.apiUrl, {
        method: 'POST',
        body: formData
    })
    .then(r => r.json())
    .then(data => {
        var idsAtuais = data.map(p => p.id);

        // Só alerta se NÃO for a primeira vez que roda
        if (!primeiraExecucao) {
            data.forEach(p => {
                // Se este ID não estava na lista anterior
                if (!personagensConhecidos.includes(p.id) && !personagensConhecidos.includes(String(p.id))) {
                    
                    var cor = '#ffff00'; // Amarelo (Padrão)
                    var titulo = "⚠️ MOVIMENTO";

                    if (RADAR_CONFIG.meuCla && p.cla === RADAR_CONFIG.meuCla) {
                        cor = '#00ff44'; // Verde
                        titulo = "🛡️ REFORÇO ALIADO";
                    } else if (RADAR_CONFIG.claDominante && p.cla === RADAR_CONFIG.claDominante) {
                        cor = '#ff2222'; // Vermelho
                        titulo = "⚔️ DEFENSOR";
                    }

                    criarAlerta(p.personagem, (p.cla || 'Sem Clã'), p.reputacao, cor, titulo);
                }
            });
        }
        // Atualiza a lista
        personagensConhecidos = idsAtuais;
        primeiraExecucao = false;
    })
    .catch(err => {});
}

// --- INICIALIZAÇÃO ---
if (situacaoLimpa.includes("invadindo")) {
    console.log("Radar Ativo via Script Externo.");
    monitorarChegadas(); 
    setInterval(monitorarChegadas, 2000); // Roda a cada 2s
} else {
    console.log("Radar desligado. Situação: " + situacaoLimpa);
}

// --- MONITORAMENTO DE MUDANÇA DE STATUS (Recarrega página se mudar) ---
setInterval(function() {
    // Usa fetch para verificar se o status mudou no banco
    fetch('sistema/scripts/verificar_status_situacao_personagem.php')
        .then(response => response.text())
        .then(statusNoBanco => {
            statusNoBanco = statusNoBanco.trim();
            // Só recarrega se o status for DIFERENTE e não vazio
            if (statusNoBanco !== "" && statusNoBanco !== RADAR_CONFIG.situacao.trim()) {
                console.log("Status mudou. Recarregando...");
                location.reload();
            }
        })
        .catch(err => {});
}, 3000);