<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
    exit(); // Adicione exit após header
}

if (isset($_POST['mover'])) {
    $direcao = $_POST['direcao'];
    $personagem = $_SESSION['personagem'];
    $_SESSION['msg'] = "$personagem movido para $direcao"; // Corrigido $direção para $direcao
    
    // Formate a data/hora atual para o formato MySQL
    $movido = (new DateTime())->format('Y-m-d H:i:s');
    $_SESSION['datamovimentacao'] = $movido;
    echo $movido;
    exit:
    // Atualize a coluna 'local' na tabela 'personagens'
    $sql = "UPDATE personagens SET local = :direcao, movido = :movido WHERE personagem = :personagem";
    $stmt = $pdo->prepare($sql);

    $stmt->bindParam(':direcao', $direcao, PDO::PARAM_STR);
    $stmt->bindParam(':movido', $movido, PDO::PARAM_STR);
    $stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);

    if ($stmt->execute()) {
        echo "Local do personagem atualizado com sucesso para $direcao.";
    } else {
        echo "Erro ao atualizar o local do personagem.";
        // Para depuração, mostre o erro
        print_r($stmt->errorInfo());
    }
}
?>