<?php
// config_seguranca.php

// 1. BLINDAGEM DE SESSÃO
// Verifica se a sessão JÁ existe. Se não existir, configura e inicia.
if (session_status() === PHP_SESSION_NONE) {
    // Tenta configurar (silenciando erros com @ para evitar alertas visuais)
    @ini_set('session.cookie_httponly', 1);
    @ini_set('session.use_only_cookies', 1);
    
    // Inicia a sessão
    session_start();
}

// 2. CABEÇALHOS DE SEGURANÇA (HEADERS)
// Protege contra ataques e permite carregamento de CSS/Imagens
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");

// 3. GERADOR DE TOKEN CSRF
if (empty($_SESSION['csrf_token'])) {
    if (function_exists('random_bytes')) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    } else {
        $_SESSION['csrf_token'] = bin2hex(openssl_random_pseudo_bytes(32));
    }
}

// 4. FUNÇÃO DE VERIFICAÇÃO
function verificarTokenCSRF() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
            die("Erro de Segurança: Token inválido. Recarregue a página.");
        }
    }
}
?>