<?php
// ARQUIVO: apagarordemv.php
// IMPORTANTE: Certifique-se que este arquivo substituiu o antigo no seu servidor!

require '../conexao.php';
require '../config_seguranca.php'; 

// 1. Verificação de Login
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// DADOS DA SESSÃO (Inalteráveis pelo usuário)
$meu_usuario = $_SESSION['user_name']; // Quem está tentando apagar
$csrf_token = $_SESSION['csrf_token']; 

// 2. FILTRAGEM DO ID
$id_ordem = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id_ordem) {
    $id_ordem = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
}

if (!$id_ordem) {
    header("Location: ordens_venda.php");
    exit();
}

// ---------------------------------------------------------
// 🛡️ BARREIRA DE TITÂNIO (CONSULTA DE PROPRIEDADE)
// ---------------------------------------------------------

// Buscamos a ordem e o dono REAL dela no banco
$stmtCheck = $pdo->prepare("SELECT * FROM ordem_vendas WHERE id = :id LIMIT 1");
$stmtCheck->execute([':id' => $id_ordem]);
$ordem = $stmtCheck->fetch(PDO::FETCH_ASSOC);

// SE A ORDEM NÃO EXISTE
if (!$ordem) {
    $_SESSION['mensagem'] = "Erro: Esta ordem não existe mais.";
    header("Location: ordens_venda.php");
    exit();
}

// SE A ORDEM EXISTE, MAS O DONO É OUTRO
// Comparação estrita (===) para evitar falhas
if ($ordem['jogador'] !== $meu_usuario) {
    // MODO DE SEGURANÇA MÁXIMA ATIVADO
    // Se cair aqui, o usuário tentou burlar. Vamos matar o script.
    
    // DEBUG: Se você ver esta tela, o sistema funcionou!
    echo "<div style='background:black; color:red; padding:50px; text-align:center; font-family:sans-serif;'>";
    echo "<h1>🚫 ACESSO NEGADO 🚫</h1>";
    echo "<h3>Tentativa de violação de segurança detectada.</h3>";
    echo "<p>Esta ordem pertence a: <strong>" . htmlspecialchars($ordem['jogador']) . "</strong></p>";
    echo "<p>Seu usuário logado é: <strong>" . htmlspecialchars($meu_usuario) . "</strong></p>";
    echo "<p>O sistema impediu a ação.</p>";
    echo "<a href='ordens_venda.php' style='color:white;'>Voltar</a>";
    echo "</div>";
    exit(); // O SCRIPT MORRE AQUI. NADA MAIS ACONTECE.
}

// ---------------------------------------------------------
// SE PASSOU DAQUI, VOCÊ É O DONO LEGÍTIMO.
// ---------------------------------------------------------

$erro = "";
$sucesso = false;

// 3. PROCESSAR O CANCELAMENTO (APENAS POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirmar'])) {
    
    // Verifica CSRF
    verificarTokenCSRF();

    try {
        $pdo->beginTransaction();

        // Remove a ordem (Redundância: verifica dono de novo)
        $stmtDel = $pdo->prepare("DELETE FROM ordem_vendas WHERE id = :id AND jogador = :dono");
        $stmtDel->execute([':id' => $id_ordem, ':dono' => $meu_usuario]);

        if ($stmtDel->rowCount() > 0) {
            // Libera o personagem
            $stmtUpd = $pdo->prepare("UPDATE personagens SET situacao = 'livre', datamovimentacao = NOW() WHERE personagem = :nome");
            $stmtUpd->execute([':nome' => $ordem['personagem']]);

            $pdo->commit();
            $sucesso = true;
        } else {
            $pdo->rollBack();
            $erro = "Erro: A ordem não pôde ser apagada (talvez já tenha sido vendida).";
        }

    } catch (Exception $e) {
        if ($pdo->inTransaction()) $pdo->rollBack();
        $erro = "Erro técnico: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cancelar Venda - Mavilla</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
    
    <style>
        /* CSS NEON */
        html, body { background: none !important; background-color: transparent !important; }
        body {
            background: url('../rpg-login-background.jpg') no-repeat center center fixed !important;
            background-size: cover !important;
            color: white;
            min-height: 100vh;
            display: flex; align-items: center; justify-content: center; font-family: 'Roboto', sans-serif;
        }
        .container { width: 100%; max-width: 500px; padding: 20px; }
        .neon-card {
            background-color: rgba(0, 5, 30, 0.9);
            border: 2px solid <?php echo $sucesso ? '#28a745' : '#ff2222'; ?>;
            box-shadow: 0 0 20px <?php echo $sucesso ? 'rgba(40, 167, 69, 0.4)' : 'rgba(255, 34, 34, 0.4)'; ?>;
            border-radius: 15px; padding: 30px; text-align: center; backdrop-filter: blur(5px);
        }
        h1 {
            color: <?php echo $sucesso ? '#28a745' : '#ff2222'; ?>;
            text-transform: uppercase; text-shadow: 0 0 10px <?php echo $sucesso ? '#28a745' : '#ff2222'; ?>;
            margin-bottom: 20px; font-size: 1.8rem; font-family: 'Times New Roman', serif;
        }
        .info-box {
            background: rgba(255,255,255,0.05); padding: 20px; border-radius: 8px; margin: 20px 0; text-align: left; border: 1px dashed #555;
        }
        .highlight { color: #00f3ff; font-weight: bold; font-size: 1.2rem; }
        .price { color: #28a745; font-weight: bold; font-size: 1.2rem; }
        .btn-group { display: flex; flex-direction: column; gap: 15px; margin-top: 30px; }
        button { width: 100%; padding: 15px; border-radius: 8px; font-weight: bold; text-transform: uppercase; cursor: pointer; transition: 0.3s; font-size: 1rem; }
        .btn-confirm { background: #000; color: #ff2222; border: 2px solid #ff2222; }
        .btn-confirm:hover { background: #ff2222; color: #fff; box-shadow: 0 0 20px #ff2222; }
        .btn-cancel { background: #000; color: var(--primary); border: 2px solid var(--primary); }
        .btn-cancel:hover { background: var(--primary); color: #fff; box-shadow: 0 0 20px var(--primary); }
        .btn-back { background: #000; border: 2px solid #28a745; color: #28a745; }
        .btn-back:hover { background: #28a745; color: #fff; box-shadow: 0 0 20px #28a745; }
    </style>
</head>
<body>

    <div class="container">
        <div class="neon-card">
            
            <?php if ($sucesso): ?>
                <h1>Venda Cancelada!</h1>
                <p>O personagem voltou para sua conta com segurança.</p>
                <div class="btn-group">
                    <a href="ordens_venda.php" style="text-decoration:none;"><button class="btn-back">Voltar</button></a>
                </div>
            <?php else: ?>
                
                <h1>Cancelar Venda</h1>
                
                <?php if ($erro): ?><div style="color:#ff2222; margin-bottom:15px;"><?= $erro ?></div><?php endif; ?>

                <p>Tem certeza que deseja cancelar esta venda?</p>

                <div class="info-box">
                    <p style="color:#ccc;">Personagem: <span class="highlight"><?= htmlspecialchars($ordem['personagem']) ?></span></p>
                    <p style="color:#ccc;">Valor: <span class="price">R$ <?= number_format($ordem['valor'], 2, ',', '.') ?></span></p>
                    <p style="color:#666; font-size:0.8rem;">Dono: <?= htmlspecialchars($ordem['jogador']) ?></p>
                </div>

                <form method="POST" class="btn-group">
                    <input type="hidden" name="id" value="<?= $id_ordem ?>">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    
                    <button type="submit" name="confirmar" class="btn-confirm">Sim, Cancelar</button>
                    <a href="ordens_venda.php" style="text-decoration:none;"><button type="button" class="btn-cancel">Não, Voltar</button></a>
                </form>

            <?php endif; ?>

        </div>
    </div>

</body>
</html>