<?php
// Desativa erros na tela para não quebrar o JSON
ini_set('display_errors', 0);
error_reporting(0);

session_start();
header('Content-Type: application/json; charset=utf-8');

// Conexão Robusta
$conectado = false;
$caminhos = ['../conexao.php', '../../conexao.php', 'conexao.php'];
foreach ($caminhos as $c) {
    if (file_exists($c)) { require_once $c; $conectado = true; break; }
}

if (!$conectado) { echo json_encode(['cla'=>[], 'local'=>[], 'geral'=>[]]); exit; }

// Garante UTF-8 no banco
try { $pdo->exec("SET NAMES utf8"); } catch(Exception $e){}

$meu_cla = $_POST['cla'] ?? '';
$meu_local = $_POST['local'] ?? '';
$nomePersonagem = $_SESSION['personagem_nome'] ?? '';

// Busca data de chegada (movido)
$minha_chegada = date('Y-m-d H:i:s');
try {
    $stmtU = $pdo->prepare("SELECT movido FROM personagens WHERE personagem = :n LIMIT 1");
    $stmtU->execute([':n' => $nomePersonagem]);
    $res = $stmtU->fetch(PDO::FETCH_ASSOC);
    if($res && !empty($res['movido'])) $minha_chegada = $res['movido'];
} catch(Exception $e){}

$response = ['cla' => [], 'local' => [], 'geral' => []];

try {
    // 1. Clã
    if (!empty($meu_cla) && $meu_cla !== 'Nenhum') {
        $stmt = $pdo->prepare("SELECT * FROM ocorrencias_clas WHERE (cla1=:c OR cla2=:c) ORDER BY data DESC LIMIT 20");
        $stmt->execute([':c' => $meu_cla]);
        $response['cla'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    
    // 2. Local (Desde a chegada)
    $stmt = $pdo->prepare("SELECT * FROM ocorrencias_locais WHERE local=:l AND data >= :d ORDER BY data DESC LIMIT 20");
    $stmt->execute([':l' => $meu_local, ':d' => $minha_chegada]);
    $response['local'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 3. Geral
    $stmt = $pdo->query("SELECT * FROM ocorrencias_gerais ORDER BY data DESC LIMIT 20");
    $response['geral'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (Exception $e) {}

echo json_encode($response);
?>