<?php
// jogo/api_inimigos_local.php
session_start();
require '../conexao.php'; // Ajuste o caminho se necessário

header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || empty($_POST['local'])) {
    echo json_encode([]);
    exit;
}

$local = $_POST['local'];
$meu_nome = $_SESSION['personagem_nome'];

// Busca ID, Nome, Clã e Reputação de todos no local (menos eu e escondidos)
$sql = "SELECT id, personagem, cla, reputacao FROM personagens 
        WHERE local = :local 
        AND situacao != 'escondido' 
        AND personagem != :eu";

$stmt = $pdo->prepare($sql);
$stmt->execute([':local' => $local, ':eu' => $meu_nome]);
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($personagens);
?>