<?php
// transferir_fichas.php (SISTEMA BLINDADO & LOG BLOCKCHAIN)

// 1. SEGURANÇA E CONEXÃO
require '../conexao.php';
require '../config_seguranca.php'; // Inicia sessão e proteções

// Configuração de erro segura
ini_set('display_errors', 0); 

// 2. VERIFICAÇÃO DE LOGIN
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador_atual = $_SESSION['user_name'];
$user_id = $_SESSION['user_id'];
$csrf_token = $_SESSION['csrf_token'];

// --- PROCESSAMENTO DA TRANSFERÊNCIA ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // 3. BARREIRA CSRF
    verificarTokenCSRF();

    $jogador_destino = trim($_POST['jogador_destino'] ?? '');
    $quantidade = filter_input(INPUT_POST, 'quantidade', FILTER_VALIDATE_INT);
    $pin_digitado = $_POST['pin'] ?? '';
    
    $redirecionar = "transferir_fichas.php";

    try {
        // A. Validações Básicas
        if (empty($jogador_destino) || !$quantidade || $quantidade <= 0 || empty($pin_digitado)) {
            throw new Exception("Preencha todos os campos corretamente.");
        }

        // Impedir transferência para si mesmo
        if (strcasecmp($jogador_destino, $jogador_atual) === 0) {
            throw new Exception("Você não pode transferir fichas para si mesmo.");
        }

        // B. Validação do PIN (Direto do Banco)
        $stmtPin = $pdo->prepare("SELECT pin FROM usersblock WHERE id = ? LIMIT 1");
        $stmtPin->execute([$user_id]);
        $hash_real = $stmtPin->fetchColumn();
        
        if (!$hash_real || !password_verify($pin_digitado, $hash_real)) {
            sleep(1); 
            throw new Exception("PIN incorreto!");
        }

        // C. Verificar Destinatário (BUSCA NOME E WALLET)
        $stmtDest = $pdo->prepare("SELECT user, wallet FROM usersblock WHERE user = ? LIMIT 1");
        $stmtDest->execute([$jogador_destino]);
        $dados_destinatario = $stmtDest->fetch(PDO::FETCH_ASSOC);

        if (!$dados_destinatario) {
            throw new Exception("Jogador destino não encontrado!");
        }
        
        $nome_destino_real = $dados_destinatario['user'];
        $wallet_destinatario = $dados_destinatario['wallet'];

        // --- INÍCIO DA TRANSAÇÃO CRÍTICA ---
        $pdo->beginTransaction();

        // D. SELEÇÃO E TRAVAMENTO DAS FICHAS (Anti-Duplicação)
        $stmtLock = $pdo->prepare("SELECT id FROM fichaspersonagens WHERE jogador = :dono AND situacao = '1' LIMIT :qtd FOR UPDATE");
        $stmtLock->bindValue(':dono', $jogador_atual);
        $stmtLock->bindValue(':qtd', $quantidade, PDO::PARAM_INT);
        $stmtLock->execute();
        
        $fichas_para_mover = $stmtLock->fetchAll(PDO::FETCH_COLUMN);

        // Verifica saldo real travado
        if (count($fichas_para_mover) < $quantidade) {
            throw new Exception("Saldo insuficiente ou fichas indisponíveis no momento.");
        }

        // E. Executar a Transferência
        $ids_string = implode(',', array_map('intval', $fichas_para_mover));
        $sql_update = "UPDATE fichaspersonagens SET jogador = '$nome_destino_real' WHERE id IN ($ids_string)";
        $pdo->exec($sql_update);

        // F. Gerar Chave Interna (Transferencias)
        $stmtKey = $pdo->query("SELECT MAX(chave) FROM transferencias");
        $ultima_chave = $stmtKey->fetchColumn();
        $nova_chave = $ultima_chave ? $ultima_chave + 1 : 1;

        // G. Registrar Histórico Interno
        $info_transferencia = "$quantidade fichas transferidas";
        $sql_insert = "INSERT INTO transferencias (tipo, transferiu, recebeu, informacoes, chave, val) VALUES ('ficha', ?, ?, ?, ?, 1)";
        $stmt = $pdo->prepare($sql_insert);
        $stmt->execute([$jogador_atual, $nome_destino_real, $info_transferencia, $nova_chave]);

        // --- H. LOG NO INFOSSISTEMA (PADRÃO BLOCKCHAIN) ---
        
        // 1. Buscar Wallet do Remetente (Você)
        $stmtSender = $pdo->prepare("SELECT wallet FROM usersblock WHERE id = ? LIMIT 1");
        $stmtSender->execute([$user_id]);
        $wallet_remetente = $stmtSender->fetchColumn();

        // 2. Montar texto solicitado:
        // "wallet $walletjogadorr transferiu $quantidade ficha/s, para a carteira $walletquerecebe"
        $texto_blockchain = "Carteira $wallet_remetente transferiu $quantidade ficha/s, para a carteira $wallet_destinatario";

        // 3. Inserir
        $stmtLog = $pdo->prepare("INSERT INTO infossistema (informacao, p1, p2, origem, dataehora) VALUES (?, ?, ?, 'Transferência Ficha', NOW())");
        $stmtLog->execute([$texto_blockchain, $wallet_remetente, $wallet_destinatario]);

        $pdo->commit();

        // Sucesso
        $_SESSION['msg'] = "Transferência de $quantidade fichas para <span class='highlight-neon-blue'>$nome_destino_real</span> realizada com sucesso!";
        $_SESSION['msg_type'] = 'success';
        header("Location: $redirecionar");
        exit();

    } catch (Exception $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        $_SESSION['msg'] = "Erro: " . $e->getMessage();
        $_SESSION['msg_type'] = 'error';
        header("Location: $redirecionar");
        exit();
    }
}

// Consulta de saldo visual
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
    $stmt->execute([$jogador_atual]);
    $total_fichas = $stmt->fetchColumn();
} catch (Exception $e) {
    $total_fichas = 0;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transferência de Fichas - Ferro & Fogo</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../css/dashboard.css">
    
    <style>
        .highlight-neon-blue {
            color: #00f3ff;
            text-shadow: 0 0 5px #00f3ff;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="light-rays"></div>

    <div class="container"> 
        
        <div class="card" style="margin-top: 30px; margin-bottom: 50px;">
            
            <div class="listing-header-centered">
                <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); margin-bottom: 25px; font-size: 2rem;">
                    RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder
                </h1>
                
                <div class="btn-group btn-container-center" style="margin-bottom: 25px;">
                    <center>
                    <a href="../admpersonagens.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Administração de Fichas & Personagens</button>
                    </a><br>
                    <a href="../dashboard.php">
                        <button style="margin:0; padding: 12px 50px; width: auto;">Menu Principal</button>
                    </a>
                    </center>
                </div>

                <h2 style="color: white; text-transform: uppercase; letter-spacing: 1px; margin-bottom: 15px;">
                    Transferência de Fichas
                </h2>

                <p class="listing-intro">
                    Envie suas fichas disponíveis para outros jogadores. Esta operação requer seu PIN de segurança.
                </p>
            </div>
            
            <?php if (isset($_SESSION['msg'])): ?>
                <div class="message-neon <?= (isset($_SESSION['msg_type']) && $_SESSION['msg_type'] == 'success') ? 'success' : 'error' ?>" 
                     style="border: 1px solid <?= ($_SESSION['msg_type'] == 'success') ? '#00ff00' : '#ff2222' ?>; 
                            background: rgba(0,0,0,0.3); 
                            color: <?= ($_SESSION['msg_type'] == 'success') ? '#00ff00' : '#ff2222' ?>; 
                            padding: 15px; margin: 10px auto; max-width: 600px; text-align: center; border-radius: 8px;">
                    <?= $_SESSION['msg'] ?>
                </div>
                <?php 
                    unset($_SESSION['msg']); 
                    unset($_SESSION['msg_type']);
                ?>
            <?php endif; ?>

            <div class="fichas-counter" id="contador-fichas" style="text-align:center; font-size:1.2rem; margin: 20px 0;">
                Suas fichas disponíveis para transferência:<br>
                <span class="highlight-neon" style="color:var(--primary); font-weight:bold; font-size:1.5rem;"><?= $total_fichas ?> fichas</span>
            </div>

            <div class="form-stack-container" style="max-width: 500px; margin: 0 auto;">
                <form method="POST">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    
                    <div>
                        <label for="jogador_destino" style="display:block; text-align:center; color:#ccc;">Nome do Jogador Destino</label>
                        <input type="text" id="jogador_destino" name="jogador_destino" required 
                               placeholder="Digite o nome do jogador..." 
                               style="width: 100%; padding: 10px; background: rgba(0,0,0,0.7); border: 1px solid var(--primary); color: white; text-align:center;">
                    </div>
                    
                    <div style="margin-top:15px;">
                        <label for="quantidade" style="display:block; text-align:center; color:#ccc;">Quantidade de Fichas:</label>
                        <input type="number" id="quantidade" name="quantidade" min="1" max="<?= $total_fichas ?>" required
                               placeholder="Digite a quantidade..." 
                               style="width: 100%; padding: 15px; background-color: rgba(0, 0, 20, 0.8); border: 2px solid var(--primary); border-radius: 8px; color: white; font-size: 1.1rem; box-shadow: 0 0 5px rgba(0, 0, 255, 0.3); outline: none; transition: all 0.3s ease; text-align: center;">
                    </div>
                    
                    <div style="margin-top:15px;">
                        <label for="pin" style="display:block; text-align:center; color:#ccc;">Código PIN (4 dígitos):</label>
                        <input type="password" id="pin" name="pin" maxlength="4" required
                               placeholder="Digite seu PIN..." 
                               style="width: 100%; padding: 15px; background-color: rgba(0, 0, 20, 0.8); border: 2px solid var(--primary); border-radius: 8px; color: white; font-size: 1.1rem; box-shadow: 0 0 5px rgba(0, 0, 255, 0.3); outline: none; transition: all 0.3s ease; text-align: center;">
                    </div>
                    
                    <div style="margin-top: 20px;">
                        <button type="submit" class="btn-transferir-neon" onclick="return confirm('ATENÇÃO: Confirma a transferência dessas fichas? Esta ação é irreversível.');">
                            REALIZAR TRANSFERÊNCIA
                        </button>
                    </div>
                </form>
            </div>
            </div> 
        <footer class="footer-simple-medieval">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; <?php echo date("Y"); ?> Todos os direitos reservados.</p>
            </div>
        </footer>

    </div> 
</body>
</html>