<?php
session_start();
require 'conexao.php';

// 1. Verificação de Acesso e Inicialização (SEU CÓDIGO ORIGINAL INTACTO)
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }

$msgsis2 = $_SESSION['msg2'] ?? '';
$user_id = $_SESSION['user_name'];

// Preços e Variáveis Globais
$precomadeira = 27; $_SESSION['precomadeira'] = $precomadeira;
$precocarne = 36; $_SESSION['precocarne'] = $precocarne;

$total_notificacoes = 0;
$personagemAtivo = null; 
$messages = [];
$situacao = 'Nenhum'; 
$local = '';
$paralisado = date('Y-m-d H:i:s'); 
$tipolocal = 'city'; 

// Variáveis de Localização
$dominio_local = 'Nenhum';
$governante_local = 'Ninguém';
$nomelocal = 'Desconhecido';

// Controle de Direções e Litoral
$norte_id = ''; $leste_id = ''; $sul_id = ''; $oeste_id = ''; 
$show_n = false; $show_l = false; $show_s = false; $show_o = false;
$is_litoral = false;

$horarioAtual = date('Y-m-d H:i:s');

// 3. Notificações
$sqlCountNotificacoes = "SELECT COUNT(*) AS total_notificacoes FROM notificacoes_jogo WHERE user2 = :user_name AND vz2 = 0";
$stmtCountNotificacoes = $pdo->prepare($sqlCountNotificacoes);
$stmtCountNotificacoes->bindParam(':user_name', $user_id, PDO::PARAM_STR);
$stmtCountNotificacoes->execute();
$total_notificacoes = $stmtCountNotificacoes->fetch(PDO::FETCH_ASSOC)['total_notificacoes'];

// 4. Modal Local (Ajax)
if (isset($_GET['location'])) {
    $location = $_GET['location'];
    $sqlLocation = "SELECT descricao FROM mapasmed WHERE nome = :location";
    $stmtLocation = $pdo->prepare($sqlLocation);
    $stmtLocation->bindParam(':location', $location, PDO::PARAM_STR);
    $stmtLocation->execute();
    $locationInfo = $stmtLocation->fetch(PDO::FETCH_ASSOC);
    if ($locationInfo) { echo $locationInfo['descricao']; exit(); }
}

// 5. Consulta Personagem
$sql = "SELECT * FROM personagens WHERE jogador = :user_id AND ativo = 1 LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $personagemAtivo = $row; 
    
    $personagem_id = $row['id'];
    $nomePersonagem = $row['personagem'];
    $personagem = $row['personagem'];
    $situacao = $row['situacao'] ?? 'livre'; 
    $local = $row['local'];
    $paralisado = $row['paralisado'];
    
    // Recursos
    $prata = $row['prata'];
    $soldados = $row['soldados'];
    $carne = $row['carne'];
    $madeira = $row['madeira'];
    $atk = $row['atk'];
    $def = $row['def'];
    $cla = $row['cla'];
    $cargo_id = $row['cargo'] ?? 1;
    
    // Status
    $hp_atual = $row['hp_atual'] ?? 100; 
    $hp_max = $row['hp_max'] ?? 100;
    
    // Colunas de Fome/Sede
    $fome = $row['fome'] ?? 100;
    $sede = $row['sede'] ?? 100;
    
    // Sessão
    $_SESSION['personagem'] = $personagem_id;
    $_SESSION['personagem_nome'] = $nomePersonagem;
    $_SESSION['local'] = $local;
    $_SESSION['situacao'] = $situacao;
    $_SESSION['carne'] = $carne;
    $_SESSION['madeira'] = $madeira;
    $_SESSION['soldados'] = $soldados;
    $_SESSION['prata'] = $prata;
    $_SESSION['sede'] = $sede;
    $_SESSION['fome'] = $fome;
    $_SESSION['cla'] = $cla;
    $_SESSION['cargo_id'] = $cargo_id;

    // --- LÓGICA DE VIZINHOS E LITORAL ---
    $sqlLocal = "SELECT tipo, regiao, nome, dominio, governante, n, l, s, o FROM mapasmed WHERE nome = :local";
    $stmtLocal = $pdo->prepare($sqlLocal);
    $stmtLocal->bindParam(':local', $local, PDO::PARAM_STR);
    $stmtLocal->execute();
    $local_info = $stmtLocal->fetch(PDO::FETCH_ASSOC);
    
    if ($local_info) {
        $tipolocal = $local_info['tipo'];
        $regiao_atual = $local_info['regiao'];
        
        $nomelocal = $local_info['nome'];
        $dominio_local = $local_info['dominio'];
        $governante_local = $local_info['governante'];
        
        $norte_id = $local_info['n'];
        $leste_id = $local_info['l'];
        $sul_id = $local_info['s'];
        $oeste_id = $local_info['o'];

        $ids_vizinhos = array_filter([$norte_id, $leste_id, $sul_id, $oeste_id]);
        $tipos_vizinhos = [];

        if (!empty($ids_vizinhos)) {
            $inQuery = implode(',', array_map('intval', $ids_vizinhos));
            $sqlViz = "SELECT id2, tipo FROM mapasmed WHERE id2 IN ($inQuery) AND regiao = :regiao";
            $stmtViz = $pdo->prepare($sqlViz);
            $stmtViz->execute([':regiao' => $regiao_atual]);
            $tipos_vizinhos = $stmtViz->fetchAll(PDO::FETCH_KEY_PAIR); 
        }

        function analisarDirecao($id, $lista_tipos) {
            if (empty($id) || !isset($lista_tipos[$id])) return ['show' => false, 'is_mar' => false];
            $tipo = strtolower($lista_tipos[$id]);
            $is_mar = ($tipo === 'mar');
            return ['show' => !$is_mar, 'is_mar' => $is_mar];
        }

        $res = analisarDirecao($norte_id, $tipos_vizinhos); $show_n = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($leste_id, $tipos_vizinhos); $show_l = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($sul_id, $tipos_vizinhos); $show_s = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($oeste_id, $tipos_vizinhos); $show_o = $res['show']; if($res['is_mar']) $is_litoral=true;
    }
    
    // 6. Histórico
    $sqlMessages = "SELECT id, acao, dataehora, vz FROM acoespersonagens WHERE personagem = :personagem ORDER BY dataehora DESC LIMIT 30";
    $stmtMessages = $pdo->prepare($sqlMessages);
    $stmtMessages->bindParam(':personagem', $nomePersonagem, PDO::PARAM_STR);
    $stmtMessages->execute();
    $messages = $stmtMessages->fetchAll(PDO::FETCH_ASSOC);
    
    // Update VZ
    $idsParaAtualizar = array_column(array_filter($messages, function($m) { return $m['vz'] == 0; }), 'id');
    if (!empty($idsParaAtualizar)) {
        $placeholders = implode(',', array_fill(0, count($idsParaAtualizar), '?'));
        $pdo->prepare("UPDATE acoespersonagens SET vz = 1 WHERE id IN ($placeholders)")->execute($idsParaAtualizar);
    }

    // --- LOGICA DE CLÃS E ORDENS ---
    $texto_og = "Nenhuma ordem geral ativa.";
    $info_og_display = ""; 
    $texto_om = "Nenhuma instrução momentânea.";
    $info_om_display = "";
    
    $mapa_cargos = [
        1 => 'Guardião da Vanguarda', 2 => 'Capitão do Mato', 3 => 'Capitão da Vanguarda',
        4 => 'Comandante da Guarda Real', 5 => 'Subcomandante', 6 => 'Comandante Oficial', 7 => '1º Ministro'
    ];
    $cargo_nome = $mapa_cargos[$cargo_id] ?? 'Recruta';

    if (!empty($cla) && $cla !== 'Nenhum') {
        try {
            $stmtId = $pdo->prepare("SELECT id FROM cla WHERE nome = :nome LIMIT 1");
            $stmtId->execute([':nome' => $cla]);
            $claData = $stmtId->fetch(PDO::FETCH_ASSOC);

            if ($claData) {
                $cid = $claData['id'];
                
                // Ordem Geral
                $stmtOG = $pdo->prepare("SELECT ordem, data, cargo, redator FROM cla_ordens WHERE cla_id = :cid AND tipo = 'G' ORDER BY data DESC LIMIT 1");
                $stmtOG->execute([':cid' => $cid]);
                $resOG = $stmtOG->fetch(PDO::FETCH_ASSOC);
                if ($resOG) {
                    $texto_og = $resOG['ordem'];
                    $c_og = $resOG['cargo'] ?? 1;
                    $n_og = $mapa_cargos[$c_og] ?? 'Membro';
                    $r_og = $resOG['redator'] ?? 'Anônimo';
                    $info_og_display = "<strong>Por: $r_og <span style='font-size:0.7rem'>($n_og)</span></strong><br><span style='font-size:0.7rem'>Em: " . date('d/m H:i', strtotime($resOG['data'])) . "</span>";
                }

                // Ordem Momentânea
                $stmtOM = $pdo->prepare("SELECT ordem, data, cargo, redator FROM cla_ordens WHERE cla_id = :cid AND tipo = 'M' ORDER BY data DESC LIMIT 1");
                $stmtOM->execute([':cid' => $cid]);
                $resOM = $stmtOM->fetch(PDO::FETCH_ASSOC);
                if ($resOM) {
                    $texto_om = $resOM['ordem'];
                    $c_om = $resOM['cargo'] ?? 1;
                    $n_om = $mapa_cargos[$c_om] ?? 'Membro';
                    $r_om = $resOM['redator'] ?? 'Anônimo';
                    $info_om_display = "<strong>Por: $r_om <span style='font-size:0.7rem'>($n_om)</span></strong><br><span style='font-size:0.7rem'>Em: " . date('d/m H:i', strtotime($resOM['data'])) . "</span>";
                }
            }
        } catch (Exception $e) { /* Silêncio */ }
    }
}

// --- FUNÇÕES AUXILIARES ---
function getBarColor($val) {
    if ($val > 70) return '#00ff44'; // Verde Neon
    if ($val > 40) return '#ffd700'; // Amarelo
    if ($val > 20) return '#fd7e14'; // Laranja
    if ($val > 10) return '#dc3545'; // Vermelho
    return '#333';
}

function formatarTermino($data) {
    if (empty($data) || strtotime($data) === false || strtotime($data) < time()) { return "Concluído"; }
    return date('d/m/Y H:i', strtotime($data));
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>RPG ERA MEDIEVAL: Dervian</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* === RESET & BASE (MOBILE FIRST) === */
        :root {
            --primary: #00d2ff; /* Azul Ciano Tecnológico */
            --accent: #ffd700;  /* Dourado */
            --danger: #ff3333;
            --success: #00ff66;
            --bg-dark: #050508;
            --bg-panel: rgba(10, 15, 30, 0.85);
            --border: 1px solid rgba(0, 210, 255, 0.3);
            --glass: blur(10px);
            --font-main: 'Segoe UI', Tahoma, sans-serif;
            --nav-height: 65px;
            --header-height: 60px;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; -webkit-tap-highlight-color: transparent; }

        body {
            background-color: var(--bg-dark);
            background-image: url('../rpg-login-background.jpg'); /* Mantenha sua imagem */
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: #fff;
            font-family: var(--font-main);
            overflow: hidden; /* Importante para a sensação de App */
            height: 100vh;
            width: 100vw;
        }

        /* Máscara escura sobre o background */
        .app-overlay {
            position: absolute; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(0, 0, 0, 0.85); z-index: -1;
        }

        /* === HEADER (HUD) === */
        .app-header {
            position: fixed; top: 0; left: 0; width: 100%; height: var(--header-height);
            background: rgba(0, 5, 15, 0.95);
            border-bottom: 1px solid var(--primary);
            display: flex; align-items: center; justify-content: space-between;
            padding: 0 15px;
            z-index: 100;
            box-shadow: 0 5px 15px rgba(0,0,0,0.5);
        }

        .char-summary { display: flex; align-items: center; gap: 10px; width: 100%; }
        .char-avatar { 
            width: 40px; height: 40px; border-radius: 50%; border: 2px solid var(--primary); 
            background: #000; display: flex; align-items: center; justify-content: center;
            font-size: 1.2rem; color: var(--primary);
        }
        .char-details { flex-grow: 1; }
        .char-name { font-size: 0.9rem; font-weight: bold; color: var(--primary); text-transform: uppercase; letter-spacing: 1px; }
        .char-bars { display: flex; flex-direction: column; gap: 3px; margin-top: 2px; }
        
        .bar-wrap { width: 100%; height: 6px; background: #333; border-radius: 3px; overflow: hidden; position: relative; }
        .bar-fill { height: 100%; transition: width 0.5s ease; }
        .bar-hp { background: var(--danger); }
        .bar-energy { background: var(--accent); }

        .header-actions { display: flex; gap: 15px; }
        .header-btn { background: none; border: none; color: #fff; font-size: 1.2rem; cursor: pointer; }
        .notification-dot { position: absolute; top: -5px; right: -5px; width: 8px; height: 8px; background: red; border-radius: 50%; }

        /* === ÁREA DE CONTEÚDO (SPA) === */
        .app-content {
            position: absolute;
            top: var(--header-height);
            bottom: var(--nav-height);
            width: 100%;
            overflow-y: auto; /* Rolagem interna */
            padding: 15px;
            scroll-behavior: smooth;
        }

        /* Ocultar views não ativas */
        .view-tab { display: none; animation: fadeIn 0.3s ease; padding-bottom: 20px;}
        .view-tab.active { display: block; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }

        /* === BOTTOM NAVIGATION === */
        .app-nav {
            position: fixed; bottom: 0; left: 0; width: 100%; height: var(--nav-height);
            background: rgba(0, 0, 10, 0.98);
            border-top: 1px solid #333;
            display: flex; justify-content: space-around; align-items: center;
            z-index: 100;
            backdrop-filter: blur(5px);
        }

        .nav-item {
            background: none; border: none; color: #666;
            display: flex; flex-direction: column; align-items: center; gap: 4px;
            font-size: 0.7rem; cursor: pointer; padding: 10px; width: 20%;
            transition: color 0.3s;
        }
        .nav-item i { font-size: 1.3rem; margin-bottom: 2px; }
        .nav-item.active { color: var(--primary); text-shadow: 0 0 10px rgba(0, 210, 255, 0.5); }
        .nav-item.active i { transform: translateY(-2px); }

        /* === COMPONENTES UI === */
        
        /* Cards */
        .game-card {
            background: var(--bg-panel);
            border: var(--border);
            border-radius: 12px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
        }
        .card-title {
            font-size: 0.9rem; text-transform: uppercase; color: var(--primary);
            border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 5px; margin-bottom: 10px;
            display: flex; justify-content: space-between;
        }

        /* Mapa Grid */
        .map-wrapper {
            width: 100%; max-width: 500px; margin: 0 auto;
            aspect-ratio: 1/1;
            display: grid;
            grid-template-columns: repeat(6, 1fr);
            gap: 1px;
            background: #000;
            border: 2px solid var(--primary);
            box-shadow: 0 0 20px rgba(0, 210, 255, 0.2);
        }
        .map-cell {
            position: relative; overflow: hidden; cursor: pointer;
        }
        .map-cell img.terrain { width: 100%; height: 100%; object-fit: cover; filter: brightness(0.8); }
        .map-cell:hover img.terrain { filter: brightness(1.2); }
        .map-marker {
            position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);
            width: 80%; height: 80%; z-index: 2;
            animation: bounce 2s infinite;
            filter: drop-shadow(0 0 5px #000);
        }
        .map-flag {
            position: absolute; top: 2px; left: 2px; width: 40%; z-index: 1; opacity: 0.9;
        }
        .map-fire {
            position: absolute; top: 2px; right: 2px; width: 15px; z-index: 3; animation: flicker 0.5s infinite;
        }

        /* Controles de Movimento (D-PAD) */
        .d-pad {
            display: grid; grid-template-columns: repeat(3, 1fr); gap: 5px;
            width: 160px; margin: 20px auto;
        }
        .d-btn {
            width: 50px; height: 50px; background: rgba(0,0,0,0.5);
            border: 1px solid var(--primary); border-radius: 8px;
            color: var(--primary); font-size: 1.2rem; cursor: pointer;
            display: flex; align-items: center; justify-content: center;
        }
        .d-btn:active { background: var(--primary); color: #000; }
        .d-spacer { visibility: hidden; }

        /* Status & Recursos */
        .resource-grid {
            display: grid; grid-template-columns: 1fr 1fr; gap: 10px;
        }
        .res-item {
            background: rgba(255,255,255,0.05); padding: 10px; border-radius: 8px;
            display: flex; justify-content: space-between; align-items: center;
        }
        .res-val { color: var(--accent); font-weight: bold; }

        /* Botões de Ação */
        .btn-neon {
            width: 100%; padding: 12px; margin-bottom: 10px;
            background: rgba(0, 210, 255, 0.1); border: 1px solid var(--primary);
            color: var(--primary); text-transform: uppercase; font-weight: bold;
            border-radius: 6px; cursor: pointer; transition: 0.2s;
            display: flex; align-items: center; justify-content: center; gap: 10px;
        }
        .btn-neon:hover { background: var(--primary); color: #000; box-shadow: 0 0 15px var(--primary); }
        .btn-danger-neon { border-color: var(--danger); color: var(--danger); background: rgba(255, 51, 51, 0.1); }
        .btn-danger-neon:hover { background: var(--danger); color: #fff; }

        /* Timer de Ação */
        .active-action-bar {
            background: linear-gradient(90deg, #000, #111);
            border: 1px solid var(--success);
            padding: 15px; border-radius: 8px; text-align: center;
            margin-bottom: 20px;
            box-shadow: 0 0 10px rgba(0, 255, 102, 0.2);
        }
        .timer-digits { font-family: monospace; font-size: 1.5rem; color: var(--success); margin-top: 5px; }

        /* Logs Tabs */
        .log-tabs { display: flex; margin-bottom: 10px; border-bottom: 1px solid #333; }
        .log-tab-btn { flex: 1; background: none; border: none; color: #666; padding: 10px; cursor: pointer; }
        .log-tab-btn.active { color: #fff; border-bottom: 2px solid var(--primary); }
        .log-content { height: 300px; overflow-y: auto; background: rgba(0,0,0,0.3); padding: 10px; font-size: 0.8rem; }
        .log-entry { padding: 5px 0; border-bottom: 1px dashed #333; color: #ccc; }
        .log-time { float: right; color: #666; font-size: 0.7rem; }

        /* Toasts */
        #toast-container { position: fixed; top: 70px; right: 10px; z-index: 9999; display: flex; flex-direction: column; gap: 8px; width: 90%; max-width: 320px; pointer-events: none; }
        .toast-alert { background: rgba(0,0,0,0.9); border-left: 4px solid #fff; padding: 12px; border-radius: 4px; color: #fff; box-shadow: 0 5px 15px rgba(0,0,0,0.8); pointer-events: auto; font-size: 0.9rem; animation: slideInLeft 0.3s ease; backdrop-filter: blur(5px); }
        @keyframes slideInLeft { from { transform: translateX(100%); opacity: 0; } to { transform: translateX(0); opacity: 1; } }

        /* Modal */
        .modal { display: none; position: fixed; z-index: 200; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.9); align-items: center; justify-content: center; }
        .modal-content { background: var(--bg-panel); border: 1px solid var(--primary); width: 90%; max-width: 400px; padding: 20px; border-radius: 10px; position: relative; max-height: 80vh; overflow-y: auto; }
        .close-modal { position: absolute; top: 10px; right: 15px; font-size: 24px; color: #fff; cursor: pointer; }

        /* Responsividade PC: Centralizar app */
        @media (min-width: 769px) {
            body { display: flex; justify-content: center; background-color: #000; }
            .app-container { width: 450px; height: 100vh; position: relative; border-left: 1px solid #333; border-right: 1px solid #333; box-shadow: 0 0 50px rgba(0,0,0,0.5); overflow: hidden; }
            .app-header, .app-nav { position: absolute; width: 100%; } /* Dentro do container */
        }
        @media (max-width: 768px) {
            .app-container { width: 100%; height: 100%; }
        }
    </style>
</head>
<body>

<div class="app-container">
    <div class="app-overlay"></div>

    <header class="app-header">
        <div class="char-summary">
            <div class="char-avatar"><i class="fas fa-user-knight"></i></div>
            <div class="char-details">
                <div class="char-name"><?= $nomePersonagem ?? 'Desconhecido' ?></div>
                <div class="char-bars">
                    <div class="bar-wrap"><div class="bar-fill bar-hp" style="width: <?= $hp_atual ?>%;"></div></div>
                    <div class="bar-wrap"><div class="bar-fill bar-energy" style="width: <?= $fome ?>%;"></div></div>
                </div>
            </div>
        </div>
        <div class="header-actions">
            <a href="pagina_notificacoesjogo.php" style="position:relative;">
                <button class="header-btn"><i class="fas fa-bell"></i></button>
                <?php if($total_notificacoes > 0): ?><span class="notification-dot"></span><?php endif; ?>
            </a>
            <button class="header-btn" onclick="confirmarSaida()"><i class="fas fa-sign-out-alt"></i></button>
        </div>
    </header>

    <main class="app-content">
        
        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-card" style="border-color: var(--accent); color: var(--accent); text-align: center;">
                <?= htmlspecialchars($_SESSION['msg']) ?>
            </div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <div id="view-map" class="view-tab active">
            <div class="game-card" style="text-align: center;">
                <div class="card-title">Localização Atual</div>
                <h2 style="color: #fff; font-size: 1.2rem;"><?= htmlspecialchars($nomelocal) ?></h2>
                <div style="font-size: 0.8rem; color: #aaa;">
                    Dominado por: <span style="color: var(--accent)"><?= htmlspecialchars($dominio_local) ?></span>
                </div>
                <div style="font-size: 0.8rem; color: #aaa; margin-top: 5px;">
                    Situação: <span style="color: var(--primary)"><?= $situacao ?></span>
                </div>
            </div>

            <div class="map-wrapper">
                <?php
                // CÓDIGO DO MAPA (Mantido, mas simplificado para o grid)
                $locais_invadidos = [];
                try {
                    $stmtInv = $pdo->query("SELECT local FROM guerra_dominio WHERE dominou = 0 AND (defensor IS NULL OR defensor = '') AND iniciou > DATE_SUB(NOW(), INTERVAL 7 MINUTE)");
                    $locais_invadidos = $stmtInv->fetchAll(PDO::FETCH_COLUMN);
                } catch (Exception $e) {}

                $local_atual = $local ?? ''; 
                $stmtMap = $pdo->query("SELECT nome, tipo, dominio FROM mapasmed LIMIT 36");
                
                while ($row_map = $stmtMap->fetch(PDO::FETCH_ASSOC)) {
                    $nome = $row_map["nome"];
                    $tipo = $row_map["tipo"]; 
                    $dominio_mapa = $row_map["dominio"];
                    $isCurrent = ($nome == $local_atual);
                    $isInvaded = in_array($nome, $locais_invadidos);
                    $img_src = "fts/mapa/terreno/" . $tipo . ".png"; 

                    echo '<div class="map-cell" onclick="showLocationDescription(\''.$nome.'\')">';
                    echo '<img src="'.$img_src.'" class="terrain">';
                    if (!empty($dominio_mapa) && $dominio_mapa !== 'Nenhum') {
                        $bandeira_src = "cla/fts/bandeiras/" . $dominio_mapa . ".png";
                        echo '<img src="'.$bandeira_src.'" class="map-flag" onerror="this.style.display=\'none\'">';
                    }
                    if ($isInvaded) echo '<img src="fts/mapa/icones/fire.png" class="map-fire">';
                    if ($isCurrent) echo '<img src="personagem.png" class="map-marker">';
                    echo '</div>';
                }
                ?>
            </div>

            <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                <form action="personagem/acoes/moverperson.php" method="post" class="d-pad">
                    <input type="hidden" name="mover" value="1">
                    <div class="d-spacer"></div>
                    <?php if($show_n): ?><button type="submit" name="direcao" value="<?= $norte_id ?>" class="d-btn"><i class="fas fa-chevron-up"></i></button><?php else: ?><div class="d-btn" style="opacity:0.3"><i class="fas fa-ban"></i></div><?php endif; ?>
                    <div class="d-spacer"></div>
                    
                    <?php if($show_o): ?><button type="submit" name="direcao" value="<?= $oeste_id ?>" class="d-btn"><i class="fas fa-chevron-left"></i></button><?php else: ?><div class="d-btn" style="opacity:0.3"><i class="fas fa-ban"></i></div><?php endif; ?>
                    <div class="d-btn" style="border-color: #fff; color: #fff;"><i class="fas fa-map-marker-alt"></i></div>
                    <?php if($show_l): ?><button type="submit" name="direcao" value="<?= $leste_id ?>" class="d-btn"><i class="fas fa-chevron-right"></i></button><?php else: ?><div class="d-btn" style="opacity:0.3"><i class="fas fa-ban"></i></div><?php endif; ?>
                    
                    <div class="d-spacer"></div>
                    <?php if($show_s): ?><button type="submit" name="direcao" value="<?= $sul_id ?>" class="d-btn"><i class="fas fa-chevron-down"></i></button><?php else: ?><div class="d-btn" style="opacity:0.3"><i class="fas fa-ban"></i></div><?php endif; ?>
                    <div class="d-spacer"></div>
                </form>
            <?php endif; ?>
        </div>

        <div id="view-char" class="view-tab">
            <div class="game-card">
                <div class="card-title">Recursos</div>
                <div class="resource-grid">
                    <div class="res-item"><span>💰 Prata</span> <span class="res-val"><?= $prata ?></span></div>
                    <div class="res-item"><span>💎 Ouro</span> <span class="res-val"><?= $row['ouro'] ?></span></div>
                    <div class="res-item"><span>🥩 Carne</span> <span class="res-val"><?= $carne ?></span></div>
                    <div class="res-item"><span>🪵 Madeira</span> <span class="res-val"><?= $madeira ?></span></div>
                </div>
            </div>
            
            <div class="game-card">
                <div class="card-title">Militar & Stats</div>
                <div class="resource-grid">
                    <div class="res-item"><span>⚔️ Soldados</span> <span class="res-val"><?= $soldados ?></span></div>
                    <div class="res-item"><span>🛡️ Defesa</span> <span class="res-val"><?= $def ?></span></div>
                    <div class="res-item"><span>🗡️ Ataque</span> <span class="res-val"><?= $atk ?></span></div>
                    <div class="res-item"><span>🏆 Reputação</span> <span class="res-val"><?= $row['reputacao'] ?></span></div>
                </div>
            </div>

            <div class="game-card">
                <div class="card-title">Sobrevivência</div>
                <div style="margin-bottom: 5px;">Sede</div>
                <div class="bar-wrap"><div class="bar-fill" style="width: <?= $sede ?>%; background: <?= getBarColor($sede) ?>;"></div></div>
                <?php if ($is_litoral): ?>
                    <form action="personagem/acoes/beberagua.php" method="POST" style="margin-top:5px;">
                        <button type="submit" name="treinar" class="btn-neon" style="padding: 5px; font-size:0.8rem;">Beber Água</button>
                    </form>
                <?php endif; ?>

                <div style="margin-top: 10px; margin-bottom: 5px;">Fome</div>
                <div class="bar-wrap"><div class="bar-fill" style="width: <?= $fome ?>%; background: <?= getBarColor($fome) ?>;"></div></div>
                <?php if ($carne > 0): ?>
                    <form action="personagem/acoes/alimentar.php" method="POST" style="margin-top:5px;">
                        <button type="submit" name="treinar" class="btn-neon" style="padding: 5px; font-size:0.8rem;">Comer</button>
                    </form>
                <?php endif; ?>
            </div>
        </div>

        <div id="view-actions" class="view-tab">
            
            <?php
            $agora = time();
            $fim = strtotime($paralisado);
            $segundos_restantes = $fim - $agora;
            
            // Definição das ações de retorno (Mesma lógica do seu código original)
            $action = ''; $buttonText = '';
            if ($situacao == "trabalhando") { $action = "personagem/acoes/pegarpg.php"; $buttonText = "$ Receber Pagamento $"; }
            elseif ($situacao == "caçando") { $action = "personagem/acoes/finalisarcaca.php"; $buttonText = "♣⚔ Recolher Caça ⚔♣"; }
            elseif ($situacao == "pegando madeira") { $action = "personagem/acoes/finalisarlenha.php"; $buttonText = "♣ Recolher Madeira ♣"; }
            elseif ($situacao == "treinandoATK") { $action = "personagem/acoes/finalisartreinoatk.php"; $buttonText = "♣⚔️ Concluir Treino ⚔♣"; }
            elseif ($situacao == "treinandoDEF") { $action = "personagem/acoes/finalisartreinodef.php"; $buttonText = "♣⚔ Concluir Treino ⚔♣"; }
            elseif ($situacao == "Invadindo cidade") { $action = "admcity/finalizar_dominio.php"; $buttonText = "⚔ Concluir Invasão ⚔"; }
            elseif ($situacao == "pescando") { $action = "personagem/acoes/finalisarpesca.php"; $buttonText = "♠️ Recolher Rede ♠️"; }
            elseif ($situacao == "bebendoagua") { $action = "personagem/acoes/finalisarbeberagua.php"; $buttonText = "♣  Voltar à Ativa ♣"; }
            elseif ($situacao == "alimentando") { $action = "personagem/acoes/alimentar_finalizar.php"; $buttonText = "♠️ Voltar à Ativa ♠️"; }
            elseif ($situacao == "fugindo e reagrupando soldados" || $situacao == "reagrupando soldados" || $situacao == "escondido") { $action = "personagem/acoes/aparecer.php"; $buttonText = "♣ Aparecer ♣"; }
            ?>

            <?php if ($segundos_restantes > 0): ?>
                <div class="active-action-bar" id="box-cronometro">
                    <div style="font-size:0.8rem; color:#aaa; text-transform: uppercase;"><?= $situacao ?></div>
                    <div id="timer-display" class="timer-digits">--:--:--</div>
                </div>
            <?php elseif ($situacao != "livre" && $situacao != '' && $action): ?>
                <div class="active-action-bar" style="border-color: var(--success);">
                    <form action="<?= $action ?>" method="POST">
                        <input type="hidden" name="local" value="treino">
                        <button type="submit" name="treinar" class="btn-neon" style="margin:0; border:none; background:transparent; color:var(--success); font-size:1.2rem;">
                            <?= $buttonText ?>
                        </button>
                    </form>
                </div>
            <?php endif; ?>

            <div class="game-card">
                <div class="card-title">Interações no Local</div>
                
                <button type="button" class="btn-neon" onclick="abrirModalPersonagens()"><i class="fas fa-users"></i> Ver quem está aqui</button>
                
                <?php if ($situacao == "livre" || $situacao == ''): ?>
                    
                    <?php if ($tipolocal == "city"): ?>
                        <form action="trabalhar.php" method="POST">
                            <button type="submit" name="trabalhar" class="btn-neon" onclick="return confirm('Trabalhar?')"><i class="fas fa-hammer"></i> Trabalhar</button>
                        </form>
                        
                        <div style="display:flex; gap:5px; margin-top:10px;">
                            <form action="personagem/acoes/contratar.php" method="POST" style="flex:1;">
                                <input type="number" name="quantidade" min="1" placeholder="Qtd" style="width:100%; padding:8px; margin-bottom:5px; background:#000; color:#fff; border:1px solid #444; border-radius:4px;">
                                <button type="submit" name="contratar" class="btn-neon" style="font-size:0.8rem;">Contratar</button>
                            </form>
                            <form action="personagem/acoes/vendercarne.php" method="POST" style="flex:1;">
                                <input type="number" name="quantidade" min="1" max="<?= $carne ?>" placeholder="Carne" style="width:100%; padding:8px; margin-bottom:5px; background:#000; color:#fff; border:1px solid #444; border-radius:4px;">
                                <button type="submit" name="vendercarne" class="btn-neon btn-danger-neon" style="font-size:0.8rem;">Vender</button>
                            </form>
                        </div>
                    <?php endif; ?>

                    <?php if ($tipolocal == "campo"): ?>
                        <form action="treinaratk.php" method="POST"><button type="submit" name="treinar" class="btn-neon"><i class="fas fa-sword"></i> Treinar Ataque</button></form>
                        <form action="treinardef.php" method="POST"><button type="submit" name="treinar" class="btn-neon"><i class="fas fa-shield-alt"></i> Treinar Defesa</button></form>
                    <?php endif; ?>

                    <?php if ($tipolocal == "mata"): ?>
                        <form action="personagem/acoes/caca.php" method="POST"><button type="submit" name="caca" class="btn-neon"><i class="fas fa-paw"></i> Caçar</button></form>
                        <form action="personagem/acoes/lenhar.php" method="POST"><button type="submit" name="lenhar" class="btn-neon"><i class="fas fa-tree"></i> Lenhar</button></form>
                    <?php endif; ?>

                    <?php if (isset($cla) && ($cla != $dominio_local)): ?>
                        <form action="admcity/dominar.php" method="POST" onsubmit="return confirm('Iniciar domínio? Ação de alto risco!');" style="margin-top:15px;">
                            <input type="hidden" name="local_alvo" value="<?= htmlspecialchars($local); ?>">
                            <button type="submit" class="btn-neon btn-danger-neon"><i class="fas fa-skull"></i> INVADIR CIDADE</button>
                        </form>
                    <?php endif; ?>

                <?php endif; ?>
            </div>
        </div>

        <div id="view-social" class="view-tab">
            <div class="game-card" style="height: 400px; padding: 0; overflow: hidden; display: flex; flex-direction: column;">
                <div class="card-title" style="margin: 10px;">Chat Local</div>
                <iframe src="chat_firebase.php" style="border:none; width:100%; flex-grow:1; background:transparent;"></iframe>
            </div>

            <div class="game-card">
                <div class="card-title">Clã: <?= $cla ?></div>
                <?php if (!empty($cla) && $cla !== 'Nenhum'): ?>
                    <div style="background: rgba(0,0,0,0.3); padding:10px; border-radius:5px; margin-bottom:10px;">
                        <div style="color:var(--primary); font-size:0.8rem; margin-bottom:5px;">ORDEM GERAL</div>
                        <i style="color:#ccc;">"<?= nl2br(htmlspecialchars($texto_og)) ?>"</i>
                    </div>
                    
                    <div style="display:grid; grid-template-columns: 1fr 1fr; gap:10px;">
                        <a href="cla/acoes/lista_membros_cla.php"><button class="btn-neon" style="font-size:0.8rem;">Membros</button></a>
                        <?php if ($cargo_id >= 3): ?><a href="cla/acoes/ordens_cla.php"><button class="btn-neon" style="font-size:0.8rem;">Ordens</button></a><?php endif; ?>
                    </div>
                <?php else: ?>
                    <p style="text-align:center; color:#888;">Você não tem clã.</p>
                    <a href="clas.php"><button class="btn-neon">Procurar Clã</button></a>
                <?php endif; ?>
            </div>
        </div>

        <div id="view-logs" class="view-tab">
            <div class="game-card">
                <div class="log-tabs">
                    <button class="log-tab-btn active" onclick="switchLog('geral')">Global</button>
                    <button class="log-tab-btn" onclick="switchLog('local')">Local</button>
                    <button class="log-tab-btn" onclick="switchLog('cla')">Clã</button>
                </div>
                
                <div id="log-container-geral" class="log-content" style="display:block;">
                    <div id="feed-geral"><div style="text-align:center; padding:20px;">Carregando...</div></div>
                </div>
                <div id="log-container-local" class="log-content" style="display:none;">
                    <div id="feed-local"><div style="text-align:center; padding:20px;">Carregando...</div></div>
                </div>
                <div id="log-container-cla" class="log-content" style="display:none;">
                    <div id="feed-cla"><div style="text-align:center; padding:20px;">Carregando...</div></div>
                </div>
            </div>
            
            <div class="game-card">
                <div class="card-title">Histórico Pessoal</div>
                <div class="log-content" style="height: 200px;">
                    <?php foreach ($messages as $message): ?>
                        <div class="log-entry">
                            <span class="log-time"><?= date('d/m H:i', strtotime($message['dataehora'])) ?></span>
                            <?= $message['acao'] ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

    </main>

    <nav class="app-nav">
        <button class="nav-item active" onclick="switchTab('view-map', this)"><i class="fas fa-map-marked-alt"></i>Mapa</button>
        <button class="nav-item" onclick="switchTab('view-char', this)"><i class="fas fa-user"></i>Eu</button>
        <button class="nav-item" onclick="switchTab('view-actions', this)"><i class="fas fa-fist-raised"></i>Ações</button>
        <button class="nav-item" onclick="switchTab('view-social', this)"><i class="fas fa-users"></i>Social</button>
        <button class="nav-item" onclick="switchTab('view-logs', this)"><i class="fas fa-scroll"></i>Logs</button>
    </nav>

</div>

<div id="locationModal" class="modal">
    <div class="modal-content">
        <span class="close-modal" onclick="closeModal('locationModal')">&times;</span>
        <h2 id="modalLocationName" style="color: var(--primary);"></h2>
        <p id="modalLocationDescription" style="margin-top:15px; color:#ccc; line-height:1.5;"></p>
    </div>
</div>

<div id="modalPersonagens" class="modal">
    <div class="modal-content">
        <span class="close-modal" onclick="closeModal('modalPersonagens')">&times;</span>
        <h2 style="color: var(--primary);">Personagens no Local</h2>
        <div id="conteudoModal" style="margin-top:15px; max-height: 300px; overflow-y:auto;"></div>
    </div>
</div>

<div id="toast-container"></div>

<script>
    // --- LÓGICA DE UI (TAB SWITCHING) ---
    function switchTab(viewId, btn) {
        // Esconde todas as tabs
        document.querySelectorAll('.view-tab').forEach(el => el.classList.remove('active'));
        document.querySelectorAll('.nav-item').forEach(el => el.classList.remove('active'));
        
        // Mostra a selecionada
        document.getElementById(viewId).classList.add('active');
        btn.classList.add('active');
    }

    function switchLog(type) {
        document.querySelectorAll('.log-content').forEach(el => el.style.display = 'none');
        document.querySelectorAll('.log-tab-btn').forEach(el => el.classList.remove('active'));
        
        document.getElementById('log-container-' + type).style.display = 'block';
        event.target.classList.add('active');
    }

    function closeModal(id) { document.getElementById(id).style.display = 'none'; }
    
    function showLocationDescription(n) { 
        fetch('?location=' + encodeURIComponent(n)).then(r => r.text()).then(d => { 
            document.getElementById('modalLocationName').textContent = n; 
            document.getElementById('modalLocationDescription').textContent = d; 
            document.getElementById('locationModal').style.display = 'flex'; 
        }); 
    }

    function abrirModalPersonagens() {
        const m = document.getElementById('modalPersonagens');
        const c = document.getElementById('conteudoModal');
        m.style.display = 'flex';
        c.innerHTML = '<p style="text-align:center; color:#888;">Carregando radar...</p>';
        fetch('jogo/quemestanolocal.php', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: 'local=' + encodeURIComponent('<?= $local ?? "" ?>') })
        .then(r => r.text()).then(d => { c.innerHTML = d; });
    }
    
    function confirmarSaida() { if (confirm("Sair do jogo?")) window.location.href = "logout.php"; }

    // --- LÓGICA DO JOGO (Mantida do seu script original) ---
    
    // Timer PHP -> JS
    <?php if ($segundos_restantes > 0): ?>
    (function() {
        var timeLeft = <?= max(0, $segundos_restantes); ?>;
        var display = document.getElementById('timer-display');
        var boxTimer = document.getElementById('box-cronometro');
        
        function updateTimer() {
            if (timeLeft <= 0) {
                location.reload(); // Recarrega para mostrar o botão de finalizar
                return;
            }
            var h = Math.floor(timeLeft / 3600);
            var m = Math.floor((timeLeft % 3600) / 60);
            var s = timeLeft % 60;
            display.textContent = (h<10?'0'+h:h) + ":" + (m<10?'0'+m:m) + ":" + (s<10?'0'+s:s);
            timeLeft--;
        }
        setInterval(updateTimer, 1000);
        updateTimer();
    })();
    <?php endif; ?>

    // Monitoramento e Notificações (Lógica exata anterior)
    var meuCla = '<?= trim($cla ?? "") ?>';
    var localAtual = '<?= $local ?? "" ?>';
    var nomePersonagem = '<?= $nomePersonagem ?? "" ?>';
    var dadosRequest = new FormData();
    dadosRequest.append('cla', meuCla);
    dadosRequest.append('local', localAtual);

    function atualizarFeeds() {
        fetch('jogo/api_ocorrencias.php', { method: 'POST', body: dadosRequest })
        .then(r => r.json())
        .then(data => {
            renderLog('feed-geral', data.geral);
            renderLog('feed-local', data.local);
            renderLog('feed-cla', data.cla);
            
            // Check simples de notificação nova (lógica simplificada)
            if(data.cla.length > 0 && data.cla[0].id > lastClaId) { 
                lastClaId = data.cla[0].id; criarToast("Clã", data.cla[0].situacao, "#00d2ff"); 
            }
        }).catch(e => {});
    }

    var lastClaId = 0;
    function renderLog(id, lista) {
        if(!lista || lista.length === 0) { document.getElementById(id).innerHTML = '<div style="text-align:center; padding:10px; color:#555;">Nada recente.</div>'; return; }
        let html = '';
        lista.forEach(item => {
            let hora = item.data ? item.data.substring(11, 16) : '--:--';
            html += `<div class="log-entry"><span class="log-time">${hora}</span>${item.situacao}</div>`;
        });
        document.getElementById(id).innerHTML = html;
    }

    function criarToast(titulo, msg, cor) {
        var c = document.getElementById('toast-container');
        var d = document.createElement('div');
        d.className = 'toast-alert';
        d.style.borderLeftColor = cor;
        d.innerHTML = `<strong>${titulo}</strong><br>${msg}`;
        c.prepend(d);
        setTimeout(() => { d.remove(); }, 5000);
    }

    // Loops
    setInterval(atualizarFeeds, 10000);
    atualizarFeeds();
    
    // Recarregar se status mudar
    var statusNaTela = "<?= $situacao ?? '' ?>";
    setInterval(function() {
        fetch('sistema/scripts/verificar_status_situacao_personagem.php').then(r=>r.text()).then(s => {
            if (s.trim() !== "" && s.trim() !== statusNaTela) location.reload();
        });
    }, 4000);

</script>
</body>
</html>