<?php
session_start();
require 'conexao.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Configurações e variáveis
$msgsis2 = $_SESSION['msg2'] ?? '';
$user_id = $_SESSION['user_name'];
$precomadeira = "27";
$_SESSION['precomadeira'] = $precomadeira;
$precocarne = "36";
$_SESSION['precocarne'] = $precocarne;

// Notificações
$sqlCountNotificacoes = "SELECT COUNT(*) AS total_notificacoes FROM notificacoes_jogo WHERE user2 = :user_name AND vz2 = 0";
$stmtCountNotificacoes = $pdo->prepare($sqlCountNotificacoes);
$stmtCountNotificacoes->bindParam(':user_name', $user_id, PDO::PARAM_STR);
$stmtCountNotificacoes->execute();
$resultado = $stmtCountNotificacoes->fetch(PDO::FETCH_ASSOC);
$total_notificacoes = $resultado['total_notificacoes'];

// Processar seleção de personagem
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['personagem'])) {
    $_SESSION['personagem'] = $_POST['personagem'];
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Buscar descrição do local quando um quadrado do mapa for clicado
if (isset($_GET['location'])) {
    $location = $_GET['location'];
    $sqlLocation = "SELECT descricao FROM mapasmed WHERE nome = :location";
    $stmtLocation = $pdo->prepare($sqlLocation);
    $stmtLocation->bindParam(':location', $location, PDO::PARAM_STR);
    $stmtLocation->execute();
    $locationInfo = $stmtLocation->fetch(PDO::FETCH_ASSOC);
    
    if ($locationInfo) {
        echo $locationInfo['descricao'];
        exit();
    }
}

// Consulta para encontrar o personagem ativo (situacao != 0)
$vendendo = "vendendo";
$sql = "SELECT * FROM personagens WHERE jogador = :user_id AND ativo = 1 LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $personagemAtivo = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Define o personagem ativo na sessão
    $_SESSION['personagem'] = $personagemAtivo['id'];
    $_SESSION['personagem_nome'] = $personagemAtivo['personagem'];
 
    // Mostrar informações do personagem selecionado
    if (isset($_SESSION['personagem'])) {
        $personagem_id = $_SESSION['personagem'];
        $sql = "SELECT * FROM personagens WHERE id = :personagem_id AND jogador = :user_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':personagem_id', $personagem_id, PDO::PARAM_INT);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $_SESSION['personagem_nome'] = $row['personagem'];
            $_SESSION['local'] = $row['local'];
            $paralisado = $row['paralisado'];
            $prata = $row['prata'];
            $soldados = $row['soldados'];
            $carne = $row['carne'];
            $_SESSION['carne'] = $carne;
            $madeira = $row['madeira'];
            $_SESSION['madeira'] = $madeira;
            $_SESSION['soldados'] = $soldados;
            $_SESSION['prata'] = $prata;
            $atk = $row['atk'];
            $_SESSION['atk'] = $atk;
            $def = $row['def'];
            $_SESSION['def'] = $def;
            $cla = $row['cla'];
            $_SESSION['cla'] = $cla;
            $situacao = $row['situacao'];
            $_SESSION['situacao'] = $situacao;
            $datamovimentacao = $row['datamovimentacao'];
            $_SESSION['datamovimentacao'] = $datamovimentacao;

            // Obter informações do local
            $local = $_SESSION['local'];
            $sql = "SELECT tipo, n, l, s, o FROM mapasmed WHERE nome = :local";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':local', $local, PDO::PARAM_STR);
            $stmt->execute();
            
            if ($stmt->rowCount() > 0) {
                $local_info = $stmt->fetch(PDO::FETCH_ASSOC);
                $tipolocal = $local_info['tipo'];
                $norte = $local_info['n'];
                $leste = $local_info['l'];
                $sul = $local_info['s'];
                $oeste = $local_info['o'];
            }
        }
    }
}

// Verifica se há um personagem selecionado na sessão para buscar ações
if (isset($_SESSION['personagem'])) {
    // Primeiro, obtemos o nome do personagem selecionado
    $sqlPersonagem = "SELECT personagem FROM personagens WHERE id = :personagem_id";
    $stmtPersonagem = $pdo->prepare($sqlPersonagem);
    $stmtPersonagem->bindParam(':personagem_id', $_SESSION['personagem'], PDO::PARAM_INT);
    $stmtPersonagem->execute();
    $personagem = $stmtPersonagem->fetch(PDO::FETCH_ASSOC);
    
    if ($personagem) {
        $nomePersonagem = $personagem['personagem'];
        
        // Consulta para buscar ações relacionadas ao personagem selecionado
        $sqlMessages = "SELECT 
                            id,
                            acao, 
                            dataehora,
                            tipoacao,
                            origem,
                            jogador,
                            vz
                        FROM acoespersonagens 
                        WHERE personagem = :personagem
                        ORDER BY dataehora DESC 
                        LIMIT 15";
        
        $stmtMessages = $pdo->prepare($sqlMessages);
        $stmtMessages->bindParam(':personagem', $nomePersonagem, PDO::PARAM_STR);
        $stmtMessages->execute();
        $messages = $stmtMessages->fetchAll(PDO::FETCH_ASSOC);
        
        // Atualizar as mensagens não visualizadas (vz = 0)
        $idsParaAtualizar = [];
        foreach ($messages as $message) {
            if ($message['vz'] == 0) {
                $idsParaAtualizar[] = $message['id'];
            }
        }
        
        if (!empty($idsParaAtualizar)) {
            $placeholders = implode(',', array_fill(0, count($idsParaAtualizar), '?'));
            $sqlUpdate = "UPDATE acoespersonagens SET vz = 1 WHERE id IN ($placeholders)";
            $stmtUpdate = $pdo->prepare($sqlUpdate);
            $stmtUpdate->execute($idsParaAtualizar);
        }
    } else {
        $messages = [];
    }
} else {
    $messages = [];
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Medieval Fantasy - Dervian</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=MedievalSharp&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --azul-vivo: #0066cc;
            --azul-hover: #0099ff;
            --azul-escuro: #003366;
            --marrom: #8B4513;
            --marrom-claro: #A0522D;
            --ouro: #D4AF37;
            --prata: #C0C0C0;
            --preto: #0a0a0a;
            --preto-claro: #1a1a1a;
            --branco: #f0f0f0;
            --cinza: #808080;
            --vermelho: #cc0000;
            --verde: #00aa00;
            --sombra: 0 4px 8px rgba(0, 0, 0, 0.6);
            --borda-dourada: 2px solid var(--ouro);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'MedievalSharp', cursive;
            background: url('textura-papel-envelhecido.jpg') repeat, linear-gradient(to bottom, #1a1208, #000000);
            color: var(--branco);
            min-height: 100vh;
            overflow-x: hidden;
            padding: 0;
            margin: 0;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 15px;
            display: grid;
            grid-template-rows: auto 1fr auto;
            min-height: 100vh;
            gap: 15px;
        }
        
        /* Header Styles */
        .header {
            background: url('bn.png') center/cover no-repeat;
            height: 180px;
            border: var(--borda-dourada);
            border-radius: 8px;
            position: relative;
            box-shadow: var(--sombra);
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            padding: 15px;
        }
        
        .welcome {
            font-size: 2.2rem;
            color: var(--ouro);
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.8);
            margin-bottom: 10px;
        }
        
        .navigation {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        
        /* Button Styles */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 18px;
            background: var(--azul-escuro);
            color: var(--branco);
            border: 2px solid var(--azul-vivo);
            border-radius: 6px;
            font-family: 'MedievalSharp', cursive;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            gap: 5px;
        }
        
        .btn:hover {
            background: var(--azul-vivo);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 102, 204, 0.4);
        }
        
        .btn-menu {
            background: var(--marrom);
            border-color: var(--marrom-claro);
        }
        
        .btn-danger {
            background: var(--vermelho);
            border-color: #ff4444;
        }
        
        .btn-success {
            background: var(--verde);
            border-color: #00ff44;
        }
        
        .btn-warning {
            background: var(--ouro);
            border-color: #ffcc00;
            color: var(--preto);
        }
        
        .notification-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: var(--vermelho);
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.7rem;
            font-weight: bold;
        }
        
        .btn-notification {
            position: relative;
        }
        
        /* Main Content Grid */
        .main-content {
            display: grid;
            grid-template-columns: 300px 1fr 350px;
            gap: 15px;
            height: calc(100vh - 250px);
        }
        
        /* Character Panel */
        .character-panel {
            background: rgba(26, 18, 8, 0.9);
            border: var(--borda-dourada);
            border-radius: 8px;
            padding: 15px;
            box-shadow: var(--sombra);
            overflow-y: auto;
        }
        
        .panel-title {
            color: var(--ouro);
            font-size: 1.4rem;
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 1px solid var(--marrom-claro);
            text-align: center;
        }
        
        .character-info {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }
        
        .info-card {
            background: rgba(0, 0, 0, 0.4);
            padding: 12px;
            border-radius: 6px;
            border-left: 4px solid var(--azul-vivo);
        }
        
        .info-card h3 {
            color: var(--azul-vivo);
            margin-bottom: 8px;
            font-size: 1.1rem;
        }
        
        .info-card p {
            margin: 5px 0;
            display: flex;
            justify-content: space-between;
        }
        
        .info-card span {
            font-weight: bold;
            color: var(--prata);
        }
        
        /* Map Panel */
        .map-panel {
            background: rgba(26, 18, 8, 0.9);
            border: var(--borda-dourada);
            border-radius: 8px;
            padding: 15px;
            box-shadow: var(--sombra);
            display: flex;
            flex-direction: column;
        }
        
        .map-container {
            display: grid;
            grid-template-columns: repeat(6, 1fr);
            grid-template-rows: repeat(6, 1fr);
            gap: 5px;
            margin: 0 auto;
            width: 100%;
            height: 100%;
        }
        
        .map-square {
            position: relative;
            border: 1px solid var(--marrom-claro);
            border-radius: 4px;
            cursor: pointer;
            transition: all 0.3s;
            overflow: hidden;
            aspect-ratio: 1/1;
        }
        
        .map-square:hover {
            transform: scale(1.05);
            z-index: 2;
            box-shadow: 0 0 10px var(--azul-vivo);
            border-color: var(--azul-vivo);
        }
        
        .map-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .map-name {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(0, 0, 0, 0.7);
            color: var(--branco);
            font-size: 0.7rem;
            padding: 2px;
            text-align: center;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        
        .map-personagem {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 24px;
            height: 24px;
            background: var(--azul-vivo);
            border-radius: 50%;
            border: 2px solid white;
            box-shadow: 0 0 8px var(--azul-vivo);
        }
        
        /* Actions Panel */
        .actions-panel {
            background: rgba(26, 18, 8, 0.9);
            border: var(--borda-dourada);
            border-radius: 8px;
            padding: 15px;
            box-shadow: var(--sombra);
            overflow-y: auto;
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        
        .action-section {
            background: rgba(0, 0, 0, 0.4);
            border-radius: 6px;
            padding: 12px;
            border-left: 4px solid var(--marrom-claro);
        }
        
        .action-section h3 {
            color: var(--ouro);
            margin-bottom: 10px;
            font-size: 1.1rem;
            padding-bottom: 5px;
            border-bottom: 1px dashed var(--marrom-claro);
        }
        
        .action-form {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }
        
        select, input[type="number"] {
            padding: 8px;
            border: 1px solid var(--marrom-claro);
            border-radius: 4px;
            background: rgba(0, 0, 0, 0.6);
            color: var(--branco);
            font-family: 'MedievalSharp', cursive;
        }
        
        /* Messages Panel */
        .messages-panel {
            grid-column: 1 / -1;
            background: rgba(26, 18, 8, 0.9);
            border: var(--borda-dourada);
            border-radius: 8px;
            padding: 15px;
            box-shadow: var(--sombra);
            max-height: 200px;
            overflow-y: auto;
        }
        
        .message {
            padding: 8px 10px;
            border-bottom: 1px dashed var(--marrom-claro);
            color: var(--branco);
        }
        
        .message:last-child {
            border-bottom: none;
        }
        
        .message-content {
            margin-bottom: 4px;
        }
        
        .message-time {
            font-size: 0.8rem;
            color: var(--prata);
            text-align: right;
        }
        
        .system-message {
            background: rgba(255, 215, 0, 0.1);
            border-left: 3px solid var(--ouro);
            padding: 10px;
            margin: 10px 0;
            border-radius: 4px;
            color: var(--ouro);
            font-weight: bold;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            padding: 15px;
            border-top: 2px solid var(--marrom-claro);
            color: var(--ouro);
            font-size: 1.2rem;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.8);
        }
        
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(5px);
        }
        
        .modal-content {
            background: linear-gradient(to bottom, #2a1f12, #1a1208);
            margin: 5% auto;
            padding: 20px;
            border: var(--borda-dourada);
            border-radius: 8px;
            width: 80%;
            max-width: 600px;
            color: var(--branco);
            position: relative;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.7);
        }
        
        .close-modal {
            color: var(--ouro);
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.3s;
        }
        
        .close-modal:hover {
            color: var(--branco);
        }
        
        /* Combat Iframe */
        .combat-iframe {
            width: 100%;
            height: 300px;
            border: 1px solid var(--marrom-claro);
            border-radius: 6px;
        }
        
        /* Responsive Design */
        @media (max-width: 1100px) {
            .main-content {
                grid-template-columns: 1fr 1fr;
            }
            
            .actions-panel {
                grid-column: span 2;
            }
        }
        
        @media (max-width: 768px) {
            .main-content {
                grid-template-columns: 1fr;
                height: auto;
            }
            
            .actions-panel {
                grid-column: 1;
            }
            
            .map-container {
                grid-template-columns: repeat(3, 1fr);
            }
            
            .navigation {
                justify-content: center;
            }
            
            .header {
                height: auto;
                min-height: 150px;
            }
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: rgba(139, 69, 19, 0.2);
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: var(--marrom);
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: var(--marrom-claro);
        }
        
        /* Status Indicators */
        .status-free {
            color: var(--verde);
        }
        
        .status-busy {
            color: var(--vermelho);
        }
        
        .resource-count {
            display: inline-block;
            padding: 2px 6px;
            background: rgba(0, 0, 0, 0.4);
            border-radius: 10px;
            font-size: 0.9rem;
            min-width: 30px;
            text-align: center;
        }

        /* Estilos específicos para a visualização de recursos */
        .resource-list {
            list-style: none;
            margin: 10px 0;
            padding: 0;
        }
        
        .resource-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 5px;
            border-bottom: 1px solid rgba(139, 69, 19, 0.3);
        }
        
        .resource-item:last-child {
            border-bottom: none;
        }
        
        .resource-name {
            font-weight: bold;
            color: var(--prata);
        }
        
        .resource-value {
            color: var(--ouro);
            font-weight: bold;
        }
        
        /* Melhorias para a seção de últimas ações */
        .actions-list {
            max-height: 300px;
            overflow-y: auto;
            padding: 10px;
            background: rgba(0, 0, 0, 0.3);
            border-radius: 6px;
            border: 1px solid var(--marrom-claro);
        }
        
        .action-item {
            padding: 10px;
            margin-bottom: 8px;
            background: rgba(0, 0, 0, 0.2);
            border-radius: 4px;
            border-left: 3px solid var(--azul-vivo);
        }
        
        .action-item:last-child {
            margin-bottom: 0;
        }
        
        .action-description {
            font-size: 1rem;
            margin-bottom: 5px;
        }
        
        .action-time {
            font-size: 0.8rem;
            color: var(--prata);
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <h1 class="welcome">Bem-vindo, <?php echo htmlspecialchars($_SESSION['user_name']); ?></h1>
            
            <div class="navigation">
                <a href="dashboard.php" class="btn btn-menu"><i class="fas fa-home"></i> Menu Principal</a>
                <a href="pagina_notificacoesjogo.php" class="btn btn-notification">
                    <i class="fas fa-bell"></i> Notificações
                    <?php if ($total_notificacoes >= 1): ?>
                        <span class="notification-badge"><?php echo $total_notificacoes; ?></span>
                    <?php endif; ?>
                </a>
                <a href="javascript:void(0);" onclick="confirmarSaida()" class="btn btn-danger"><i class="fas fa-door-open"></i> Sair</a>
            </div>
        </header>
        
        <main class="main-content">
            <!-- Character Panel -->
            <section class="character-panel">
                <h2 class="panel-title">Seu Personagem</h2>
                
                <div class="character-info">
                    <?php if ($stmt->rowCount() > 0): ?>
                        <div class="info-card">
                            <h3>Informações</h3>
                            <p><strong>Nome:</strong> <span><?php echo $row['personagem']; ?></span></p>
                            <p><strong>Reputação:</strong> <span><?php echo $row['reputacao']; ?></span></p>
                            <p><strong>Local:</strong> <span><?php echo $row['local']; ?></span></p>
                            <p><strong>Situação:</strong> 
                                <span class="<?php echo ($situacao == "livre" || $situacao == '') ? 'status-free' : 'status-busy'; ?>">
                                    <?php echo $row['situacao']; ?>
                                </span>
                            </p>
                            <?php if ($situacao != "livre" && $situacao != ''): ?>
                                <p><strong>Término:</strong> <span><?php echo date('d/m/Y H:i', strtotime($paralisado)); ?></span></p>
                            <?php endif; ?>
                        </div>
                        
                        <div class="info-card">
                            <h3>Recursos</h3>
                            <ul class="resource-list">
                                <li class="resource-item">
                                    <span class="resource-name">Ouro:</span>
                                    <span class="resource-value"><?php echo $row['ouro']; ?></span>
                                </li>
                                <li class="resource-item">
                                    <span class="resource-name">Prata:</span>
                                    <span class="resource-value"><?php echo $row['prata']; ?></span>
                                </li>
                                <li class="resource-item">
                                    <span class="resource-name">Carne:</span>
                                    <span class="resource-value"><?php echo $row['carne']; ?></span>
                                </li>
                                <li class="resource-item">
                                    <span class="resource-name">Madeira:</span>
                                    <span class="resource-value"><?php echo $row['madeira']; ?></span>
                                </li>
                            </ul>
                        </div>
                        
                        <div class="info-card">
                            <h3>Força Militar</h3>
                            <ul class="resource-list">
                                <li class="resource-item">
                                    <span class="resource-name">Soldados:</span>
                                    <span class="resource-value"><?php echo $row['soldados']; ?></span>
                                </li>
                                <li class="resource-item">
                                    <span class="resource-name">Ataque:</span>
                                    <span class="resource-value"><?php echo $row['atk']; ?></span>
                                </li>
                                <li class="resource-item">
                                    <span class="resource-name">Defesa:</span>
                                    <span class="resource-value"><?php echo $row['def']; ?></span>
                                </li>
                                <li class="resource-item">
                                    <span class="resource-name">Clã:</span>
                                    <span class="resource-value"><?php echo $row['cla']; ?></span>
                                </li>
                            </ul>
                        </div>
                    <?php else: ?>
                        <div class="info-card">
                            <h3>Nenhum Personagem Ativo</h3>
                            <p>Por favor, <a href="ativarpersonagens.php">ative um personagem</a> para continuar.</p>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Messages Panel -->
                    <div class="info-card">
                        <h3>Suas últimas Ações</h3>
                        <div class="actions-list">
                            <?php if (!empty($messages)): ?>
                                <?php foreach ($messages as $message): ?>
                                    <div class="action-item" style="<?= ($message['vz'] == 0) ? 'border-left: 3px solid var(--azul-vivo);' : '' ?>">
                                        <div class="action-description"><?= htmlspecialchars($message['acao']) ?></div>
                                        <div class="action-time"><?= date('d/m/Y H:i', strtotime($message['dataehora'])) ?></div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="action-item">
                                    <div class="action-description">Nenhuma ação recente.</div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <?php if (!empty($_SESSION['msg'])): ?>
                        <div class="system-message">
                            <?php 
                            echo htmlspecialchars($_SESSION['msg']);
                            $_SESSION['msg'] = ''; // Limpa a mensagem após exibir
                            ?>
                        </div>
                    <?php endif; ?>
                </div>
            </section>
            
            <!-- Map Panel -->
            <section class="map-panel">
                <h2 class="panel-title">Mapa de Dervian</h2>
                <div class="map-container">
                    <?php
                    $local = isset($_SESSION['local']) ? $_SESSION['local'] : '';
                    $sql = "SELECT nome, tipo FROM mapasmed LIMIT 36";
                    $stmt = $pdo->query($sql);
                    
                    while ($row_map = $stmt->fetch(PDO::FETCH_ASSOC)) {
                        $nome = $row_map["nome"];
                        $tipo = $row_map["tipo"];
                        $isCurrent = ($nome == $local);
                        
                        echo '<div class="map-square" onclick="showLocationDescription(\''.$nome.'\')">';
                        echo '<img class="map-image" src="'.$tipo.'.png" alt="'.$nome.'">';
                        echo '<p class="map-name">'.$nome.'</p>';
                        if ($isCurrent) {
                            echo '<div class="map-personagem"></div>';
                        }
                        echo '</div>';
                    }
                    ?>
                </div>
            </section>
            
            <!-- Actions Panel -->
            <section class="actions-panel">
                <!-- Movimentação -->
                <div class="action-section">
                    <h3>Movimentação</h3>
                    
                    <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                        <form action="moverperson.php" method="post" class="action-form">
                            <select name="direcao">
                                <option value="<?php echo $norte; ?>">Norte (<?php echo $norte; ?>)</option>
                                <option value="<?php echo $leste; ?>">Leste (<?php echo $leste; ?>)</option>
                                <option value="<?php echo $sul; ?>">Sul (<?php echo $sul; ?>)</option>
                                <option value="<?php echo $oeste; ?>">Oeste (<?php echo $oeste; ?>)</option>
                            </select>
                            <button type="submit" class="btn" name="mover" onclick="return confirm('Tem certeza que deseja mover?')">
                                <i class="fas fa-walking"></i> Mover
                            </button>
                        </form>
                        
                        <?php if (isset($tipolocal) && $tipolocal != "city"): ?>
                            <button type="button" class="btn" onclick="abrirModalPersonagens()">
                                <i class="fas fa-users"></i> Quem está no local
                            </button>
                        <?php endif; ?>
                        
                    <?php else: ?>
                        <center><p>Personagem ocupado:<br><?php echo $situacao; ?></p>
                        
                        <?php 
                        if ($situacao == "trabalhando") {echo "Você e seus soldados estão trabalhando<br><br>";}
                        elseif ($situacao == "caçando") {echo "Você e seus soldados estão caçando<br><br>";}
                        elseif ($situacao == "pegando madeira") {echo "Você e seus soldados estão pegando madeira<br><br>";}
                        elseif ($situacao == "treinandoATK") {echo "Você e seus soldados estão treinando o ataque";}
                        elseif ($situacao == "treinandoDEF") {echo "Você e seus soldados estão treinando a defesa";}
                        elseif ($situacao == "escondido") {echo "Vocês foram atacados, perderam a batalha, fugiram e se esconderam<br><br>";}
                        elseif ($situacao == "fugindo e reagrupando soldados") {echo "Vocês efetuaram um ataque mal sucediso<br>agora então fugindo, se escondendo e se reagrupando<br><br>";}
                        elseif ($situacao == "reagrupando soldados") {echo "Vocês efetuaram um ataque bem sucediso<br>agora seus soldados estão se reagrupando<br><br>";}
                        ?>
                        
                        <p>Término: 
                            <?php 
                            if (!empty($paralisado) && strtotime($paralisado)) {
                                echo date('d/m/Y H:i', strtotime($paralisado));
                            } else {
                                echo "Não definido";
                            }
                            ?>
                        </p>
                        
                        <?php
                        $horarioAtual = date('Y-m-d H:i:s');
                        if ($horarioAtual >= $paralisado) {
                            $action = '';
                            $buttonText = '';
                            
                            if ($situacao == "trabalhando") {
                                $action = "pegarpg.php";
                                $buttonText = "Pegar Pagamento";
                            } elseif ($situacao == "caçando") {
                                $action = "finalisarcaca.php";
                                $buttonText = "Finalizar Caçada";
                            } elseif ($situacao == "pegando madeira") {
                                $action = "finalisarlenha.php";
                                $buttonText = "Finalizar Coleta";
                            } elseif ($situacao == "treinandoATK") {
                                $action = "finalisartreinoatk.php";
                                $buttonText = "Finalizar treinamento";
                            } elseif ($situacao == "treinandoDEF") {
                                $action = "finalisartreinodef.php";
                                $buttonText = "Finalizar treinamento";
                            } elseif ($situacao == "escondido") {
                                $action = "jogo/aparecer.php";
                                $buttonText = "Agrupar e aparecer";
                            } elseif ($situacao == "fugindo e reagrupando soldados") {
                                $action = "personagemlivre.php";
                                $buttonText = "Reagrupar e aparecer";
                            } elseif ($situacao == "reagrupando soldados") {
                                $action = "personagemlivre.php";
                                $buttonText = "Concluir reagrupamento";
                            } elseif ($situacao == "Dominando cidade") {
                                $action = "personagemlivre.php";
                                $buttonText = "Concluir domínio";
                            }
                            
                            
                            
                            if ($action && $buttonText) {
                                echo '<form action="'.$action.'" method="POST" class="action-form">';
                                echo '<input type="hidden" name="local" value="treino">';
                                echo '<button type="submit" class="btn btn-success" name="treinar">'.$buttonText.'</button>';
                                echo '</form>';
                            }
                        }
                        ?>
                    <?php endif; ?>
                </div>
                
                <!-- Ações na Cidade -->
                <?php if (isset($tipolocal) && $tipolocal == "city"): ?>
                    <div class="action-section">
                        <h3>Ações na Cidade</h3>
                        <?php if (isset($situacao) && $situacao == "livre"): ?>
                            <form action="trabalhar.php" method="POST" class="action-form">
                                <button type="submit" class="btn" name="trabalhar" onclick="return confirm('Tem certeza? Seu personagem ficará inativo por 5 minutos!')">
                                    <i class="fas fa-hammer"></i> Trabalhar
                                </button>
                            </form>
                            
                            <form action="contratar.php" method="POST" class="action-form">
                                <h4>Contratar Soldados (80 pratas cada)</h4>
                                <div style="display: flex; gap: 8px; align-items: center;">
                                    <input type="number" name="quantidade" min="1" placeholder="Qtd" style="width: 70px;" required>
                                    <button type="submit" class="btn" name="contratar" onclick="return confirm('Confirmar contratação?')">
                                        <i class="fas fa-user-plus"></i> Contratar
                                    </button>
                                </div>
                            </form>
                            
                            <?php if ($soldados >= "1"): ?>
                                <form action="dispensarsoldados.php" method="POST" class="action-form">
                                    <h4>Dispensar soldados</h4>
                                    <div style="display: flex; gap: 8px; align-items: center;">
                                        <input type="number" name="quantidade" min="1" max="<?php echo $soldados; ?>" placeholder="Qtd" style="width: 70px;" required>
                                        <button type="submit" class="btn" name="dispensar" onclick="return confirm('Confirmar dispensa?')">
                                            <i class="fas fa-user-minus"></i> Dispensar
                                        </button>
                                    </div>
                                </form>
                            <?php endif; ?>

                            <?php if ($carne >= "1"): ?>
                                <form action="vendercarne.php" method="POST" class="action-form">
                                    <h4>Vender Carne (<?php echo $precocarne; ?> pratas cada)</h4>
                                    <div style="display: flex; gap: 8px; align-items: center;">
                                        <input type="number" name="quantidade" min="1" max="<?php echo $carne; ?>" placeholder="Qtd" style="width: 70px;" required>
                                        <button type="submit" class="btn btn-warning" name="vendercarne" onclick="return confirm('Confirmar venda?')">
                                            <i class="fas fa-coins"></i> Vender
                                        </button>
                                    </div>
                                </form>
                            <?php endif; ?>
                            
                            <?php if ($madeira >= "1"): ?>
                                <form action="vendermadeira.php" method="POST" class="action-form">
                                    <h4>Vender Madeira (<?php echo $precomadeira; ?> pratas cada)</h4>
                                    <div style="display: flex; gap: 8px; align-items: center;">
                                        <input type="number" name="quantidade" min="1" max="<?php echo $madeira; ?>" placeholder="Qtd" style="width: 70px;" required>
                                        <button type="submit" class="btn btn-warning" name="vendermadeira" onclick="return confirm('Confirmar venda?')">
                                            <i class="fas fa-coins"></i> Vender
                                        </button>
                                    </div>
                                </form>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                
                <!-- Ações no Campo -->
                <?php if (isset($tipolocal) && $tipolocal == "campo" && isset($situacao) && $situacao == "livre"): ?>
                    <div class="action-section">
                        <h3>Treinamento</h3>
                        <form action="treinaratk.php" method="POST" class="action-form">
                            <button type="submit" class="btn" name="treinar" onclick="return confirm('Treinar ataque por 7 minutos?')">
                                <i class="fas fa-fist-raised"></i> Treinar Ataque
                            </button>
                        </form>
                        
                        <form action="treinardef.php" method="POST" class="action-form">
                            <button type="submit" class="btn" name="treinar" onclick="return confirm('Treinar defesa por 7 minutos?')">
                                <i class="fas fa-shield-alt"></i> Treinar Defesa
                            </button>
                        </form>
                    </div>
                <?php endif; ?>
                
                <!-- Ações na Mata -->
                <?php if (isset($tipolocal) && $tipolocal == "mata" && isset($situacao) && $situacao == "livre"): ?>
                    <div class="action-section">
                        <h3>Ações na Floresta</h3>
                        <form action="caca.php" method="POST" class="action-form">
                            <button type="submit" class="btn" name="caca" onclick="return confirm('Caçar por 4 minutos?')">
                                <i class="fas fa-paw"></i> Caçar
                            </button>
                        </form>
                        
                        <form action="lenhar.php" method="POST" class="action-form">
                            <button type="submit" class="btn" name="lenhar" onclick="return confirm('Coletar madeira por 7 minutos?')">
                                <i class="fas fa-tree"></i> Coletar Madeira
                            </button>
                        </form>
                    </div>
                <?php endif; ?>
                
                <!-- Combate -->
                <?php if ($_SESSION['situacao'] !== 'escondido' && $_SESSION['situacao'] !== 'fugindo e reagrupando soldados'): ?>
                    <div class="action-section">
                        <h3>Interação</h3>
                        <div class="combat-iframe">
                            <iframe id="chatIframe" src="somensagenspersonagens.php" style="width: 100%; height: 100%; border: none;"></iframe>
                        </div>
                        <div style="margin-top: 10px;">
                            <iframe id="botoesChatIframe" src="botoeschatpersonagens.php" style="width: 100%; height: 60px; border: none;"></iframe>
                        </div>
                    </div>
                <?php endif; ?>
            </section>
        </main>
        
        <footer class="footer">
            ⚔️ Medieval Fantasy - Dervian ⚔️
        </footer>
    </div>
    
    <!-- Modal para descrição do local -->
    <div id="locationModal" class="modal">
        <div class="modal-content">
            <span class="close-modal" onclick="closeModal()">&times;</span>
            <h2 id="modalLocationName"></h2>
            <p id="modalLocationDescription"></p>
        </div>
    </div>
    
    <!-- Modal Personagens -->
    <div id="modalPersonagens" class="modal">
        <div class="modal-content">
            <span class="close-modal" onclick="fecharModalPersonagens()">&times;</span>
            <h2>Personagens em <?php echo isset($local) ? $local : ''; ?></h2>
            <div id="conteudoModal" style="max-height: 400px; overflow-y: auto; margin-top: 15px;"></div>
        </div>
    </div>

    <script>
        function confirmarSaida() {
            if (confirm("Tem certeza que deseja sair?")) {
                window.location.href = "logout.php";
            }
        }
        
        function abrirModalPersonagens() {
            const modal = document.getElementById('modalPersonagens');
            const conteudo = document.getElementById('conteudoModal');
            
            // Mostra o modal com um loader
            modal.style.display = 'block';
            conteudo.innerHTML = '<p style="text-align: center; color: white;">Carregando...</p>';
            
            // Faz a requisição para a página
            fetch('jogo/quemestanolocal.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'local=' + encodeURIComponent('<?php echo isset($local) ? $local : ''; ?>')
            })
            .then(response => response.text())
            .then(data => {
                conteudo.innerHTML = data;
            })
            .catch(error => {
                conteudo.innerHTML = '<p style="color: red;">Erro ao carregar informações.</p>';
            });
        }

        function fecharModalPersonagens() {
            document.getElementById('modalPersonagens').style.display = 'none';
        }
        
        // Modal para descrição do local
        function showLocationDescription(locationName) {
            fetch('?location=' + encodeURIComponent(locationName))
                .then(response => response.text())
                .then(description => {
                    document.getElementById('modalLocationName').textContent = locationName;
                    document.getElementById('modalLocationDescription').textContent = description;
                    document.getElementById('locationModal').style.display = 'block';
                });
        }
        
        function closeModal() {
            document.getElementById('locationModal').style.display = 'none';
        }
        
        // Fechar modal ao clicar fora
        window.onclick = function(event) {
            if (event.target == document.getElementById('locationModal')) {
                closeModal();
            }
            if (event.target == document.getElementById('modalPersonagens')) {
                fecharModalPersonagens();
            }
        }
        
        // Atualizar a página a cada 30 segundos para atualizar status
        setTimeout(function(){
            location.reload();
        }, 30000);
        
        // Função para recarregar o iframe de mensagens periodicamente
        function recarregarIframeChat() {
            const iframe = document.getElementById('chatIframe');
            if (iframe) {
                iframe.src = iframe.src; // Recarrega o iframe
            }
        }
        
        // Inicia a atualização automática
        document.addEventListener('DOMContentLoaded', function() {
            // Atualiza o chat a cada 5 segundos
            setInterval(recarregarIframeChat, 5000);
        });
    </script>
</body>
</html>