<?php
session_start();
require 'conexao.php';

// 1. Verificação de Acesso
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// 2. Inicialização de Variáveis
$msgsis2 = $_SESSION['msg2'] ?? '';
$user_id = $_SESSION['user_name'];

// Preços e Variáveis Globais
$precomadeira = 27; $_SESSION['precomadeira'] = $precomadeira;
$precocarne = 36; $_SESSION['precocarne'] = $precocarne;

$total_notificacoes = 0;
$personagemAtivo = null; 
$messages = [];
$situacao = 'Nenhum'; 
$local = '';
$paralisado = date('Y-m-d H:i:s'); 
$tipolocal = 'city'; 

// Variáveis de Localização (Inicialização para evitar erros)
$dominio_local = 'Nenhum';
$governante_local = 'Ninguém';
$nomelocal = 'Desconhecido';

// Controle de Direções e Litoral
$norte_id = ''; $leste_id = ''; $sul_id = ''; $oeste_id = ''; 
$show_n = false; $show_l = false; $show_s = false; $show_o = false;
$is_litoral = false;

$horarioAtual = date('Y-m-d H:i:s');

// 3. Notificações
$sqlCountNotificacoes = "SELECT COUNT(*) AS total_notificacoes FROM notificacoes_jogo WHERE user2 = :user_name AND vz2 = 0";
$stmtCountNotificacoes = $pdo->prepare($sqlCountNotificacoes);
$stmtCountNotificacoes->bindParam(':user_name', $user_id, PDO::PARAM_STR);
$stmtCountNotificacoes->execute();
$total_notificacoes = $stmtCountNotificacoes->fetch(PDO::FETCH_ASSOC)['total_notificacoes'];

// 4. Modal Local (Ajax)
if (isset($_GET['location'])) {
    $location = $_GET['location'];
    $sqlLocation = "SELECT descricao FROM mapasmed WHERE nome = :location";
    $stmtLocation = $pdo->prepare($sqlLocation);
    $stmtLocation->bindParam(':location', $location, PDO::PARAM_STR);
    $stmtLocation->execute();
    $locationInfo = $stmtLocation->fetch(PDO::FETCH_ASSOC);
    if ($locationInfo) { echo $locationInfo['descricao']; exit(); }
}

// 5. Consulta Personagem
$sql = "SELECT * FROM personagens WHERE jogador = :user_id AND ativo = 1 LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $personagemAtivo = $row; 
    
    $personagem_id = $row['id'];
    $nomePersonagem = $row['personagem'];
    $personagem = $row['personagem'];
    $situacao = $row['situacao'] ?? 'livre'; 
    $local = $row['local'];
    $paralisado = $row['paralisado'];
    
    // Recursos
    $prata = $row['prata'];
    $soldados = $row['soldados'];
    $carne = $row['carne'];
    $madeira = $row['madeira'];
    $atk = $row['atk'];
    $def = $row['def'];
    $cla = $row['cla'];
    $cargo_id = $row['cargo'] ?? 1;
    
    // Status
    $hp_atual = $row['hp_atual'] ?? 100; 
    $hp_max = $row['hp_max'] ?? 100;
    
    // Colunas de Fome/Sede
    $fome = $row['fome'] ?? 100;
    $sede = $row['sede'] ?? 100;
    
    // Sessão
    $_SESSION['personagem'] = $personagem_id;
    $_SESSION['personagem_nome'] = $nomePersonagem;
     $_SESSION['personagem_nome'] = $nomePersonagem;
    $_SESSION['local'] = $local;
    $_SESSION['situacao'] = $situacao;
    $_SESSION['carne'] = $carne;
    $_SESSION['madeira'] = $madeira;
    $_SESSION['soldados'] = $soldados;
    $_SESSION['prata'] = $prata;
    $_SESSION['sede'] = $sede;
    $_SESSION['fome'] = $fome;
    $_SESSION['cla'] = $cla;
    $_SESSION['cargo_id'] = $cargo_id;

    // --- LÓGICA DE VIZINHOS E LITORAL ---
    // CORREÇÃO AQUI: Adicionado 'dominio' e 'governante' na consulta
    $sqlLocal = "SELECT tipo, regiao, nome, dominio, governante, n, l, s, o FROM mapasmed WHERE nome = :local";
    $stmtLocal = $pdo->prepare($sqlLocal);
    $stmtLocal->bindParam(':local', $local, PDO::PARAM_STR);
    $stmtLocal->execute();
    $local_info = $stmtLocal->fetch(PDO::FETCH_ASSOC);
    
    if ($local_info) {
        $tipolocal = $local_info['tipo'];
        $regiao_atual = $local_info['regiao'];
        
        // CORREÇÃO: Atribuindo as variáveis para uso no HTML
        $nomelocal = $local_info['nome'];
        $dominio_local = $local_info['dominio'];
        $governante_local = $local_info['governante'];
        
        $norte_id = $local_info['n'];
        $leste_id = $local_info['l'];
        $sul_id = $local_info['s'];
        $oeste_id = $local_info['o'];

        $ids_vizinhos = array_filter([$norte_id, $leste_id, $sul_id, $oeste_id]);
        $tipos_vizinhos = [];

        if (!empty($ids_vizinhos)) {
            $inQuery = implode(',', array_map('intval', $ids_vizinhos));
            $sqlViz = "SELECT id2, tipo FROM mapasmed WHERE id2 IN ($inQuery) AND regiao = :regiao";
            $stmtViz = $pdo->prepare($sqlViz);
            $stmtViz->execute([':regiao' => $regiao_atual]);
            $tipos_vizinhos = $stmtViz->fetchAll(PDO::FETCH_KEY_PAIR); 
        }

        function analisarDirecao($id, $lista_tipos) {
            if (empty($id) || !isset($lista_tipos[$id])) return ['show' => false, 'is_mar' => false];
            $tipo = strtolower($lista_tipos[$id]);
            $is_mar = ($tipo === 'mar');
            return ['show' => !$is_mar, 'is_mar' => $is_mar];
        }

        $res = analisarDirecao($norte_id, $tipos_vizinhos); $show_n = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($leste_id, $tipos_vizinhos); $show_l = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($sul_id, $tipos_vizinhos); $show_s = $res['show']; if($res['is_mar']) $is_litoral=true;
        $res = analisarDirecao($oeste_id, $tipos_vizinhos); $show_o = $res['show']; if($res['is_mar']) $is_litoral=true;
    }
    
    // 6. Histórico
    $sqlMessages = "SELECT id, acao, dataehora, vz FROM acoespersonagens WHERE personagem = :personagem ORDER BY dataehora DESC LIMIT 30";
    $stmtMessages = $pdo->prepare($sqlMessages);
    $stmtMessages->bindParam(':personagem', $nomePersonagem, PDO::PARAM_STR);
    $stmtMessages->execute();
    $messages = $stmtMessages->fetchAll(PDO::FETCH_ASSOC);
    
    // Update VZ (Visualizado)
    $idsParaAtualizar = array_column(array_filter($messages, function($m) { return $m['vz'] == 0; }), 'id');
    if (!empty($idsParaAtualizar)) {
        $placeholders = implode(',', array_fill(0, count($idsParaAtualizar), '?'));
        $pdo->prepare("UPDATE acoespersonagens SET vz = 1 WHERE id IN ($placeholders)")->execute($idsParaAtualizar);
    }

    // --- LOGICA DE CLÃS E ORDENS ---
    $texto_og = "Nenhuma ordem geral ativa.";
    $info_og_display = ""; 
    $texto_om = "Nenhuma instrução momentânea.";
    $info_om_display = "";
    
    $mapa_cargos = [
        1 => 'Guardião da Vanguarda', 2 => 'Capitão do Mato', 3 => 'Capitão da Vanguarda',
        4 => 'Comandante da Guarda Real', 5 => 'Subcomandante', 6 => 'Comandante Oficial', 7 => '1º Ministro'
    ];
    $cargo_nome = $mapa_cargos[$cargo_id] ?? 'Recruta';

    if (!empty($cla) && $cla !== 'Nenhum') {
        try {
            $stmtId = $pdo->prepare("SELECT id FROM cla WHERE nome = :nome LIMIT 1");
            $stmtId->execute([':nome' => $cla]);
            $claData = $stmtId->fetch(PDO::FETCH_ASSOC);

            if ($claData) {
                $cid = $claData['id'];
                
                // Ordem Geral
                $stmtOG = $pdo->prepare("SELECT ordem, data, cargo, redator FROM cla_ordens WHERE cla_id = :cid AND tipo = 'G' ORDER BY data DESC LIMIT 1");
                $stmtOG->execute([':cid' => $cid]);
                $resOG = $stmtOG->fetch(PDO::FETCH_ASSOC);
                if ($resOG) {
                    $texto_og = $resOG['ordem'];
                    $c_og = $resOG['cargo'] ?? 1;
                    $n_og = $mapa_cargos[$c_og] ?? 'Membro';
                    $r_og = $resOG['redator'] ?? 'Anônimo';
                    $info_og_display = "<strong>Por: $r_og <span style='font-size:0.7rem'>($n_og)</span></strong><br><span style='font-size:0.7rem'>Em: " . date('d/m H:i', strtotime($resOG['data'])) . "</span>";
                }

                // Ordem Momentânea
                $stmtOM = $pdo->prepare("SELECT ordem, data, cargo, redator FROM cla_ordens WHERE cla_id = :cid AND tipo = 'M' ORDER BY data DESC LIMIT 1");
                $stmtOM->execute([':cid' => $cid]);
                $resOM = $stmtOM->fetch(PDO::FETCH_ASSOC);
                if ($resOM) {
                    $texto_om = $resOM['ordem'];
                    $c_om = $resOM['cargo'] ?? 1;
                    $n_om = $mapa_cargos[$c_om] ?? 'Membro';
                    $r_om = $resOM['redator'] ?? 'Anônimo';
                    $info_om_display = "<strong>Por: $r_om <span style='font-size:0.7rem'>($n_om)</span></strong><br><span style='font-size:0.7rem'>Em: " . date('d/m H:i', strtotime($resOM['data'])) . "</span>";
                }
            }
        } catch (Exception $e) { /* Silêncio */ }
    }
}

// --- FUNÇÃO PARA COR DA BARRA ---
function getBarColor($val) {
    if ($val > 70) return '#28a745'; // Verde
    if ($val > 40) return '#ffd700'; // Amarelo
    if ($val > 20) return '#fd7e14'; // Laranja
    if ($val > 10) return '#dc3545'; // Vermelho
    return '#000000'; // Preto
}

function formatarTermino($data) {
    if (empty($data) || strtotime($data) === false || strtotime($data) < time()) { return "Concluído"; }
    return date('d/m/Y H:i', strtotime($data));
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RPG ERA MEDIEVAL: Dervian</title>
    <link rel="stylesheet" href="css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .status-bar-container {
            width: 100%; height: 12px; background: rgba(0, 0, 0, 0.5); border-radius: 8px; overflow: hidden;
            border: 1px solid #444; position: relative;
        }
        .status-bar-fill {
            height: 100%; transition: width 0.5s;
        }
        .status-bar-text {
            position: absolute; width: 100%; text-align: center; top: -1px; color: white; 
            font-size: 0.65rem; font-weight: bold; text-shadow: 1px 1px 2px #000; line-height: 12px;
        }
        
        /* --- ITENS DO MAPA (Bandeiras e Efeitos) --- */
.map-flag {
    position: absolute;
    top: 3px;
    left: 3px;
    width: 50%;  /* Tamanho discreto */
    height: 40%;
    z-index: 10;
    border: 1px solid #000;
    box-shadow: 0 0 5px rgba(0,0,0,0.8);
    background-color: rgba(0,0,0,0.5); /* Fundo caso a imagem falhe */
    border-radius: 3px;
    object-fit: cover;
}

.map-invasion {
    position: absolute;
    top: 2px;
    right: 3px;
    width: 35%;
    height: 45%;
    z-index: 11;
    filter: drop-shadow(0 0 5px #ff4400);
    animation: burnPulse 1s infinite alternate;
}

@keyframes burnPulse {
    from { transform: scale(1); opacity: 0.8; }
    to { transform: scale(1.1); opacity: 1; }
}
    </style>
</head>
<body>
    <div class="light-rays"></div>

    <div class="container">
        
        <header class="header-game">
             <h1 style="color: var(--primary); font-family: 'Times New Roman', serif; text-transform: uppercase; letter-spacing: 2px; text-shadow: var(--text-neon-glow); font-size: 2rem; text-align: center; margin-bottom: 10px;">
                RPG ERA MEDIEVAL: Ferro & Fogo
             </h1>
             
             <div class="btn-group navigation">
                <a href="dashboard.php"><button style="width: auto;">Menu Principal</button></a>
                <a href="pagina_notificacoesjogo.php"><button style="width: auto;">Notificações <?= ($total_notificacoes >= 1) ? '<span class="notification-badge">'.$total_notificacoes.'</span>' : '' ?></button></a>
                <button onclick="confirmarSaida()" class="btn-danger" style="width: auto;">Sair</button>
            </div>
            <hr style="margin-top: 15px;">
        </header>

        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-msg-box">
                <?= htmlspecialchars($_SESSION['msg']) ?>
            </div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <main class="game-grid">
            
            <section class="game-panel">
                <h2 class="panel-title">Seu Personagem</h2>
                
                <?php if ($personagemAtivo): ?>
                    <div class="character-info">
                        
                        <div class="info-card">
                            <h3>Informações</h3>
                            <p><strong>Nome:</strong> <span><?= $row['personagem']; ?></span></p>
                            <p><strong>Reputação:</strong> <span><?= $row['reputacao']; ?></span></p>
                            <p><strong>Situação:</strong> <span class="<?= ($situacao == "livre" || $situacao == '') ? 'status-free' : 'status-busy'; ?>"><?= $row['situacao']; ?></span></p>
                            
                            <p><strong>Local:</strong> <span><?= htmlspecialchars($nomelocal); ?></span></p>
                            <p><strong>Domínio:</strong> <span style="color: #ffd700;"><?= htmlspecialchars($dominio_local); ?></span></p>
                            <p><strong>Governante:</strong> <span><?= htmlspecialchars($governante_local); ?></span></p>

                            <?php if ($situacao != "livre" && $situacao != ''): ?>
                                <p><strong>Término:</strong> <span><?= formatarTermino($paralisado); ?></span></p>
                            <?php endif; ?>

                            <div>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 2px;">
                                    <span style="font-size: 0.9rem; font-weight: bold; color: #ccc;">Sede:</span>
                                </div>
                                <div class="status-bar-container">
                                    <div class="status-bar-fill" style="width: <?= $sede ?>%; background: <?= getBarColor($sede) ?>;"></div>
                                    <span class="status-bar-text"><?= $sede ?>%</span>
                                </div>   
                            </div>
                            
                            <?php if ($is_litoral): ?>
                                <form action="personagem/acoes/beberagua.php" method="POST">
                                    <button type="submit" name="treinar">Beber Água</button>
                                </form>
                            <?php endif; ?>
                            
                            <div style="margin-top: 12px; border-top: 1px dashed rgba(255,255,255,0.2); padding-top: 10px;">
                                <div style="margin-bottom: 8px;">
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 2px;">
                                        <span style="font-size: 0.9rem; font-weight: bold; color: #ccc;">Fome:</span>
                                    </div>
                                    <div class="status-bar-container">
                                        <div class="status-bar-fill" style="width: <?= $fome ?>%; background: <?= getBarColor($fome) ?>;"></div>
                                        <span class="status-bar-text"><?= $fome ?>%</span>
                                    </div>
                                </div>
                                
                                <?php if ($carne > 0): ?>
                                    <form action="personagem/acoes/alimentar.php" method="POST">
                                        <button type="submit" name="treinar">Alimentar-se</button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="info-card">
                            <h3>Recursos</h3>
                            <ul class="resource-list">
                                <li class="resource-item"><span class="resource-name">Prata:</span> <span class="resource-value"><?= $row['prata']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Ouro:</span> <span class="resource-value"><?= $row['ouro']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Carne:</span> <span class="resource-value"><?= $row['carne']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Madeira:</span> <span class="resource-value"><?= $row['madeira']; ?></span></li>
                            </ul>
                        </div>
                        
                        <div class="info-card">
                            <h3>Militar</h3>
                            <ul class="resource-list">
                                <li class="resource-item"><span class="resource-name">Soldados:</span> <span class="resource-value"><?= $row['soldados']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Ataque:</span> <span class="resource-value"><?= $row['atk']; ?></span></li>
                                <li class="resource-item"><span class="resource-name">Defesa:</span> <span class="resource-value"><?= $row['def']; ?></span></li>
                            </ul>
                        </div>

                        <div class="info-card">
                            <h3>Histórico</h3>
                            <div class="actions-list">
                                <?php if (!empty($messages)): ?>
                                    <?php foreach ($messages as $message): ?>
                                        <div class="action-item">
                                            <span class="action-description">
                                                <?= !empty($message['acao']) ? htmlspecialchars($message['acao']) : "Ação registrada" ?>
                                            </span>
                                            <div class="action-time">
                                                <?= date('d/m H:i', strtotime($message['dataehora'])) ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="action-item"><span class="action-description">Nenhuma ação recente.</span></div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if (!empty($cla) && $cla !== 'Nenhum'): ?>
                            <div class="info-card" style="border-left-color: #ffd700;">
                                <h3 style="color: #ffd700;">Sistema de Clãs</h3>
                                
                                <p><strong>Clã:</strong> <span style="color: var(--neon-bright);"><?= htmlspecialchars($cla) ?></span></p>
                                <p style="margin-bottom: 10px;">
                                    <strong>Cargo:</strong> 
                                    <span style="color: #ffd700;"><?= $cargo_id ?> - <?= htmlspecialchars($cargo_nome) ?></span>
                                </p>

                                <div class="cla-order-box">
                                    <p class="order-type-title"><i class="fas fa-scroll"></i> Ordem Geral</p>
                                    <div class="order-content">
                                        <p class="order-text">"<?= nl2br(htmlspecialchars($texto_og)) ?>"</p>
                                        <?php if ($info_og_display): ?>
                                            <div style="text-align: right; color: #888; font-size: 0.8rem; margin-top: 5px;">
                                                <?= $info_og_display ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="cla-order-box" style="margin-top: 10px;">
                                    <p class="order-type-title" style="color: #00ff44;"><i class="fas fa-feather-alt"></i> Instrução Momentânea</p>
                                    <div class="order-content">
                                        <p class="order-text">"<?= nl2br(htmlspecialchars($texto_om)) ?>"</p>
                                        <?php if ($info_om_display): ?>
                                            <div style="text-align: right; color: #00ff44; font-size: 0.8rem; margin-top: 5px;">
                                                <?= $info_om_display ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <hr style="border-color: #333; margin: 15px 0;">

                                <div class="cla-commands">
                                    <?php if ($cargo_id >= 3): ?>
                                        <a href="cla/acoes/ordens_cla.php" style="text-decoration: none; display: contents;">
                                            <button type="button" class="action-btn-neon btn-command" style="border-color: #ffaa00; color: #ffaa00;">
                                                <i class="fas fa-bullhorn"></i> Ordens
                                            </button>
                                        </a>
                                    <?php endif; ?>
                                    
                                    <?php if ($cargo_id >= 4): ?>
                                        <a href="cla/acoes/admmembros_cla.php" style="text-decoration: none; display: contents;">
                                            <button type="button" class="action-btn-neon btn-command" style="border-color: #00ffff; color: #00ffff;">
                                                <i class="fas fa-user-plus"></i> Recrutar
                                            </button>
                                        </a>
                                    <?php endif; ?>
                                    
                                    <?php if ($cargo_id >= 5): ?>
                                        <a href="cla/acoes/admcargos_cla.php" style="text-decoration: none; display: contents;">
                                            <button type="button" class="action-btn-neon btn-command" style="border-color: var(--danger-color); color: var(--danger-color);">
                                                <i class="fas fa-users-cog"></i> Cargos
                                            </button>
                                        </a>
                                    <?php endif; ?>

                                    <?php if ($cargo_id < 7): ?>
                                        <a href="cla/acoes/sair_cla.php" style="text-decoration: none; display: contents;">
                                            <button type="button" class="action-btn-neon btn-command" style="border-color: #fff; color: #fff; font-size: 0.8rem;">
                                                <i class="fas fa-sign-out-alt"></i> Sair
                                            </button>
                                        </a>
                                    <?php endif; ?>

                                    <a href="cla/acoes/lista_membros_cla.php" style="text-decoration: none; display: contents;">
                                        <button type="button" class="action-btn-neon btn-command" style="border-color: #ffd700; color: #ffd700;">
                                            <i class="fas fa-list"></i> Membros
                                        </button>
                                    </a>
                                </div>
                            </div>

                        <?php else: ?>
                            <div class="info-card" style="text-align: center; border-left-color: #ffd700;">
                                <h3 style="color: #ffd700;">Clã</h3>
                                <p style="color: #aaa; margin-bottom: 15px;">Você não tem clã.</p>
                                <a href="clas.php" style="text-decoration: none;">
                                    <button type="button" class="btn-full-width-neon" style="border-color: #ffd700; color: #ffd700;">
                                        <i class="fas fa-shield-alt"></i> Ver Clãs
                                    </button>
                                </a>
                                <a href="cla/meus_convites.php" style="text-decoration: none;">
                                    <button type="button" class="btn-full-width-neon" style="border-color: #00ff44; color: #00ff44; margin-top: 10px;">
                                        <i class="fas fa-envelope"></i> Convites
                                    </button>
                                </a>
                            </div>
                        <?php endif; ?>

                    <?php else: ?>
                        <?php header("Location:admpersonagens/ativarpersonagens.php"); exit(); ?>
                    <?php endif; ?>
                </div>
            </section>
            
           <section class="map-panel">
                <h2 class="panel-title">Mapa de Dervian</h2>
                <div class="map-container">
                    <?php
                    // 1. CARREGAR LISTA DE LOCAIS SOB ATAQUE (Para performance)
                    // Busca locais onde dominou = 0 e iniciou há menos de 7 minutos
                    $locais_invadidos = [];
                    try {
                        $sqlInv = "SELECT local FROM guerra_dominio 
                                   WHERE dominou = 0 
                                   AND (defensor IS NULL OR defensor = '') 
                                   AND iniciou > DATE_SUB(NOW(), INTERVAL 7 MINUTE)";
                        $stmtInv = $pdo->query($sqlInv);
                        $locais_invadidos = $stmtInv->fetchAll(PDO::FETCH_COLUMN); // Cria um array simples: ['Cidade A', 'Cidade B']
                    } catch (Exception $e) {}

                    // 2. CARREGAR O MAPA
                    // Adicionei a coluna 'dominio' na busca
                    $local_atual = $local ?? ''; 
                    $sqlMap = "SELECT nome, tipo, dominio FROM mapasmed LIMIT 36";
                    $stmtMap = $pdo->query($sqlMap);
                    
                    while ($row_map = $stmtMap->fetch(PDO::FETCH_ASSOC)) {
                        $nome = $row_map["nome"];
                        $tipo = $row_map["tipo"]; 
                        $dominio_mapa = $row_map["dominio"];

                        $isCurrent = ($nome == $local_atual);
                        $isInvaded = in_array($nome, $locais_invadidos); // Verifica se está na lista de guerra
                        
                        $img_src = "fts/mapa/terreno/" . $tipo . ".png"; 

                        echo '<div class="map-square" onclick="showLocationDescription(\''.$nome.'\')">';
                        
                        // Fundo do Terreno
                        echo '<img src="'.$img_src.'" alt="'.$nome.'" class="map-bg-img">';
                        
                        // --- BANDEIRA DO CLÃ (Canto Superior Esquerdo) ---
                        if (!empty($dominio_mapa) && $dominio_mapa !== 'Nenhum') {
                            // Assume que a imagem tem o mesmo nome do clã e extensão .png
                            // Dica: Garanta que os arquivos não tenham caracteres especiais ou trate isso no upload
                            $bandeira_src = "cla/fts/bandeiras/" . $dominio_mapa . ".png";
                            
                            // Adicionamos onerror para caso a imagem não exista, não mostrar ícone quebrado
                            echo '<img src="'.$bandeira_src.'" class="map-flag" title="Dominado por: '.$dominio_mapa.'" onerror="this.style.display=\'none\'">';
                        }

                        // --- SÍMBOLO DE FOGO/INVASÃO (Canto Superior Direito) ---
                        if ($isInvaded) {
                            // Você pode baixar um gif de fogo e colocar na pasta img, ou usar um ícone FontAwesome
                            // Opção 1: Imagem GIF (Mais bonito)
                            echo '<img src="fts/mapa/icones/fire.png" class="map-invasion" title="SOB ATAQUE!">';
                            
                            // Opção 2: Ícone (Se preferir)
                            // echo '<i class="fas fa-fire map-invasion" style="color:orange; font-size:20px;"></i>';
                        }

                        // Nome do Local
                        echo '<p class="map-name">'.$nome.'</p>';
                        
                        // Marcador do Personagem (Você)
                        if ($isCurrent) {
                            echo '<img src="personagem.png" class="map-personagem-marker" alt="Você">'; 
                        }
                        echo '</div>';
                    }
                    ?>
                </div>
                
                
                
                
                
                
                
                
                
                
                <div class="logs-grid-container">
                    
                    <div class="log-window">
                        <h4 class="log-title" style="color: #ffd700;">
                            <i class="fas fa-shield-alt"></i> Clã
                        </h4>
                        <div id="feed-cla" class="log-scroll">
                            <?php if(empty($cla) || $cla == 'Nenhum'): ?>
                                <div class="log-item-empty">Você não possui clã.</div>
                            <?php else: ?>
                                <div class="log-item-loading"><i class="fas fa-spinner fa-spin"></i> Carregando...</div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="log-window">
                        <h4 class="log-title" style="color: #00ffff;">
                            <i class="fas fa-map-marker-alt"></i> Local
                        </h4>
                        <div id="feed-local" class="log-scroll">
                            <div class="log-item-loading"><i class="fas fa-spinner fa-spin"></i> Carregando...</div>
                        </div>
                    </div>

                    <div class="log-window">
                        <h4 class="log-title" style="color: #ff4444;">
                            <i class="fas fa-globe"></i> Global
                        </h4>
                        <div id="feed-geral" class="log-scroll">
                            <div class="log-item-loading"><i class="fas fa-spinner fa-spin"></i> Carregando...</div>
                        </div>
                    </div>

                </div>

                <style>
                    /* CSS Específico das Janelas de Ocorrência */
                    .logs-grid-container {
                        display: grid;
                        grid-template-columns: 1fr 1fr 1fr;
                        gap: 10px;
                        margin-top: 15px;
                        border-top: 1px solid var(--primary);
                        padding-top: 15px;
                    }
                    
                    .log-window {
                        background: rgba(0, 0, 0, 0.6);
                        border: 1px solid var(--primary);
                        border-radius: 6px;
                        overflow: hidden;
                        display: flex;
                        flex-direction: column;
                        height: 180px; /* Altura fixa para alinhar */
                    }

                    .log-title {
                        background: rgba(0, 0, 255, 0.1);
                        padding: 5px;
                        text-align: center;
                        font-size: 0.8rem;
                        text-transform: uppercase;
                        border-bottom: 1px solid rgba(255,255,255,0.1);
                        margin: 0;
                        text-shadow: 0 0 5px currentColor;
                    }

                    .log-scroll {
                        flex-grow: 1;
                        overflow-y: auto;
                        padding: 5px;
                        font-size: 0.75rem;
                        scrollbar-width: thin;
                        scrollbar-color: var(--primary) #000;
                    }
                    /* Scrollbar bonitinha */
                    .log-scroll::-webkit-scrollbar { width: 5px; }
                    .log-scroll::-webkit-scrollbar-thumb { background: var(--primary); border-radius: 3px; }
                    .log-scroll::-webkit-scrollbar-track { background: #000; }

                    .log-item {
                        padding: 5px;
                        border-bottom: 1px dashed rgba(255,255,255,0.1);
                        color: #ccc;
                        line-height: 1.3;
                    }
                    .log-item:last-child { border-bottom: none; }
                    
                    .log-time { color: #666; font-size: 0.65rem; float: right; margin-left: 5px; }
                    .log-highlight { color: #fff; font-weight: bold; }
                    .log-item-empty { text-align: center; color: #555; padding-top: 20px; font-style: italic; }
                    .log-item-loading { text-align: center; color: var(--primary); padding-top: 20px; }

                    @media (max-width: 768px) {
                        .logs-grid-container { grid-template-columns: 1fr; } /* Em celular fica um embaixo do outro */
                        .log-window { height: 120px; }
                    }
                </style>

                <script>
                    // Script para atualizar os feeds em tempo real
                    (function() {
                        const feedCla = document.getElementById('feed-cla');
                        const feedLocal = document.getElementById('feed-local');
                        const feedGeral = document.getElementById('feed-geral');
                        
                        // Dados do PHP
                        const dadosRequest = new FormData();
                        dadosRequest.append('cla', '<?php echo $cla ?? ""; ?>');
                        dadosRequest.append('local', '<?php echo $local ?? ""; ?>');

                        function atualizarFeeds() {
                            fetch('jogo/api_ocorrencias.php', { method: 'POST', body: dadosRequest })
                            .then(r => r.json())
                            .then(data => {
                                renderizarLista(feedCla, data.cla, 'Nenhuma ocorrência no clã.');
                                renderizarLista(feedLocal, data.local, 'Tudo calmo por aqui.');
                                renderizarLista(feedGeral, data.geral, 'Sem notícias globais.');
                            })
                            .catch(e => console.log('Erro feed:', e));
                        }

                        function renderizarLista(elemento, lista, msgVazia) {
                            if (!elemento) return; // Se usuário não tem clã, elemento pode não existir ou ser estático
                            
                            if (lista.length === 0) {
                                // Só mostra msg vazia se não tiver conteúdo anterior ou se já passou o loading
                                if(elemento.innerHTML.includes('Carregando')) elemento.innerHTML = `<div class="log-item-empty">${msgVazia}</div>`;
                                return;
                            }

                            let html = '';
                            lista.forEach(item => {
                                // Formata hora (pega só HH:MM)
                                let hora = item.data.substring(11, 16);
                                html += `
                                    <div class="log-item">
                                        <span class="log-time">${hora}</span>
                                        ${item.situacao}
                                    </div>
                                `;
                            });
                            
                            // Só atualiza o DOM se mudou algo para evitar piscar o scroll
                            if (elemento.innerHTML !== html) {
                                elemento.innerHTML = html;
                            }
                        }

                        // Inicia e repete a cada 4 segundos
                        atualizarFeeds();
                        setInterval(atualizarFeeds, 4000);
                    })();
                </script>
                ```


            </section>
            
            <section class="actions-panel">
                
                <div class="action-section" style="border-left-color: var(--neon-bright);">
                    <h3 class="panel-title" style="text-align: left; font-size: 1.2rem;">Movimentação</h3>
                    
                    <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                        
                        <?php if (!empty($cla) && $cla !== 'Nenhum' && isset($tipolocal) && $tipolocal == 'city' && $cla == $dominio_local): ?>
                            <div style="padding: 10px; background: rgba(255, 215, 0, 0.05); border: 1px dashed #ffd700; border-radius: 5px; text-align: center; margin-bottom: 15px;">
                                <p style="color: #ffd700; font-size: 0.9rem; margin-bottom: 5px;">
                                    <i class="fas fa-shield-alt"></i> Território Seguro
                                </p>
                                <p style="color: #ddd; font-size: 0.8rem;">
                                    Base do clã <strong><?= htmlspecialchars($cla) ?></strong>.
                                </p>
                            </div>
                        <?php endif; ?>

                        <?php 
                        $locais_invasiveis = ['city', 'castle', 'fort']; 
                        if (isset($tipolocal) && in_array($tipolocal, $locais_invasiveis)): 
                        ?>
                            <div style="margin-bottom: 15px;">
                            <button type="button" class="btn-full-width-neon" onclick="abrirModalPersonagens()">
                                <i class="fas fa-users"></i> Quem está no local
                            </button><br><br>
                            
                                
                                                           
                        <?php endif; ?>

 <?php if (isset($cla) && ($cla != $dominio_local)): ?>

<form action="admcity/dominar.php" method="POST" onsubmit="return confirm('ATENÇÃO: Iniciar o domínio de <?= htmlspecialchars($local); ?> consumirá 5 minutos do seu tempo e é uma ação de alto risco. Confirmar invasão?');">
                                    <input type="hidden" name="local_alvo" value="<?= htmlspecialchars($local); ?>">
                                    <button type="submit" class="action-btn-neon btn-danger-neon" style="width: 100%; font-size: 0.8rem;">
                                        <i class="fas fa-hammer"></i> Invadir cidade
                                    </button>
                                </form>
                            </div>
 <?php endif; ?>
 <?php if (isset($cla) && ($governante_local == $personagem)): ?>
 <button type="button" class="btn-full-width-neon"">
                                        <i class="fas fa-hammer"></i> Cobrar impostos
                                    </button>
                                </form>
<br><br>


 <?php endif; ?>

                        <form action="personagem/acoes/moverperson.php" method="post" class="movimentacao-form-grid">
                            <input type="hidden" name="mover" value="1">
                            <?php if ($show_o): ?><button type="submit" name="direcao" value="<?= $oeste_id ?>" class="btn" onclick="return confirm('Mover para Oeste?')"><i class="fas fa-arrow-left"></i></button><?php endif; ?>
                            <?php if ($show_n): ?><button type="submit" name="direcao" value="<?= $norte_id ?>" class="btn" onclick="return confirm('Mover para Norte?')"><i class="fas fa-arrow-up"></i></button><?php endif; ?>
                            <?php if ($show_s): ?><button type="submit" name="direcao" value="<?= $sul_id ?>" class="btn" onclick="return confirm('Mover para Sul?')"><i class="fas fa-arrow-down"></i></button><?php endif; ?>
                            <?php if ($show_l): ?><button type="submit" name="direcao" value="<?= $leste_id ?>" class="btn" onclick="return confirm('Mover para Leste?')"><i class="fas fa-arrow-right"></i></button><?php endif; ?>
                        </form>
                        
                        <?php if (isset($tipolocal) && $tipolocal != "city"): ?>
                            <button type="button" class="btn-full-width-neon" onclick="abrirModalPersonagens()">
                                <i class="fas fa-users"></i> Quem está no local
                            </button><br>
                        <?php endif; ?>
                        
                    <?php else: ?>
                        <div style="text-align: center; padding: 10px;">
                            <p style="font-size: 0.9rem; color: #aaa; margin-bottom: 5px;">STATUS ATUAL</p>
                            <h3 style="color: var(--neon-bright); text-transform: uppercase; margin-bottom: 10px; text-shadow: var(--text-neon-glow);">
                                <?php echo $situacao; ?>
                            </h3>
                            
                            <div style="color: #ccc; font-size: 0.9rem; margin-bottom: 15px; font-style: italic; min-height: 40px;">
                                <?php 
                                if ($situacao == "trabalhando") {echo "Seus homens estão trabalhando duro na cidade.";}
                                elseif ($situacao == "caçando") {echo "Rastreando presas na mata densa.";}
                                elseif ($situacao == "pegando madeira") {echo "Derrubando árvores para o estoque.";}
                                elseif ($situacao == "treinandoATK") {echo "Treinamento intensivo de combate.";}
                                elseif ($situacao == "treinandoDEF") {echo "Treinamento de táticas defensivas.";}
                                elseif ($situacao == "escondido") {echo "Escondidos e aguardando o perigo passar.";}
                                elseif ($situacao == "Invadindo cidade") {
    echo "Liderando o cerco para dominar o território!";
    
    // Note que usei aspas SIMPLES (') no começo e no fim do echo
    echo '<div style="margin-top: 15px;">
               <button type="button" class="btn-full-width-neon" onclick="abrirModalPersonagens()">
                                <i class="fas fa-users"></i> Quem está no perímetro
                            </button><br>
          </div>';
}
                                elseif ($situacao == "pescando") {echo "Pescando recursos no litoral.";}
                                elseif ($situacao == "bebendoagua") {echo "Hidratando as tropas.";}
                                elseif ($situacao == "alimentando") {echo "Refeição e descanso.";}
                                else { echo "Realizando atividade..."; }
                                ?>
                            </div>

                            <?php
                            $agora = time();
                            $fim = strtotime($paralisado);
                            $segundos_restantes = $fim - $agora;

                            $action = ''; $buttonText = '';
                            if ($situacao == "trabalhando") { $action = "personagem/acoes/pegarpg.php"; $buttonText = "$ Receber Pagamento $"; }
                            elseif ($situacao == "caçando") { $action = "personagem/acoes/finalisarcaca.php"; $buttonText = "♣⚔ Recolher Caça ⚔♣"; }
                            elseif ($situacao == "pegando madeira") { $action = "personagem/acoes/finalisarlenha.php"; $buttonText = "♣ Recolher Madeira ♣"; }
                            elseif ($situacao == "treinandoATK") { $action = "personagem/acoes/finalisartreinoatk.php"; $buttonText = "♣⚔️ Concluir Treino ⚔♣"; }
                            elseif ($situacao == "treinandoDEF") { $action = "personagem/acoes/finalisartreinodef.php"; $buttonText = "♣⚔ Concluir Treino ⚔♣"; }
                            elseif ($situacao == "Invadindo cidade") { $action = "admcity/finalizar_dominio.php"; $buttonText = "⚔ Concluir Invasão ⚔"; }
                            elseif ($situacao == "pescando") { $action = "personagem/acoes/finalisarpesca.php"; $buttonText = "♠️ Recolher Rede ♠️"; }
                            elseif ($situacao == "bebendoagua") { $action = "personagem/acoes/finalisarbeberagua.php"; $buttonText = "♣  Voltar à Ativa ♣"; }
                            elseif ($situacao == "alimentando") { $action = "personagem/acoes/alimentar_finalizar.php"; $buttonText = "♠️ Voltar à Ativa ♠️"; }
elseif ($situacao == "fugindo e reagrupando soldados") { $action = "personagem/acoes/aparecer.php"; $buttonText = "♣ Aparecer ♣"; }

elseif ($situacao == "reagrupando soldados") { $action = "personagem/acoes/aparecer.php"; $buttonText = "♣ Aparecer ♣"; }
elseif ($situacao == "escondido") { $action = "personagem/acoes/aparecer.php"; $buttonText = "♣ Aparecer ♣"; }
                            $displayTimer = ($segundos_restantes > 0) ? 'block' : 'none';
                            $displayBtn   = ($segundos_restantes <= 0) ? 'block' : 'none';
                            ?>

                            <div id="box-cronometro" style="display: <?= $displayTimer ?>;">
                                <div class="timer-neon-box">
                                    <p style="font-size: 0.7rem; color: var(--primary); text-transform: uppercase; margin-bottom: 5px;">Tempo Restante</p>
                                    <div id="timer-display" class="timer-digits">--:--:--</div>
                                </div>
                            </div>

                            <div id="box-botao-acao" style="display: <?= $displayBtn ?>; margin-top: 15px;">
                                <?php if ($action && $buttonText): ?>
                                    <p style="color: #00ff44; margin-bottom: 8px; font-size: 0.9rem; text-transform: uppercase;">Ação Concluída</p>
                                    <form action="<?= $action ?>" method="POST" class="action-form">
                                        <input type="hidden" name="local" value="treino">
                                        <button type="submit" class="btn-finish-neon" name="treinar">
                                            <?= $buttonText ?>
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <p style="color: #555;">Aguardando sistema...</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <script>
                        (function() {
                            var timeLeft = <?php echo max(0, $segundos_restantes); ?>;
                            var display = document.getElementById('timer-display');
                            var boxTimer = document.getElementById('box-cronometro');
                            var boxBtn = document.getElementById('box-botao-acao');

                            function updateTimer() {
                                if (timeLeft <= 0) {
                                    if(boxTimer) boxTimer.style.display = 'none';
                                    if(boxBtn) boxBtn.style.display = 'block';
                                    clearInterval(intervalo);
                                    return;
                                }
                                var h = Math.floor(timeLeft / 3600);
                                var m = Math.floor((timeLeft % 3600) / 60);
                                var s = timeLeft % 60;
                                h = h < 10 ? '0' + h : h;
                                m = m < 10 ? '0' + m : m;
                                s = s < 10 ? '0' + s : s;
                                if(display) display.textContent = h + ":" + m + ":" + s;
                                timeLeft--;
                            }
                            updateTimer();
                            var intervalo = setInterval(updateTimer, 1000);
                        })();
                        </script>
                    <?php endif; ?>
                    
                    <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                        <?php if (isset($tipolocal) && $tipolocal == "city"): ?>
                            <div class="action-section" style="border-left-color: var(--success-color);">
                                <h3 style="color: var(--primary); font-size: 1.1rem;">Cidade</h3>
                                <form action="trabalhar.php" method="POST" class="action-form">
                                    <button type="submit" class="action-btn-neon" name="trabalhar" onclick="return confirm('Trabalhar?')"><i class="fas fa-hammer"></i> Trabalhar</button>
                                </form>
                                <h4 style="color:#ccc; margin-top:15px;">Contratar (80$)</h4>
                                <form action="personagem/acoes/contratar.php" method="POST" class="action-form">
                                    <input type="number" name="quantidade" min="1" placeholder="Qtd" class="action-input-neon">
                                    <button type="submit" class="action-btn-neon" name="contratar">Contratar</button>
                                </form>
                                <?php if ($soldados >= 1): ?>
                                    <h4 style="color:#ccc; margin-top:15px;">Dispensar</h4>
                                    <form action="personagem/acoes/dispensarsoldados.php" method="POST" class="action-form">
                                        <input type="number" name="quantidade" min="1" max="<?= $soldados ?>" placeholder="Qtd" class="action-input-neon">
                                        <button type="submit" class="action-btn-neon btn-danger-neon" name="dispensar">Dispensar</button>
                                    </form>
                                <?php endif; ?>
                                <?php if ($carne >= 1): ?>
                                    <h4 style="color:#ccc; margin-top:15px;">Vender Carne (<?= $precocarne ?>$)</h4>
                                    <form action="personagem/acoes/vendercarne.php" method="POST" class="action-form">
                                        <input type="number" name="quantidade" min="1" max="<?= $carne ?>" placeholder="Qtd" class="action-input-neon">
                                        <button type="submit" class="action-btn-neon btn-warning-neon" name="vendercarne">Vender</button>
                                    </form>
                                <?php endif; ?>
                                <?php if ($madeira >= 1): ?>
                                    <h4 style="color:#ccc; margin-top:15px;">Vender Madeira (<?= $precomadeira ?>$)</h4>
                                    <form action="personagem/acoes/vendermadeira.php" method="POST" class="action-form">
                                        <input type="number" name="quantidade" min="1" max="<?= $madeira ?>" placeholder="Qtd" class="action-input-neon">
                                        <button type="submit" class="action-btn-neon btn-warning-neon" name="vendermadeira">Vender</button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($tipolocal) && ($tipolocal == "campo" || $tipolocal == "mata")): ?>
                            <div class="action-section" style="border-left-color: var(--primary);">
                                <h3 style="color: var(--primary); font-size: 1.1rem;"><center>Exploração</center></h3>
                                <?php if ($tipolocal == "campo"): ?>
                                    <form action="treinaratk.php" method="POST" class="action-form"><button type="submit" class="action-btn-neon" name="treinar"><i class="fas fa-fist-raised"></i> Treinar Ataque</button></form>
                                    <form action="treinardef.php" method="POST" class="action-form"><button type="submit" class="action-btn-neon" name="treinar"><i class="fas fa-shield-alt"></i> Treinar Defesa</button></form>
                                <?php endif; ?>
                                <?php if ($tipolocal == "mata"): ?>
                                    <form action="personagem/acoes/caca.php" method="POST" class="action-form"><button type="submit" class="action-btn-neon" name="caca"><i class="fas fa-paw"></i> Caçar</button></form>
                                    <form action="personagem/acoes/lenhar.php" method="POST" class="action-form"><button type="submit" class="action-btn-neon" name="lenhar"><i class="fas fa-tree"></i> Coletar Madeira</button></form>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                    <br>
                    <?php if ($situacao !== 'escondido' && $situacao !== 'fugindo e reagrupando soldados'): ?>
                        <div class="action-section" style="border-left-color: var(--neon-bright);">
                            <h3 style="color: var(--primary); text-align: left; font-size: 1.1rem; border-bottom: 1px dashed var(--primary);"><center><font color="white">Chat local</font></center></h3>
                            <div class="combat-iframe" style="height: 350px; border: none;">
                                <iframe src="chat_firebase.php" style="width: 100%; height: 100%; border: none;"></iframe>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </section>
        </main>
        
        <center>
        <footer class="footer-simple-medieval" style="margin-top: 30px;">
            <div class="footer-content">
                <h4>⚔️ RPG ERA MEDIEVAL: FERRO & FOGO ⚔️</h4>
                <p>&copy; 2025 Todos os direitos reservados.</p>
            </div>
        </footer></center>
    </div>
    
    <div id="locationModal" class="modal"><div class="modal-content"><span class="close-modal" onclick="closeModal()">&times;</span><h2 id="modalLocationName" style="color: var(--neon-bright);"></h2><p id="modalLocationDescription" style="color: var(--light-text);"></p></div></div>
    <div id="modalPersonagens" class="modal"><div class="modal-content"><span class="close-modal" onclick="fecharModalPersonagens()">&times;</span><h2 style="color: var(--neon-bright);">Personagens</h2><div id="conteudoModal" style="max-height: 400px; overflow-y: auto; margin-top: 15px; color: var(--light-text);"></div></div></div>

<div id="locationModal" class="modal"><div class="modal-content"><span class="close-modal" onclick="closeModal()">&times;</span><h2 id="modalLocationName" style="color: var(--neon-bright);"></h2><p id="modalLocationDescription" style="color: var(--light-text);"></p></div></div>
    <div id="modalPersonagens" class="modal"><div class="modal-content"><span class="close-modal" onclick="fecharModalPersonagens()">&times;</span><h2 style="color: var(--neon-bright);">Personagens</h2><div id="conteudoModal" style="max-height: 400px; overflow-y: auto; margin-top: 15px; color: var(--light-text);"></div></div></div>


   <style>
    /* Estilo do Container de Alertas */
    #toast-container {
        position: fixed !important;
        top: 110px;                 
        right: 20px;                
        z-index: 2147483647 !important; 
        display: flex;
        flex-direction: column;
        gap: 10px;
        pointer-events: none;       
        width: 320px;
    }

    /* Estilo do Alerta */
    .toast-alert {
        background: rgba(0, 0, 0, 0.95); 
        border: 1px solid #fff;
        border-left-width: 6px !important; 
        border-radius: 5px;
        padding: 15px;
        color: #fff;
        box-shadow: 0 5px 25px rgba(0,0,0,1); 
        font-family: 'Segoe UI', sans-serif;
        font-size: 0.95rem;
        backdrop-filter: blur(5px);
        pointer-events: auto; 
        
        /* Animação de Entrada */
        opacity: 0; 
        transform: translateX(100%);
        animation: entradaSuave 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
    }

    /* Botão de Fechar */
    .toast-alert .close-btn {
        cursor: pointer;
        font-weight: bold;
        font-size: 1.5em;
        line-height: 0.5;
        padding-left: 10px;
        opacity: 0.8;
    }
    .toast-alert .close-btn:hover { color: #ff4444; opacity: 1; }

    @keyframes entradaSuave { to { opacity: 1; transform: translateX(0); } }
    @keyframes saidaSuave { to { opacity: 0; transform: translateX(100%); } }



    /* CSS DO TOAST (MANTIDO) */
    #toast-container {
        position: fixed !important; top: 110px; right: 20px; z-index: 2147483647 !important;
        display: flex; flex-direction: column; gap: 10px; pointer-events: none; width: 320px;
    }
    .toast-alert {
        background: rgba(0, 0, 0, 0.95); border: 1px solid #fff; border-left-width: 6px !important;
        border-radius: 5px; padding: 15px; color: #fff; box-shadow: 0 5px 20px rgba(0,0,0,1);
        font-family: 'Segoe UI', sans-serif; font-size: 0.95rem; backdrop-filter: blur(5px);
        pointer-events: auto; opacity: 0; transform: translateX(100%);
        animation: entradaSuave 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275) forwards;
    }
    /* Botão de Fechar */
    .toast-alert .close-btn {
        position: absolute; top: 5px; right: 10px; color: #fff; font-weight: bold; font-size: 1.5em; line-height: 0.5; cursor: pointer; opacity: 0.8; transition: opacity 0.2s;
    }
    .toast-alert .close-btn:hover { color: #ff4444; opacity: 1; }

    @keyframes entradaSuave { to { opacity: 1; transform: translateX(0); } }
    @keyframes saidaSuave { to { opacity: 0; transform: translateX(100%); } }
</style>


<div id="toast-container"></div>

    <script>
        function confirmarSaida() { if (confirm("Tem certeza que deseja sair?")) { window.location.href = "logout.php"; } }
        function abrirModalPersonagens() { const m = document.getElementById('modalPersonagens'); const c = document.getElementById('conteudoModal'); m.style.display = 'block'; c.innerHTML = '<p>Carregando...</p>'; fetch('jogo/quemestanolocal.php', { method: 'POST', headers: { 'Content-Type': 'application/x-www-form-urlencoded' }, body: 'local=' + encodeURIComponent('<?php echo isset($local) ? $local : ''; ?>') }).then(r => r.text()).then(d => { c.innerHTML = d; }); }
        function fecharModalPersonagens() { document.getElementById('modalPersonagens').style.display = 'none'; }
        function showLocationDescription(n) { fetch('?location=' + encodeURIComponent(n)).then(r => r.text()).then(d => { document.getElementById('modalLocationName').textContent = n; document.getElementById('modalLocationDescription').textContent = d; document.getElementById('locationModal').style.display = 'block'; }); }
        function closeModal() { document.getElementById('locationModal').style.display = 'none'; }
        window.onclick = function(e) { if(e.target == document.getElementById('locationModal')) closeModal(); if(e.target == document.getElementById('modalPersonagens')) fecharModalPersonagens(); }
        setTimeout(function(){ location.reload(); }, 30000);
        function recarregarChat() { const i = document.getElementById('chatIframe'); if(i) i.src = i.src; }
        document.addEventListener('DOMContentLoaded', function() { setInterval(recarregarChat, 5000); });
        
        var statusNaTela = "<?php echo isset($situacao) ? $situacao : ''; ?>";
        setInterval(function() {
            fetch('sistema/scripts/verificar_status_situacao_personagem.php')
                .then(response => response.text())
                .then(statusNoBanco => {
                    statusNoBanco = statusNoBanco.trim();
                    if (statusNoBanco !== "" && statusNoBanco !== statusNaTela) {
                        console.log("Mudança detectada! De: " + statusNaTela + " Para: " + statusNoBanco);
                        location.reload();
                    }
                })
                .catch(err => console.error("Erro ao verificar status:", err));
        }, 3000); 
 



// xxxxxxxxxxxxxxxxxxxxx           xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx     // PARTE DAS MOTIFICAÇÕES    

// --- SEÇÃO 2: CONFIGURAÇÃO DE VARIÁVEIS ---
    var situacaoRaw = '<?php echo trim($situacao ?? ""); ?>';
    var situacaoLimpa = situacaoRaw.toLowerCase(); 
    var localAtual = '<?php echo $local ?? ""; ?>';
    var meuCla = '<?php echo trim($cla ?? ""); ?>';
    var claDominante = '<?php echo isset($dominio_local) ? trim($dominio_local) : ""; ?>';
    var nomePersonagem = '<?php echo $nomePersonagem ?? ""; ?>';

    // Caminhos API
    var urlApiRadar = "jogo/api_inimigos_local.php"; 
    var urlApiAtaqueGoverno = "personagem/acoes/check_ataque_governo.php"; 
    
    // Estado
    var personagensConhecidos = [];
    var primeiraExecucaoRadar = true; 
    var primeiraExecucaoLogs = true; 
    var audioPermitido = false;
    var lastClaId = 0, lastLocalId = 0, lastGeralId = 0;
    var intervaloAtaqueGoverno = null, contadorVerificacaoAtaque = 0;
    const MAX_VERIFICACOES = 7; 

    const dadosRequest = new FormData();
    dadosRequest.append('cla', meuCla);
    dadosRequest.append('local', localAtual);
    dadosRequest.append('personagem_nome', nomePersonagem);

    document.addEventListener('click', function() { audioPermitido = true; }, {once:true});

    // --- SEÇÃO 3: FUNÇÕES DE ÁUDIO E VISUAL ---
    function tocarAlarme() {
        var contador = 0;
        var somUrl = 'https://actions.google.com/sounds/v1/alarms/beep_short.ogg'; 
        function play() {
            if (contador >= 3) return;
            try {
                var audio = new Audio(somUrl); audio.volume = 0.5;
                audio.play().then(() => { contador++; setTimeout(play, 600); }).catch(e => {});
            } catch(e) {}
        }
        if (audioPermitido) play();
    }

    function testeVisual() {
        audioPermitido = true;
        criarAlerta("TESTE VISUAL (Corpo)", "TÍTULO DE TESTE", "9999", "#ff0000", "TESTE VISUAL");
    }

    function criarAlerta(corpo, subtitulo, rep, cor, titulo) {
        var container = document.getElementById('toast-container');
        if (!container) { container = document.createElement('div'); container.id = 'toast-container'; document.body.appendChild(container); }
        
        var div = document.createElement('div'); div.className = 'toast-alert';
        div.style.borderLeftColor = cor; div.style.boxShadow = '0 0 15px ' + cor;
        
        var corpoSeg = String(corpo).replace(/</g, "&lt;");
        var subSeg = String(subtitulo).replace(/</g, "&lt;");

        div.innerHTML = `
            <div style="display:flex; justify-content:space-between; align-items:flex-start; margin-bottom:5px; border-bottom:1px solid #444; padding-bottom:5px;">
                <strong style="color:${cor}; text-transform:uppercase; font-size:0.9em;">${titulo}</strong>
                <span class="close-btn">&times;</span>
            </div>
            <div style="font-size:1.1em; font-weight:bold;">${corpoSeg}</div>
            <div style="font-size:0.85em; color:#ccc;">${subSeg}</div>
        `;
        
        container.prepend(div);
        
        div.querySelector('.close-btn').addEventListener('click', function() {
            div.style.animation = 'saidaSuave 0.5s forwards';
            setTimeout(() => { if(container.contains(div)) container.removeChild(div); }, 500);
        });

        tocarAlarme();
        setTimeout(function() { 
            if(container.contains(div)) {
                 div.style.animation = 'saidaSuave 0.5s forwards';
                 setTimeout(() => { if(container.contains(div)) container.removeChild(div); }, 500);
            }
        }, 8000); 
    }

    // --- SEÇÃO 4: LOGS E OCORRÊNCIAS ---
    function monitorarOcorrencias(tipo, novaLista, ultimaId) {
        if (!novaLista || novaLista.length === 0) return ultimaId;
        const novaOcorrenciaMaisRecente = novaLista[0];
        const novaId = parseInt(novaOcorrenciaMaisRecente.id);

        if (primeiraExecucaoLogs) return novaId;

        if (novaId > ultimaId) {
            const item = novaLista[0];
            let cor = '', titulo = '', localTexto = item.local ? item.local : 'Global', tipoTexto = item.tipo ? item.tipo : 'Aviso';
            switch (tipo) {
                case 'cla': cor = '#00FFFF'; titulo = '🚨 CLÃ: ' + tipoTexto.toUpperCase(); break;
                case 'local': cor = '#FFD700'; titulo = '📍 LOCAL: ' + tipoTexto.toUpperCase(); break;
                case 'geral': cor = '#FF00FF'; titulo = '🌎 GLOBAL: ' + tipoTexto.toUpperCase(); break;
            }
            criarAlerta(item.situacao, 'Em: ' + localTexto, '', cor, titulo);
            return novaId;
        }
        return ultimaId;
    }

    function renderizarLista(elemento, lista, msgVazia) {
        if (!elemento) return; 
        if (!lista || lista.length === 0) {
            if(elemento.innerHTML.includes('Carregando')) elemento.innerHTML = `<div class="log-item-empty">${msgVazia}</div>`;
            return;
        }
        let html = '';
        lista.forEach(item => {
            let hora = item.data ? item.data.substring(11, 16) : "00:00";
            html += `<div class="log-item"><span class="log-time">${hora}</span>${item.situacao}</div>`;
        });
        if (elemento.innerHTML !== html) elemento.innerHTML = html;
    }

    function atualizarFeeds() {
        // CORREÇÃO DO ERRO 'feedGeral is not defined': Definir aqui dentro
        const feedCla = document.getElementById('feed-cla');
        const feedLocal = document.getElementById('feed-local');
        const feedGeral = document.getElementById('feed-geral');

        fetch('jogo/api_ocorrencias.php', { method: 'POST', body: dadosRequest })
        .then(r => r.json())
        .then(data => {
            lastClaId = monitorarOcorrencias('cla', data.cla || [], lastClaId);
            lastLocalId = monitorarOcorrencias('local', data.local || [], lastLocalId);
            lastGeralId = monitorarOcorrencias('geral', data.geral || [], lastGeralId);
            primeiraExecucaoLogs = false;
            renderizarLista(feedCla, data.cla || [], 'Nenhuma ocorrência no clã.');
            renderizarLista(feedLocal, data.local || [], 'Tudo calmo por aqui.');
            renderizarLista(feedGeral, data.geral || [], 'Sem notícias globais.');
        }).catch(e => {});
    }

    // --- SEÇÃO 5: RADAR DE PERSONAGENS ---
    function monitorarChegadas() {
        if (!situacaoLimpa.includes("invadindo")) return;
        fetch(urlApiRadar, { method: 'POST', body: dadosRequest }).then(r => r.json()).then(data => {
            var idsAtuais = data.map(p => String(p.id));
            if (!primeiraExecucaoRadar) {
                data.forEach(p => {
                    if (!personagensConhecidos.includes(String(p.id))) {
                        var cor = '#ffff00', titulo = "⚠️ MOVIMENTO", pCla = (p.cla || '').trim();
                        if (meuCla && meuCla !== 'Nenhum' && pCla === meuCla) { cor = '#00ff44'; titulo = "🛡️ REFORÇO"; }
                        else if (claDominante && claDominante !== 'Nenhum' && pCla === claDominante) { cor = '#ff2222'; titulo = "⚔️ DEFENSOR"; }
                        criarAlerta(p.personagem + ' entrou na área.', 'Clã: ' + (p.cla || 'Sem Clã'), p.reputacao, cor, titulo);
                    }
                });
            }
            personagensConhecidos = idsAtuais; primeiraExecucaoRadar = false;
        }).catch(err => {});
    }

    // --- SEÇÃO 6: ALERTA DE GOVERNO ---
    function fecharAlertaAtaque(id) {
        var alerta = document.getElementById(id);
        if (alerta) { alerta.style.animation = 'saidaSuave 0.5s forwards'; setTimeout(() => { alerta.remove(); }, 500); }
    }
    function criarAlertaAtaque(locais) {
        var alertaId = 'alerta-ataque-governador';
        if (document.getElementById(alertaId)) return;
        var titulo = "ALERTA CRÍTICO!"; var subtitulo = "Locais: " + locais.join(', '); var cor = '#ff0000';
        var container = document.getElementById('toast-container'); var alerta = document.createElement('div');
        alerta.id = alertaId; alerta.className = 'toast-alert'; alerta.style.borderLeftColor = cor; alerta.style.boxShadow = '0 0 15px ' + cor;
        alerta.innerHTML = `<div style="display:flex; justify-content:space-between; align-items:flex-start; margin-bottom:5px; border-bottom:1px solid #ff4444; padding-bottom:5px;"><strong style="color:${cor}; text-transform:uppercase;">${titulo}</strong><span class="close-btn" onclick="fecharAlertaAtaque('${alertaId}')">&times;</span></div><div style="font-size:1.1em; font-weight:bold;">DEFENDA SUA CIDADE!</div><div style="font-size:0.85em; color:#ccc;">${subtitulo}</div>`;
        container.prepend(alerta); tocarAlarme();
    }
    function verificarAtaquesGoverno() {
        if (nomePersonagem === 'Ninguém' || nomePersonagem === '') { clearInterval(intervaloAtaqueGoverno); return; }
        if (contadorVerificacaoAtaque >= MAX_VERIFICACOES) { clearInterval(intervaloAtaqueGoverno); fecharAlertaAtaque('alerta-ataque-governador'); return; }
        fetch(urlApiAtaqueGoverno, { method: 'POST', body: dadosRequest }).then(response => response.json()).then(data => {
            if (data.atacado && data.locais && data.locais.length > 0) { criarAlertaAtaque(data.locais); } else { fecharAlertaAtaque('alerta-ataque-governador'); }
        }).catch(error => { clearInterval(intervaloAtaqueGoverno); });
        contadorVerificacaoAtaque++;
    }

// --- SEÇÃO 7: INICIALIZAÇÃO DE LOOPS (VELOCIDADE RÁPIDA) ---
    
    // 1. LOGS DE OCORRÊNCIA (Clã, Local, Global)
    // Antes: 15000 (15s) -> Agora: 3000 (3 segundos)
    atualizarFeeds(); 
    setInterval(atualizarFeeds, 1000); 

    // 2. RADAR DE INVASÃO (Personagens chegando)
    // Mantido em 2 segundos (já era rápido)
    if (situacaoLimpa.includes("invadindo")) {
        monitorarChegadas(); 
        setInterval(monitorarChegadas, 1000); 
    }

    // 3. ALERTA CRÍTICO DE GOVERNO (Defenda sua Cidade)
    // Antes: 60000 (1 minuto) -> Agora: 5000 (5 segundos)
    if (nomePersonagem !== 'Ninguém' && nomePersonagem !== '') {
        verificarAtaquesGoverno(); 
        // Agora verifica a cada 5 segundos para o alerta ser quase imediato
        intervaloAtaqueGoverno = setInterval(verificarAtaquesGoverno, 5000);
    }

    // 4. SINCRONIZAÇÃO DE STATUS
    // Mantido em 4 segundos
    var statusNaTela = "<?php echo isset($situacao) ? $situacao : ''; ?>";
    setInterval(function() {
        fetch('sistema/scripts/verificar_status_situacao_personagem.php')
            .then(response => response.text())
            .then(statusNoBanco => {
                if (statusNoBanco.trim() !== "" && statusNoBanco.trim() !== statusNaTela.trim()) {
                    location.reload();
                }
            }).catch(err => {});
    }, 4000);
</script>

</body>
</html>