<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}

session_start();
require 'conexao.php';
bcscale(10);

// Cálculo do saldo na carteira (baseado na mempool - tabela mempool)
try {
    $wallet = $_SESSION['user_wallet'];

    // Consulta de saldo enviado (remetente) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_enviado FROM mempool WHERE remetente = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_enviado = $result['total_enviado'];

    // Consulta de saldo recebido (destinatário) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_recebido FROM mempool WHERE destinatario = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $saldo_recebido = $result['total_recebido'];

    // Saldo na carteira (considerando valores enviados e recebidos)
    $saldo_carteira = bcsub($saldo_recebido, $saldo_enviado, 10);

    // Verificar se o saldo é negativo e ajustar para zero, se necessário
    $saldo_carteira = max($saldo_carteira, 0);

    // Definir a cor do saldo na carteira
    $cor_saldo_carteira = $saldo_carteira >= 0 ? 'darkgreen' : 'darkred';

    // Calcular o saldo livre (sem considerar valores no cofre)
    $saldo_livre = $saldo_carteira;
    $_SESSION['latillas'] = $saldo_livre;
    $_SESSION['saldolivre'] = $saldo_livre;

} catch (PDOException $e) {
    $saldo_carteira = "Erro na consulta: " . $e->getMessage();
    $cor_saldo_carteira = 'darkred';
    $saldo_livre = "Erro na consulta: " . $e->getMessage();
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

  
// Verifique se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Receba os dados do formulário
    $valor_aposta = $_POST['aposta'];
    $duracao_por_minuto = $_POST['duracao_por_minuto'];
    $limite_de_turnos = $_POST['limite_de_turnos_passados'];

    // Verifique se os dados são válidos
    if (strlen($valor_aposta) > 10 || strlen($duracao_por_minuto) > 5 || strlen($limite_de_turnos) > 3) {
        // Os dados excedem os limites permitidos
        $_SESSION['msg'] = "Os valores inseridos excedem os limites permitidos.";
header("Location:criarjogo.php");
exit;
}

// Verifique se o valor da aposta é maior que o saldo
    if ($valor_aposta > $saldo_livre) {
$_SESSION['msg'] = "O valor da aposta é maior que o saldo disponível.";
header("Location: criarjogo.php");
exit;
} 
if ($valor_aposta < $saldo_livre) {
// Apagar msg da session de erro se tiver
$_SESSION['msg'] = "";

// Gerar número aleatório pro game
try {
    // Recupere todos os números existentes na coluna 'game'
    $stmt = $pdo->query("SELECT game FROM games");
    $existing_numbers = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Gere um número aleatório único
    do {
        $random_number = rand(1, 1000000000); // Altere o intervalo conforme necessário
    } while (in_array($random_number, $existing_numbers));

    // O número aleatório gerado é único
    $game = $random_number;

} catch (PDOException $e) {
    echo "Erro ao recuperar números existentes: " . $e->getMessage();
}


// Seus valores
$player = $_SESSION['user_name'];
$time = $duracao_por_minuto;
$played = date('Y-m-d H:i:s');

$limite = $limite_de_turnos; 
$bet = $_POST['aposta'];
$msggame = "Jogo criado. Aguardando oponente.";

try {
    // Preparar a declaração SQL
    $sql = "INSERT INTO games (game, bet, p1, time, played, limite, msg) VALUES (:game, :bet, :jogador, :time, :played, :limite, :msggame)";
    $stmt = $pdo->prepare($sql);

    // Vincular os parâmetros com os valores
    $stmt->bindParam(':game', $game, PDO::PARAM_STR);
    $stmt->bindParam(':bet', $bet, PDO::PARAM_STR);
    $stmt->bindParam(':jogador', $player, PDO::PARAM_STR);
    $stmt->bindParam(':time', $time, PDO::PARAM_STR);
    $stmt->bindParam(':played', $played, PDO::PARAM_STR);
    $stmt->bindParam(':limite', $limite, PDO::PARAM_STR);
$stmt->bindParam(':msggame', $msggame, PDO::PARAM_STR);

    // Executar a consulta
    $stmt->execute();

    // Verificar se o INSERT foi bem-sucedido
    if ($stmt->rowCount() > 0) {
      //  echo "Inserção bem-sucedida!";
        
        
        
        
        
        
        // Inserir dados na mempol / tirar saldo usuário 
     
try {
    // Seus valores
    $userwallet = $_SESSION['user_wallet'];
    
    $dataehora = date("Y-m-d H:i:s"); // Obtém a data e hora atual no formato 'AAAA-MM-DD HH:MM:SS'
    
    // Preparar a declaração SQL para inserção na tabela mempool
    $sql = "INSERT INTO mempool (destinatario, remetente, dataehora, valor) VALUES (:destinatario, :remetente, :dataehora, :valor)";
    $stmt = $pdo->prepare($sql);

    // Vincular os parâmetros com os valores
    $stmt->bindParam(':destinatario', $game, PDO::PARAM_STR);
    $stmt->bindParam(':remetente', $userwallet, PDO::PARAM_STR);
    $stmt->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);
    $stmt->bindParam(':valor', $bet, PDO::PARAM_STR);

    // Executar a consulta
    $stmt->execute();

    // Verificar se o INSERT foi bem-sucedido
    if ($stmt->rowCount() > 0) {
      //  echo "Inserção na mempool bem-sucedida!";
    } else {
        echo "Nenhum registro inserido na mempool.";
    }
} catch (PDOException $e) {
    echo "Erro na inserção na mempool: " . $e->getMessage();
}

        
        
        
    } else {
        echo "Nenhum registro inserido.";
    }
} catch (PDOException $e) {
    echo "Erro na inserção: " . $e->getMessage();
}





$_SESSION['msg'] = "Jogo n° $game criado com sucesso";
$_SESSION['game_select'] = $game;
   $_SESSION['gameselect'] = $game;
   
   
   
   header("Location: tst.php");


}
// Fechamento do if (chegou post)
}
?>


