<?php
session_start();
require '../../conexao.php'; 

// ==========================================================
// 1. SEGURANÇA E DADOS
// ==========================================================
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];
$user_id_logado = $_SESSION['user_id']; // ID do jogador real

// Busca dados atualizados do personagem
$stmtP = $pdo->prepare("SELECT id, cla, cargo FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você não está em nenhum clã para poder sair.";
    header("Location: ../../dashboard.php");
    exit();
}

$nome_cla = $user_data['cla'];
$meu_cargo = (int)$user_data['cargo'];
$personagem_id = $user_data['id'];

// Busca ID do Clã
$stmtC = $pdo->prepare("SELECT id FROM cla WHERE nome = :nome LIMIT 1");
$stmtC->execute([':nome' => $nome_cla]);
$cla_data = $stmtC->fetch(PDO::FETCH_ASSOC);

if (!$cla_data) { 
    die("Erro Crítico: Clã não encontrado."); 
}  
$cla_id = $cla_data['id'];

// ==========================================================
// 2. PROCESSAMENTO (POST)
// ==========================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirmar_saida'])) {
    
    // --- REGRA 1: O LÍDER NÃO PODE ABANDONAR ---
    if ($meu_cargo >= 7) {
        $_SESSION['msg'] = "ERRO CRÍTICO: O 1º Ministro não pode abandonar o barco! Você deve transferir a liderança.";
        header("Location: sair_cla.php"); 
        exit();
    }

    // --- SAÍDA DIRETA (SEM PIN) ---
    try {
        $pdo->beginTransaction();

        // 1. Remove do Clã e Reseta Cargo
        $stmtUp = $pdo->prepare("UPDATE personagens SET cla = 'Nenhum', cargo = 1 WHERE id = :id");
        $stmtUp->execute([':id' => $personagem_id]);

        // 2. Log
        $stmtLog = $pdo->prepare("INSERT INTO cla_log_membros (cla_id, acao, quem_fez, cargo_quem_fez, alvo, motivo, data) VALUES (:cid, 'SAIDA_VOLUNTARIA', :quem, :cargo, :quem, 'Abandonou o clã', NOW())");
        $stmtLog->execute([
            ':cid' => $cla_id,
            ':quem' => $nomePersonagem,
            ':cargo' => $meu_cargo
        ]);

        // 3. Atualiza Sessão
        $_SESSION['cla'] = 'Nenhum';
        $_SESSION['cargo_id'] = 1;

        $pdo->commit();
        
        $_SESSION['msg'] = "Você abandonou o clã $nome_cla com sucesso.";
        header("Location: ../../dashboardmed.php");
        exit();

    } catch (Exception $e) {
        if ($pdo->inTransaction()) { $pdo->rollBack(); }
        $_SESSION['msg'] = "Erro interno: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Abandonar Clã | <?= htmlspecialchars($nome_cla) ?></title>
    <link rel="stylesheet" href="../../css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .danger-container { max-width: 500px; margin: 50px auto; text-align: center; }
        .alert-box {
            background: rgba(20, 0, 0, 0.9); border: 2px solid #ff0000; border-radius: 10px;
            padding: 30px; box-shadow: 0 0 30px rgba(255, 0, 0, 0.2); position: relative; overflow: hidden;
            animation: alertPulse 2s infinite;
        }
        @keyframes alertPulse {
            0% { box-shadow: 0 0 10px rgba(255,0,0,0.2); border-color: #800000; }
            50% { box-shadow: 0 0 30px rgba(255,0,0,0.6); border-color: #ff0000; }
            100% { box-shadow: 0 0 10px rgba(255,0,0,0.2); border-color: #800000; }
        }
        .warning-icon { font-size: 3rem; color: #ff0000; margin-bottom: 15px; }
        .warning-text { color: #ffcccc; font-size: 1rem; line-height: 1.5; margin-bottom: 20px; font-family: 'Segoe UI', sans-serif; }
        
        .btn-abandon {
            background: #330000; color: #ff0000; border: 1px solid #ff0000; padding: 15px;
            width: 100%; font-weight: bold; text-transform: uppercase; cursor: pointer; transition: 0.3s;
        }
        .btn-abandon:hover { background: #ff0000; color: #fff; box-shadow: 0 0 20px #ff0000; }
        .btn-cancel {
            background: transparent; color: #ccc; border: 1px solid #555; padding: 10px;
            width: 100%; margin-top: 10px; cursor: pointer;
        }
        .btn-cancel:hover { background: #333; color: #fff; }
    </style>
</head>
<body>
    <div class="light-rays"></div>
    <div class="container danger-container">
        <?php if (!empty($_SESSION['msg'])): ?>
            <div class="game-msg-box" style="border-color: red; color: red;">
                <?= htmlspecialchars($_SESSION['msg']) ?>
            </div>
            <?php $_SESSION['msg'] = ''; ?>
        <?php endif; ?>

        <div class="alert-box">
            <i class="fas fa-exclamation-triangle warning-icon"></i>
            <h2 style="color: #ff0000; text-transform: uppercase; margin-bottom: 10px;">ATENÇÃO</h2>
            <h3 style="color: #fff; margin-bottom: 20px;">Abandonar <?= htmlspecialchars($nome_cla) ?>?</h3>
            <div class="warning-text">
                <p>Você está prestes a desertar de seu clã.</p>
                <ul style="text-align: left; margin: 15px 0; padding-left: 20px; color: #aaa; font-size: 0.9rem;">
                    <li>Você perderá seu cargo atual (<?= $meu_cargo ?>).</li>
                    <li>Você perderá acesso ao chat e ordens.</li>
                    <li>Esta ação ficará registrada no histórico do clã.</li>
                </ul>
                <p><strong>Deseja realmente confirmar esta ação?</strong></p>
            </div>
            
            <form action="" method="POST">
                <button type="submit" name="confirmar_saida" class="btn-abandon">
                    <i class="fas fa-door-open"></i> Confirmar Saída
                </button>
            </form>
            
            <a href="../../dashboardmed.php"><button class="btn-cancel">Voltar ao jogo</button></a>
        </div>
        <center><footer class="footer-simple-medieval" style="margin-top:20px;"><p>&copy; 2025 RPG</p></footer></center>
    </div>
</body>
</html>