<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro - RPG ERA MEDIEVAL: Ferro & Fogo Pelo Poder</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css"> <style>
        /* Variáveis CSS */
        :root {
            --primary-color: #0000FF; /* Azul do seu botão */
            --secondary-color: #0A192F; /* Azul escuro para fundo (fallback, não usado com imagem) */
            --text-light: #E0E6F0;
            --text-dark: #222;
            --card-background: #ffffff;
            --input-border: #cccccc;
            --input-focus-border: var(--primary-color);
            --info-background: #f0f8ff; /* Um azul mais claro para a caixa de info */
            --info-text: #334155;
            --error-color: #EF4444;
            --success-color: #22C55E;
            --shadow-light: rgba(0, 0, 0, 0.1);
        }

        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            /* Usando a imagem de fundo */
            background: url('rpg-login-background.jpg') no-repeat center center fixed; /* Ajuste 'background-loghin.jpg' para o nome correto da sua imagem */
            background-size: cover; /* Garante que a imagem cubra todo o fundo */
            display: flex;
            justify-content: center;
            /* Alterado de align-items: center para flex-start e adicionado padding */
            align-items: flex-start; /* Alinha o conteúdo ao topo do container flexível */
            min-height: 100vh;
            color: var(--text-dark);
            box-sizing: border-box;
            padding: 20px 0; /* Adiciona padding vertical para o card não tocar as bordas */
            overflow-y: auto; /* Permite scroll se o conteúdo for muito longo */
        }

        .main-container {
            background-color: var(--card-background);
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 10px 30px var(--shadow-light);
            max-width: 480px;
            width: 90%;
            margin: 0 auto; /* Centraliza horizontalmente */
            text-align: center;
            box-sizing: border-box;
            /* Remove a margem vertical que estava forçando o corte */
            /* margin: 20px auto; (removido ou alterado para 0 auto) */
        }

        .bn {
            max-width: 150px;
            margin-bottom: 25px;
        }

        .titulo {
            font-size: 2.2em;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 25px;
            letter-spacing: -0.5px;
        }

        .info-box {
            background-color: var(--info-background);
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            font-size: 0.95em;
            color: var(--info-text);
            text-align: left;
            line-height: 1.6;
            border-left: 5px solid var(--primary-color);
        }
        .info-box strong {
            color: var(--primary-color);
            font-weight: 600;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 15px; /* Espaço entre os campos */
        }

        input[type="number"],
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="date"],
        select {
            width: calc(100% - 24px); /* Ajuste para padding */
            padding: 12px;
            font-size: 1em;
            border-radius: 8px;
            border: 1px solid var(--input-border);
            box-sizing: border-box;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }

        input:focus, select:focus {
            border-color: var(--input-focus-border);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 0, 255, 0.2);
        }

        .error {
            color: var(--error-color);
            margin-bottom: 15px;
            font-weight: 500;
        }
        .success {
            color: var(--success-color);
            margin-bottom: 15px;
            font-weight: 500;
        }
        
        .btnmenu {
            background-color: var(--primary-color);
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1.1em;
            font-weight: 600;
            margin: 8px 5px;
            transition: background-color 0.3s ease, transform 0.2s ease;
            box-shadow: 0 4px 15px rgba(0, 0, 255, 0.2);
            width: auto;
        }
        .btnmenu:hover {
            background-color: #0000CC;
            transform: translateY(-2px);
        }
        .btnmenu:active {
            transform: translateY(0);
            box-shadow: 0 2px 10px rgba(0, 0, 255, 0.3);
        }

        .checkbox-wrapper {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            font-size: 0.95em;
            color: var(--text-dark);
            cursor: pointer;
            margin: 15px 0 25px 0;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }

        .checkbox-wrapper input[type="checkbox"] {
            appearance: none;
            width: 20px;
            height: 20px;
            border: 2px solid var(--primary-color);
            border-radius: 5px;
            background-color: transparent;
            position: relative;
            cursor: pointer;
            flex-shrink: 0;
        }

        .checkbox-wrapper input[type="checkbox"]:checked::before {
            content: "\2713";
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 16px;
            color: var(--primary-color);
            background-color: transparent;
        }

        .form-group-select {
            text-align: left;
            width: 100%;
            margin-bottom: 15px;
        }
        .form-group-select label {
            display: block;
            margin-bottom: 8px;
            font-size: 0.95em;
            color: var(--text-dark);
            font-weight: 500;
        }
        .form-group-select select {
            width: 100%;
        }

        .button-container {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .footer-buttons {
            margin-top: 30px;
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px;
        }

        /* Responsividade */
        @media (max-width: 600px) {
            body {
                padding: 15px 0; /* Um pouco menos de padding em mobile */
            }
            .main-container {
                padding: 20px;
                width: 95%;
                margin: 0 auto; /* Garante centralização */
            }
            .titulo {
                font-size: 1.8em;
            }
            .btnmenu {
                width: 100%;
                margin: 5px 0;
            }
            .footer-buttons {
                flex-direction: column;
            }
        }
    </style>

    <script>
        function validarCPF(cpf) {
            cpf = cpf.replace(/[^\d]+/g, '');
            if (cpf.length !== 11 || /^(\d)\1+$/.test(cpf)) return false;
            let soma = 0;
            for (let i = 0; i < 9; i++) soma += parseInt(cpf.charAt(i)) * (10 - i);
            let resto = (soma * 10) % 11;
            if (resto === 10 || resto === 11) resto = 0;
            if (resto !== parseInt(cpf.charAt(9))) return false;
            soma = 0;
            for (let i = 0; i < 10; i++) soma += parseInt(cpf.charAt(i)) * (11 - i);
            resto = (soma * 10) % 11;
            if (resto === 10 || resto === 11) resto = 0;
            return resto === parseInt(cpf.charAt(10));
        }

        function validarFormulario() {
            // Validar CPF
            const cpfInput = document.querySelector('input[name="cpf"]');
            if (!validarCPF(cpfInput.value)) {
                alert("CPF inválido. Verifique e tente novamente.");
                cpfInput.focus();
                return false;
            }

            // Validar termos
            const termos = document.querySelector('#termos');
            if (!termos.checked) {
                alert("Você deve aceitar os termos e condições para continuar.");
                termos.focus();
                return false;
            }

            // Validar senhas iguais
            const senhaInput = document.querySelector('input[name="senha"]');
            const confirmarSenhaInput = document.querySelector('input[name="confirmar_senha"]');
            if (senhaInput.value !== confirmarSenhaInput.value) {
                alert("As senhas não coincidem.");
                senhaInput.focus();
                return false;
            }

            // Validar pins iguais
            const pinInput = document.querySelector('input[name="pin"]');
            const confirmarPinInput = document.querySelector('input[name="confirmar_pin"]');
            if (pinInput.value !== confirmarPinInput.value) {
                alert("Os PINs não coincidem.");
                pinInput.focus();
                return false;
            }

            return true;
        }

        window.addEventListener('DOMContentLoaded', function () {
            // Máscara para CPF
            const cpfInput = document.querySelector('input[name="cpf"]');
            cpfInput.addEventListener('input', function () {
                let v = cpfInput.value.replace(/\D/g, '');
                if (v.length > 11) v = v.slice(0, 11);
                v = v.replace(/(\d{3})(\d)/, '$1.$2');
                v = v.replace(/(\d{3})(\d)/, '$1.$2');
                v = v.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
                cpfInput.value = v;
            });

            // Máscara para telefones
            const zaps = [document.querySelector('input[name="zap1"]'), document.querySelector('input[name="zap2"]')];
            zaps.forEach(function (input) {
                if (input) {
                    input.addEventListener('input', function () {
                        let v = input.value.replace(/\D/g, '');
                        if (v.length > 11) v = v.slice(0, 11);
                        v = v.replace(/^(\d{2})(\d)/, '($1) $2');
                        v = v.replace(/(\d{5})(\d)/, '$1-$2');
                        input.value = v;
                    });
                }
            });
        });
    </script>
</head>

<body>
    <div class="main-container">
        <img class="bn" src="bn.png" alt="Logo da Plataforma"><br>
        <div class="titulo">Cadastro</div>

        <?php
        session_start();
        if (isset($_GET['erro'])) {
            $erros = [
                'usuario_email_cadastrado' => 'Usuário ou email já cadastrados.',
                'campos_vazios' => 'Preencha todos os campos obrigatórios.',
                'cpf_invalido' => 'CPF inválido.',
                'senhas_diferentes' => 'As senhas não coincidem.',
                'pins_diferentes' => 'Os PINs não coincidem.',
                'falha_armazenamento' => 'Falha ao armazenar dados. Tente novamente.',
                'erro_bd' => 'Erro no banco de dados. Tente novamente.'
            ];
            echo '<p class="error">' . ($erros[$_GET['erro']] ?? 'Erro desconhecido.') . '</p>';
        } elseif (isset($_GET['cadastrado'])) {
            echo '<p class="success">Usuário cadastrado com sucesso!</p>';
        }
        ?>

        <div class="info-box">
            <strong>Atenção!</strong><br><br>
            Por favor, preencha todas as informações corretamente. Dados inconsistentes ou falsos poderão impedir a recuperação da sua conta.<br><br>
            Conforme as leis brasileiras sobre criptoativos, é possível que tenhamos que declarar movimentações financeiras. Por isso, os dados precisam ser reais e válidos.<br><br>
            O <strong>PIN, senha e frase de recuperação</strong> não poderão ser manualmente alterados. Guarde essas informações com cuidado!<br><br>
            Aceitar os termos é obrigatório para usar nossa plataforma.
        </div>

        <form action="cadastrar.php" method="POST" onsubmit="return validarFormulario();">
            <input type="text" name="user" placeholder="Nome de usuário" required>
            <input type="email" name="email" placeholder="Email" required>

            <input type="text" name="cpf" placeholder="CPF (somente números)" maxlength="14" required>
            <input type="date" name="nascimento" title="Data de Nascimento" required>

            <select name="genero" required>
                <option value="" disabled selected>Gênero</option>
                <option value="masculino">Masculino</option>
                <option value="feminino">Feminino</option>
                <option value="outro">Outro</option>
            </select>

            <input type="text" name="zap1" placeholder="Celular / WhatsApp 1" required>
            <input type="text" name="zap2" placeholder="Celular / WhatsApp 2 (opcional)">

            <input type="number" name="pin" placeholder="Código PIN (apenas números)" required>
            <input type="number" name="confirmar_pin" placeholder="Confirmar código PIN" required>

            <input type="password" name="senha" placeholder="Senha" required>
            <input type="password" name="confirmar_senha" placeholder="Confirmar senha" required>

            <input type="text" name="frase" placeholder="Frase de recuperação de conta" required>

            <div class="form-group-select">
                <label for="2fatores"><center>Autenticar em 2 fatores?</center></label>
                <select name="2fatores" id="2fatores">
                    <option value="0">Não</option>
                    <option value="1">Sim</option>
                </select>
            </div>

            <div class="form-group-select">
                <label for="informacoeszap"><center>Quer receber informações do projeto no WhatsApp/Telegram?</center></label>
                <select name="informacoeszap" id="informacoeszap">
                    <option value="1">Sim</option>
                    <option value="0">Não</option>
                </select>
            </div>

            <label class="checkbox-wrapper">
                <input type="checkbox" name="termos" id="termos" required>
                Aceito os termos e condições
            </label>

            <div class="button-container">
                <button class="btnmenu" type="submit">Cadastrar</button>
            </div>
        </form>

        <div class="footer-buttons">
            <a href="login.php"><button class="btnmenu">Login</button></a>
            <a href="esquesci.php"><button class="btnmenu">Esqueci a senha</button></a>
        </div>
    </div>
</body>
</html>
