<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['personagem'], $_SESSION['local'])) {
    die("Sessão inválida.");
}

// 1. Processar Envio
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fala'])) {
    // Rate Limit (1 msg a cada 2s)
    if (isset($_SESSION['ultima_mensagem']) && (time() - $_SESSION['ultima_mensagem'] < 2)) {
        header("Location: ".$_SERVER['PHP_SELF']); 
        exit();
    }

    $fala = trim($_POST['fala']);
    $direcionada = !empty($_POST['direcionada']) ? trim($_POST['direcionada']) : null;

    if (!empty($fala)) {
        $stmt = $pdo->prepare("SELECT personagem FROM personagens WHERE id = :id");
        $stmt->execute([':id' => $_SESSION['personagem']]);
        $p = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($p) {
            $stmt = $pdo->prepare("INSERT INTO chatpersonagens (personagem, jogador, fala, direcionada, local) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$p['personagem'], $_SESSION['user_name'], $fala, $direcionada, $_SESSION['local']]);
            $_SESSION['ultima_mensagem'] = time();
        }
    }
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// 2. Buscar Personagens
$stmt = $pdo->prepare("SELECT personagem FROM personagens 
                       WHERE local = :local 
                       AND id != :meu_id 
                       AND situacao NOT IN ('escondido', 'fugindo e reagrupando soldados') 
                       ORDER BY personagem ASC");
$stmt->execute([':local' => $_SESSION['local'], ':meu_id' => $_SESSION['personagem']]);
$personagens_no_local = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/dashboardmed.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: transparent;
            padding: 5px; 
            margin: 0;
            overflow: hidden; 
            font-family: 'Segoe UI', sans-serif;
        }
        form {
            display: flex;
            flex-direction: column; /* Empilha os elementos */
            gap: 8px; /* Espaço entre a caixa de texto e os botões */
            width: 100%;
        }
        
        /* Caixa de Texto (Linha de Cima) */
        .chat-input {
            width: 100%;
            background: rgba(0, 0, 0, 0.6);
            border: 1px solid var(--primary);
            color: white;
            padding: 10px;
            border-radius: 6px;
            outline: none;
            font-size: 0.95rem;
            box-sizing: border-box; /* Garante que o padding não estoure a largura */
        }
        .chat-input:focus { 
            border-color: var(--neon-bright); 
            box-shadow: 0 0 8px var(--primary); 
            background: rgba(0, 0, 0, 0.8);
        }
        
        /* Linha de Baixo (Select + Botão) */
        .bottom-row {
            display: flex;
            gap: 8px;
            width: 100%;
        }

        /* Select */
        .chat-select {
            flex-grow: 1; /* Ocupa o espaço restante */
            background: rgba(0, 0, 20, 0.8);
            border: 1px solid var(--primary);
            color: #ccc;
            padding: 8px;
            border-radius: 6px;
            font-size: 0.85rem;
            cursor: pointer;
        }
        
        /* Botão Enviar */
        .chat-btn {
            background: var(--primary);
            color: white;
            border: 1px solid var(--primary);
            padding: 8px 20px; /* Botão largo para celular */
            border-radius: 6px;
            cursor: pointer;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 0.8rem;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        .chat-btn:hover {
            background: black;
            box-shadow: 0 0 10px var(--neon-bright);
            color: var(--primary);
        }
    </style>
</head>
<body>
    <form method="POST" action="">
        <input type="text" name="fala" class="chat-input" placeholder="Digite sua mensagem aqui..." required autocomplete="off">

        <div class="bottom-row">
            <select name="direcionada" class="chat-select">
                <option value="">Para: Todos</option>
                <?php foreach ($personagens_no_local as $p): ?>
                    <option value="<?php echo htmlspecialchars($p['personagem']); ?>">
                        <?php echo htmlspecialchars($p['personagem']); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <button type="submit" class="chat-btn">
                <i class="fas fa-paper-plane"></i> Enviar
            </button>
        </div>
    </form>
</body>
</html>