<?php
// atualizar_fichas.php - API VISUAL SEGURA
require '../conexao.php';

// Inicia sessão de forma segura (mas sem regenerar ID toda hora pra não pesar API)
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.cookie_httponly', 1);
    session_start();
}

header('Content-Type: application/json');

// Se não estiver logado, avisa o JS para recarregar a página
if (!isset($_SESSION['user_name'])) {
    echo json_encode(['success' => false, 'redirect' => true]);
    exit();
}

$user_name = $_SESSION['user_name'];

try {
    // Consulta otimizada apenas para leitura
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
    $stmt->execute([$user_name]);
    $total = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    echo json_encode([
        'success' => true, 
        'total' => $total
    ]);

} catch (Exception $e) {
    // Em caso de erro, retorna falha silenciosa
    echo json_encode(['success' => false]);
}
?>