<?php
session_start();

// Conexão
if (file_exists('../../conexao.php')) {
    require '../../conexao.php';
} else {
    require '../conexao.php';
}

// Forçar UTF-8
$pdo->exec("SET NAMES utf8");

// DEBUG ATIVO
ini_set('display_errors', 1);
error_reporting(E_ALL);

// 1. SEGURANÇA
if (!isset($_SESSION['user_id']) || empty($_SESSION['personagem'])) {
    header("Location: ../login.php");
    exit();
}

$nomePersonagem = $_SESSION['personagem_nome'];
$local_alvo = $_SESSION['local']; 

// 2. DADOS DO ATACANTE
$stmtP = $pdo->prepare("SELECT id, cla FROM personagens WHERE personagem = :nome LIMIT 1");
$stmtP->execute([':nome' => $nomePersonagem]);
$user_data = $stmtP->fetch(PDO::FETCH_ASSOC);

if (!$user_data || empty($user_data['cla']) || $user_data['cla'] === 'Nenhum') {
    $_SESSION['msg'] = "Você precisa de um Clã para dominar territórios.";
    header("Location: ../dashboardmed.php");
    exit();
}

$cla_atacante = $user_data['cla'];
$id_atacante = $user_data['id'];

try {
    $pdo->beginTransaction();

    // 3. BUSCA DADOS DO LOCAL
    $stmtMap = $pdo->prepare("SELECT dominio, governante FROM mapasmed WHERE nome = :local LIMIT 1");
    $stmtMap->execute([':local' => $local_alvo]);
    $dados_mapa = $stmtMap->fetch(PDO::FETCH_ASSOC);

    if (!$dados_mapa) {
        throw new Exception("Local '$local_alvo' não encontrado.");
    }

    $cla_antigo = $dados_mapa['dominio'];
    $gov_antigo = $dados_mapa['governante'];

    // 4. VERIFICAÇÃO DE DEFENSORES
    if ($cla_antigo !== 'Nenhum' && $cla_antigo !== $cla_atacante) {
        $stmtDefesa = $pdo->prepare("SELECT personagem FROM personagens 
                                     WHERE cla = :cla_def 
                                     AND local = :local 
                                     AND situacao != 'escondido' 
                                     AND personagem != :atacante
                                     LIMIT 1");
        $stmtDefesa->execute([
            ':cla_def' => $cla_antigo, 
            ':local' => $local_alvo,
            ':atacante' => $nomePersonagem
        ]);

        if ($stmtDefesa->rowCount() > 0) {
            $defensor = $stmtDefesa->fetch(PDO::FETCH_ASSOC);
            $_SESSION['msg'] = "DOMÍNIO FALHOU! O defensor {$defensor['personagem']} ainda está no local. Expulse-o!";
            $pdo->rollBack();
            header("Location: ../dashboardmed.php");
            exit();
        }
    }

    // ==========================================================
    // 5. BUSCA DA CAMPANHA (CORRIGIDO PARA DIAGNÓSTICO)
    // ==========================================================
    
    // Removemos os filtros 'dominou=0' e data do SQL. Vamos pegar a ÚLTIMA tentativa.
    // Assim saberemos se ela existe mas expirou, ou se existe mas já foi concluída.
    $stmtGuerra = $pdo->prepare("SELECT id, iniciou, dominou FROM guerra_dominio 
                                 WHERE atacante = :eu 
                                 AND local = :local 
                                 ORDER BY id DESC 
                                 LIMIT 1");
    $stmtGuerra->execute([':eu' => $nomePersonagem, ':local' => $local_alvo]);
    $guerra = $stmtGuerra->fetch(PDO::FETCH_ASSOC);

    // CENÁRIO A: NUNCA FOI CRIADA
    if (!$guerra) {
        $pdo->prepare("UPDATE personagens SET situacao = 'livre' WHERE id = :id")->execute([':id' => $id_atacante]);
        $pdo->commit(); 
        
        $_SESSION['msg'] = "ERRO FATAL: O sistema não encontrou o registro de início da invasão. O ataque não foi salvo no banco corretamente no início.";
        header("Location: ../dashboardmed.php");
        exit();
    }

    $id_guerra = $guerra['id'];
    $data_inicio = $guerra['iniciou'];
    $status_dominio = $guerra['dominou'];

    // CENÁRIO B: JÁ FOI DOMINADO (DUPLO CLIQUE?)
    if ($status_dominio == 1) {
        $pdo->prepare("UPDATE personagens SET situacao = 'livre' WHERE id = :id")->execute([':id' => $id_atacante]);
        $pdo->commit();
        
        $_SESSION['msg'] = "Erro: Esta invasão já foi concluída e registrada como sucesso anteriormente.";
        header("Location: ../dashboardmed.php");
        exit();
    }

    // CENÁRIO C: TEMPO EXPIROU (MAIS DE 1 HORA)
    $agora = new DateTime();
    $inicio = new DateTime($data_inicio);
    $diff = $agora->diff($inicio);
    $minutos_passados = ($diff->days * 24 * 60) + ($diff->h * 60) + $diff->i;

    if ($minutos_passados > 60) {
        $pdo->prepare("UPDATE personagens SET situacao = 'livre' WHERE id = :id")->execute([':id' => $id_atacante]);
        $pdo->commit();
        
        $_SESSION['msg'] = "Tempo Esgotado: A invasão expirou (Iniciada há $minutos_passados minutos). Comece novamente.";
        header("Location: ../dashboardmed.php");
        exit();
    }

    // SE PASSOU POR TUDO ISSO, PODE DOMINAR!
    $data_fim = date('Y-m-d H:i:s'); 

    // ==========================================================
    // 6. ATUALIZAÇÕES (CONQUISTA)
    // ==========================================================

    // A. Atualiza Mapa
    $stmtMapUp = $pdo->prepare("UPDATE mapasmed SET dominio = :novo_cla, governante = :novo_gov WHERE nome = :local");
    $stmtMapUp->execute([
        ':novo_cla' => $cla_atacante,
        ':novo_gov' => $nomePersonagem,
        ':local' => $local_alvo
    ]);

    // B. Atualiza Guerra
    $stmtGuerraUp = $pdo->prepare("UPDATE guerra_dominio SET dominou = 1 WHERE id = :id_guerra");
    $stmtGuerraUp->execute([':id_guerra' => $id_guerra]);

    // C. Libera Personagem e Reputação
    $stmtAtacanteUp = $pdo->prepare("UPDATE personagens SET situacao = 'livre', reputacao = reputacao + 1 WHERE id = :id");
    $stmtAtacanteUp->execute([':id' => $id_atacante]);

    // D. Penaliza Antigo Governante
    if ($gov_antigo && $gov_antigo !== 'Ninguém' && $gov_antigo !== $nomePersonagem) {
        $stmtPunish = $pdo->prepare("UPDATE personagens SET reputacao = reputacao - 0.5 WHERE personagem = :nome");
        $stmtPunish->execute([':nome' => $gov_antigo]);
    }

    // E. Infossitema
    $inicio_fmt = date('d/m H:i', strtotime($data_inicio));
    $fim_fmt = date('d/m H:i', strtotime($data_fim));
    $assunto = "Conquista de Território";
    $mensagem = "O personagem $nomePersonagem dominou $local_alvo (Antigo gov: $gov_antigo do clã $cla_antigo). Iniciou: $inicio_fmt - Conquistou: $fim_fmt.";

    $stmtInfo = $pdo->prepare("INSERT INTO infossistema (assunto, informacao, dataehora) VALUES (:assunto, :msg, NOW())");
    $stmtInfo->execute([':assunto' => $assunto, ':msg' => $mensagem]);

    // F. Ocorrências Locais
    $msg_local = "O personagem $nomePersonagem concluiu a invasão e dominou $local_alvo!";
    try {
        $stmtOcLocal = $pdo->prepare("INSERT INTO ocorrencias_locais (personagem1, cla1, tipo, situacao, local, tempo_notificacao, data) VALUES (:p1, :c1, 'conquista', :sit, :loc, 300, NOW())");
        $stmtOcLocal->execute([':p1'=>$nomePersonagem, ':c1'=>$cla_atacante, ':sit'=>$msg_local, ':loc'=>$local_alvo]);
    } catch (Exception $e) {}

    // G. Ocorrências Clã
    $msg_cla = "VITÓRIA! O personagem $nomePersonagem conquistou $local_alvo!";
    try {
        $stmtOcCla = $pdo->prepare("INSERT INTO ocorrencias_clas (personagem1, cla1, tipo, situacao, local, tempo_notificacao, data) VALUES (:p1, :c1, 'conquista', :sit, :loc, 600, NOW())");
        $stmtOcCla->execute([':p1'=>$nomePersonagem, ':c1'=>$cla_atacante, ':sit'=>$msg_cla, ':loc'=>$local_alvo]);
    } catch (Exception $e) {}

    $pdo->commit();

    $_SESSION['msg'] = "VITÓRIA! $local_alvo agora pertence ao clã $cla_atacante!";
    header("Location: ../dashboardmed.php");
    exit();

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $_SESSION['msg'] = "Erro Crítico: " . $e->getMessage();
    header("Location: ../dashboardmed.php");
    exit();
}
?>