<?php
session_start();
require 'conexao.php';
bcscale(10);

// Função para calcular o hash com o nonce
function calculateHash($hash, $nonce) {
    // Substitua esta linha pelo cálculo real do hash com o nonce
    // Certifique-se de usar a mesma lógica que você está usando em outros lugares do código
    // Por exemplo: return hash('sha256', $hash . $nonce);
    return $hash . $nonce; // Simulando o cálculo do hash com o nonce
}

try {
    // Listar todas as transações na mempool por ordem de chegada
    $stmt = $pdo->prepare("SELECT * FROM mempool ORDER BY dataehora ASC");
    $stmt->execute();
    $transacoes_mempool = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($transacoes_mempool) > 0) {
        // Obter a primeira transação da mempool
        $primeira_transacao = $transacoes_mempool[0];

        // Armazenar os dados da primeira transação em variáveis
        $destinatario = $primeira_transacao['destinatario'];
        $remetente = $primeira_transacao['remetente'];
        $valor = $primeira_transacao['valor'];
        $dataehora = $primeira_transacao['dataehora'];
        $hash = $primeira_transacao['hash'];
        $link = $primeira_transacao['link'];

        // Apagar a primeira transação da mempool
        $stmt = $pdo->prepare("DELETE FROM mempool WHERE id = :id");
        $stmt->bindParam(':id', $primeira_transacao['id']);
        $stmt->execute();

        // Exibir os detalhes da primeira transação na tela
        echo "Primeira transação na mempool:";
        echo "<br>";
        echo "Destinatário: " . $destinatario;
        echo "<br>";
        echo "Remetente: " . $remetente;
        echo "<br>";
        echo "Valor: " . $valor . " M$";
        echo "<br>";
        echo "Data e Hora: " . $dataehora;
        echo "<br>";
        echo "Hash: " . $hash;
        echo "<br>";
        echo "Link: " . $link;

        // Definir o prefixo do hash alvo com 1 zero à esquerda
        $prefixo_zeros = '0';

        // Hash alvo com 1 zero à esquerda
        $hash_alvo = $prefixo_zeros . substr($hash, 1);

        // Tentar encontrar o nonce com 1 zero à esquerda do hash
        $nonce = 0;
        $contador_tentativas = 0;
        $inicio = microtime(true);
        while (true) {
            $hash_calculado = calculateHash($hash, $nonce);

            // Exibir a tentativa atual
            $contador_tentativas++;
            echo "<br>";
            echo "Tentativa $contador_tentativas: $hash_calculado";

            // Verificar se o hash atende ao critério de 1 zero à esquerda
            if (substr($hash_calculado, 0, 1) === $prefixo_zeros) {
                $fim = microtime(true);
                $tempo = $fim - $inicio;

                // Exibir os resultados
                echo "<br>";
                echo "Nonce encontrado: $nonce";
                echo "<br>";
                echo "Hash encontrado: $hash_calculado";
                echo "<br>";
                echo "Número de tentativas: $contador_tentativas";
                echo "<br>";
                echo "Tempo de mineração: $tempo segundos";

                // Adicionar a transação à tabela block
                $stmt = $pdo->prepare("INSERT INTO block (destinatario, remetente, dataehora, quantidade, hash, hashanterior, versao, validado) VALUES (:destinatario, :remetente, NOW(), :quantidade, :hash, 'hashanterior', '1.0', NOW())");
                $stmt->bindParam(':destinatario', $destinatario);
                $stmt->bindParam(':remetente', $remetente);
                $stmt->bindParam(':quantidade', $valor);
                $stmt->bindParam(':hash', $hash_calculado);
                $stmt->execute();

                // Redirecionar para a página minerar.php
                header("Location: minerar.php");
                exit(); // Certifique-se de usar o exit() após o redirecionamento para evitar problemas
            }

            $nonce++; // Tentar próximo valor de nonce
        }
    } else {
        echo "Não há transações na mempool para processar.";
    }
} catch (PDOException $e) {
    die("Erro ao processar as transações na mempool: " . $e->getMessage());
}
?>
