<?php
session_start();
require '../conexao.php'; // Inclui o arquivo de conexão

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador_logado = $_SESSION['user_name']; // Nome do jogador logado

// Configurações de paginação
$por_pagina = 10; // Número de itens por página
$pagina = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$pagina = max($pagina, 1); // Garante que a página não seja menor que 1
$offset = ($pagina - 1) * $por_pagina;

try {
    // Consulta para contar o total de fichas de outros jogadores
    $sql_count_outros = "
        SELECT COUNT(DISTINCT preco) AS total 
        FROM fichaspersonagens 
        WHERE situacao = 'vendendo' AND jogador != ?
    ";
    $stmt_count_outros = $pdo->prepare($sql_count_outros);
    $stmt_count_outros->execute([$jogador_logado]);
    $total_outros = $stmt_count_outros->fetch(PDO::FETCH_ASSOC)['total'];
    
    // Consulta para contar o total de fichas do jogador logado
    $sql_count_logado = "
        SELECT COUNT(DISTINCT preco) AS total 
        FROM fichaspersonagens 
        WHERE situacao = 'vendendo' AND jogador = ?
    ";
    $stmt_count_logado = $pdo->prepare($sql_count_logado);
    $stmt_count_logado->execute([$jogador_logado]);
    $total_logado = $stmt_count_logado->fetch(PDO::FETCH_ASSOC)['total'];
    
    $total_fichas = $total_outros + $total_logado;
    $total_paginas = ceil($total_fichas / $por_pagina);
    
    // Fichas de outros jogadores (com paginação)
    $sql_outros = "
        SELECT preco, COUNT(*) AS quantidade 
        FROM fichaspersonagens 
        WHERE situacao = 'vendendo' AND jogador != ? 
        GROUP BY preco 
        ORDER BY preco ASC
        LIMIT $por_pagina OFFSET $offset
    ";
    $stmt_outros = $pdo->prepare($sql_outros);
    $stmt_outros->execute([$jogador_logado]);
    $fichas_outros = $stmt_outros->fetchAll(PDO::FETCH_ASSOC);
    
    // Fichas do jogador logado (com paginação)
    $sql_logado = "
        SELECT preco, COUNT(*) AS quantidade 
        FROM fichaspersonagens 
        WHERE situacao = 'vendendo' AND jogador = ? 
        GROUP BY preco 
        ORDER BY preco ASC
        LIMIT $por_pagina OFFSET $offset
    ";
    $stmt_logado = $pdo->prepare($sql_logado);
    $stmt_logado->execute([$jogador_logado]);
    $fichas_logado = $stmt_logado->fetchAll(PDO::FETCH_ASSOC);
    
    // Combinar os resultados para exibição
    $todas_fichas = array_merge($fichas_outros, $fichas_logado);
    // Ordenar por preço (caso a paginação tenha separado)
    usort($todas_fichas, function($a, $b) {
        return $a['preco'] <=> $b['preco'];
    });
    
    // Pegar apenas os itens da página atual
    $fichas_pagina = array_slice($todas_fichas, 0, $por_pagina);
} catch (PDOException $e) {
    echo "Erro ao listar fichas: " . $e->getMessage();
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Fichas à Venda</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        .link-verde {
            text-decoration: none;
            color: green;
        }

        .link-vermelho {
            text-decoration: none;
            color: white;
            background-color: red;
            padding: 5px 10px;
            border-radius: 4px;
            display: inline-block;
            border: none;
            cursor: pointer;
            font-size: 14px;
            height: auto;
            line-height: normal;
        }

        .link-verde-button {
            text-decoration: none;
            color: white;
            background-color: green;
            padding: 5px 10px;
            border-radius: 4px;
            display: inline-block;
            font-size: 14px;
        }

        .link-vermelho:hover, .link-verde-button:hover {
            opacity: 0.8;
        }

        table {
            border-collapse: collapse;
            width: 60%;
            margin: 20px auto;
        }

        table, th, td {
            border: 1px solid white;
        }

        th, td {
            padding: 10px;
            text-align: left;
            vertical-align: middle;
            height: 25px;
        }

        th {
            background-color: #f2f2f2;
            color: black;
        }

        .btn-dashboard {
            text-decoration: none;
            color: white;
            background-color: blue;
            padding: 10px 20px;
            border-radius: 4px;
            display: inline-block;
            margin: 5px;
            min-width: 40%;
        }

        .btn-dashboard:hover {
            background-color: #45a049;
        }

        .titulo {
            text-align: center;
            font-size: 2em;
            margin: 20px 0;
        }

        .mensagem {
            text-align: center;
            color: #333;
            font-size: 1.2em;
            margin: 10px 0;
        }

        .ficha-jogador td {
            background-color: blue;
            color: white;
        }

        form {
            margin: 0;
            padding: 0;
            display: inline;
        }

        form button {
            margin: 0;
        }
        
        .paginacao {
            margin: 20px 0;
            text-align: center;
        }
        
        .paginacao a, .paginacao span {
            display: inline-block;
            padding: 8px 16px;
            margin: 0 4px;
            border: 1px solid #ddd;
            text-decoration: none;
            color: #333;
            border-radius: 4px;
        }
        
        .paginacao a:hover {
            background-color: #f2f2f2;
        }
        
        .paginacao .ativa {
            background-color: blue;
            color: white;
            border: 1px solid blue;
        }
        
        .paginacao .desabilitada {
            color: #aaa;
            pointer-events: none;
            cursor: default;
        }

        .mensagem1 {
        color: whit;
        }
    </style>
</head>
<body>
    <center>
        <img class="bn" src="../bn.png" alt=""><br><br>
        <a href="../dashboard.php" class="btn-dashboard">Menu principal</a><br><br>
        <a href="vender_fichas.php" class="btn-dashboard">Vender fichas</a><br><br>
        <div class="titulo">Fichas à Venda</div>
        <?php
        if (isset($_SESSION['msg'])) {
            echo '<p class="mensagem1">' . $_SESSION['msg'] . '</p>';
            unset($_SESSION['msg']);
        }
        ?>
    </center>
    <table>
        <tr>
            <th>Preço</th>
            <th>Quantidade</th>
            <th><center>Ações</center></th>
        </tr>
        <!-- Fichas da página atual -->
        <?php foreach ($fichas_pagina as $ficha): 
            $eh_do_jogador = in_array($ficha, $fichas_logado);
        ?>
            <tr <?= $eh_do_jogador ? 'class="ficha-jogador"' : '' ?>>
                <td>R$ <?= number_format($ficha['preco'], 2, ',', '.') ?></td>
                <td><?= $ficha['quantidade'] ?></td>
                <td><center>
                    <?php if ($eh_do_jogador): ?>
                        <form method="POST" action="cancelar_venda.php">
                            <input type="hidden" name="preco" value="<?= $ficha['preco'] ?>">
                            <button type="submit" class="link-vermelho" 
                                    onclick="return confirm('Tem certeza de que deseja apagar esta venda de fichas?');">Apagar</button>
                        </form>
                    <?php else: ?>
                        <a href="confirmar_compra.php?preco=<?= $ficha['preco'] ?>" 
                           class="link-verde-button" 
                           onclick="return confirm('Tem certeza de que deseja comprar estas fichas?');">Comprar</a>
                    <?php endif; ?>
                </center></td>
            </tr>
        <?php endforeach; ?>
    </table>
    
    <!-- Paginação -->
    <div class="paginacao">
        <?php if ($pagina > 1): ?>
            <a href="?pagina=1">&laquo; Primeira</a>
            <a href="?pagina=<?= $pagina - 1 ?>">&lsaquo; Anterior</a>
        <?php else: ?>
            <span class="desabilitada">&laquo; Primeira</span>
            <span class="desabilitada">&lsaquo; Anterior</span>
        <?php endif; ?>
        
        <?php 
        // Mostrar até 5 links de página ao redor da atual
        $inicio = max(1, $pagina - 2);
        $fim = min($total_paginas, $pagina + 2);
        
        if ($inicio > 1) {
            echo '<span>...</span>';
        }
        
        for ($i = $inicio; $i <= $fim; $i++): ?>
            <?php if ($i == $pagina): ?>
                <span class="ativa"><?= $i ?></span>
            <?php else: ?>
                <a href="?pagina=<?= $i ?>"><?= $i ?></a>
            <?php endif; ?>
        <?php endfor; ?>
        
       <?php  if ($fim < $total_paginas) {
            echo '<span>...</span>';
        }
        ?>
        
        <?php if ($pagina < $total_paginas): ?>
            <a href="?pagina=<?= $pagina + 1 ?>">Próxima &rsaquo;</a>
            <a href="?pagina=<?= $total_paginas ?>">Última &raquo;</a>
        <?php else: ?>
            <span class="desabilitada">Próxima &rsaquo;</span>
            <span class="desabilitada">Última &raquo;</span>
        <?php endif; ?>
    </div>
</body>
</html>