<?php
include 'conexao.php';

// Consulta para obter as 5 ordens de compra com maiores valores (quantidade > 0)
$query = "
    SELECT quantidade, valor 
    FROM ordens_compra 
    WHERE valor IS NOT NULL
    AND quantidade > 0  -- Filtra apenas quantidades positivas
    ORDER BY valor DESC 
    LIMIT 6
";

try {
    $result = $pdo->query($query);
    $compras = $result->fetchAll(PDO::FETCH_ASSOC);
    $rowCount = count($compras);
} catch (PDOException $e) {
    die("Erro na consulta: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Maiores Ofertas de Compra</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 10px;
            padding: 0;
            background-color: #f5f5f5;
        }
        .compras-container {
            min-width: 215px;
            max-width: 215px;
            /* Fundo Escuro Transparente */
            background-color: rgba(0, 0, 0, 0.6); 
            border: 2px solid #0000FF; /* Borda Azul Neon */
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 255, 0.1);
            overflow: hidden;
        }
        
        /* cabeçalho 
          <div class="compras-header">Ordens de compra</div>  
    */
        .compras-header {
            background-color: #000; /* Preto Sólido */
            color: white; /* Azul Neon */
            padding: 10px;
            font-size: 13px;
            text-align: center;
            font-weight: bold;
            text-transform: uppercase;
            border-bottom: 1px solid #0000FF; /* Linha separadora */
            text-shadow: 0 0 5px #0000FF;
            margin: 0; /* Remove margens externas */
            
        }
        .compra-item {
            padding: 8px 10px;
            border-bottom: 1px solid #0000FF;
            font-size: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .no-data {
            padding: 15px;
            text-align: center;
            color: #6c757d;
            font-style: italic;
        }
        .compra-quantidade {
            font-weight: bold;
            color: #007bff;
        }
        .compra-valor {
            font-weight: bold;
            color: #28a745;
        }
        .compra-badge {
            display: inline-flex;
            justify-content: center;
            align-items: center;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background-color: #343a40;
            color: white;
            font-size: 10px;
            font-weight: bold;
            margin-right: 5px;
        }
    </style>
</head>
<body>

<div class="compras-container">
  
    <?php if($rowCount > 0): ?>
       <?php foreach($compras as $compra): ?>
        <div class="compra-item">
            <div style="display: flex; align-items: center;">
                <span class="compra-badge">C</span>
                <span class="compra-quantidade"><?= htmlspecialchars($compra['quantidade']) ?>x</span>
            </div>
            <div class="compra-valor">R$ <?= number_format($compra['valor'], 2, ',', '.') ?></div>
        </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="no-data">Sem ofertas válidas</div>
    <?php endif; ?>
</div>

</body>
</html>