<?php
session_start();
require 'conexao.php';

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Definir o usuário atual
$user_name = $_SESSION['user_name'];

// Processar ação de apagar notificação
if (isset($_GET['apagar'])) {
    $id_notificacao = (int)$_GET['apagar'];
    $sqlApagar = "UPDATE notificacoes_jogo SET apg = 1 WHERE id = :id AND user2 = :user_name";
    $stmtApagar = $pdo->prepare($sqlApagar);
    $stmtApagar->bindParam(':id', $id_notificacao, PDO::PARAM_INT);
    $stmtApagar->bindParam(':user_name', $user_name, PDO::PARAM_STR);
    $stmtApagar->execute();
    
    // Recarregar a página sem parâmetros para evitar reenvio
    echo '<script>window.location.href = window.location.pathname;</script>';
    exit();
}

// Configurações de paginação
$registros_por_pagina = 10;
$pagina_atual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;

// Contar total de notificações não apagadas
$sqlCount = "SELECT COUNT(*) FROM notificacoes_jogo WHERE user2 = :user_name AND apg != 1";
$stmtCount = $pdo->prepare($sqlCount);
$stmtCount->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmtCount->execute();
$total_notificacoes = $stmtCount->fetchColumn();

$total_paginas = ceil($total_notificacoes / $registros_por_pagina);
$offset = ($pagina_atual - 1) * $registros_por_pagina;

// Consulta principal com paginação e filtro apg != 1
$sql = "SELECT * FROM notificacoes_jogo 
        WHERE user2 = :user_name AND apg != 1 
        ORDER BY dataehora DESC 
        LIMIT :offset, :limit";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
$stmt->bindParam(':limit', $registros_por_pagina, PDO::PARAM_INT);
$stmt->execute();

// Marcar notificações como lidas
$sqlUpdateVz2 = "UPDATE notificacoes_jogo SET vz2 = 1 WHERE user2 = :user_name AND apg != 1";
$stmtUpdateVz2 = $pdo->prepare($sqlUpdateVz2);
$stmtUpdateVz2->bindParam(':user_name', $user_name, PDO::PARAM_STR);
$stmtUpdateVz2->execute();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Notificações</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        .notificacoes-container {
            width: 80%;
            margin: 20px auto;
            padding: 20px;
            border-radius: 10px;
        }

        .notificacao {
            border: 4px solid #007bff;
            border-radius: 15px;
            padding: 10px;
            margin-bottom: 20px;
            word-wrap: break-word;
            cursor: pointer;
            transition: all 0.3s;
            position: relative;
        }

        .notificacao:hover {
            background-color: #f0f0f0;
        }

        .notificacao-lida {
            border: 4px solid #fff;
        }

        .pagination {
            display: flex;
            justify-content: center;
            list-style: none;
            padding: 0;
            margin-top: 20px;
        }

        .pagination a {
            padding: 8px 16px;
            margin: 0 4px;
            text-decoration: none;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        .pagination a.active {
            background-color: #007bff;
            color: white;
            border: 1px solid #007bff;
        }

        .pagination a:hover:not(.active) {
            background-color: #ddd;
        }

        .badge-contador {
            position: absolute;
            top: -10px;
            right: -10px;
            background-color: red;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 12px;
        }
    </style>
</head>
<body>
<img class="bn" src="bn.png" alt=""><br><br>
<div class="titulo">Minhas Notificações</div>
<a href="dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>

<div class="notificacoes-container">
    <?php
    if ($stmt->rowCount() > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $classe_notificacao = ($row['vz2'] == 0) ? 'notificacao' : 'notificacao notificacao-lida';
            echo '<div class="' . $classe_notificacao . '" onclick="apagarNotificacao('.$row['id'].')">';
            if ($row['vz2'] == 0) {
                echo '<span class="badge-contador">Nova</span>';
            }
            echo 'Tipo: ' . htmlspecialchars($row['tipo']) . '<br>';
            echo 'Notificação: ' . htmlspecialchars($row['notificacao']) . '<br>';
            echo 'Data & Hora: ' . htmlspecialchars($row['dataehora']) . '<br>';
            echo '</div>';
        }
        
        // Exibir paginação se houver mais de uma página
        if ($total_paginas > 1) {
            echo '<div class="pagination">';
            
            // Link para primeira página
            if ($pagina_atual > 1) {
                echo '<a href="?pagina=1">&laquo; Primeira</a>';
            }
            
            // Links numéricos
            $inicio = max(1, $pagina_atual - 2);
            $fim = min($total_paginas, $pagina_atual + 2);
            
            for ($i = $inicio; $i <= $fim; $i++) {
                if ($i == $pagina_atual) {
                    echo '<a href="?pagina='.$i.'" class="active">'.$i.'</a>';
                } else {
                    echo '<a href="?pagina='.$i.'">'.$i.'</a>';
                }
            }
            
            // Link para última página
            if ($pagina_atual < $total_paginas) {
                echo '<a href="?pagina='.$total_paginas.'">Última &raquo;</a>';
            }
            
            echo '</div>';
        }
    } else {
        echo '<p>Nenhuma notificação encontrada.</p>';
    }
    ?>
</div>

<script>
function apagarNotificacao(id) {
    if (confirm("Deseja realmente apagar esta notificação?")) {
        // Adiciona o parâmetro de página atual para manter a paginação
        var pagina = new URLSearchParams(window.location.search).get('pagina');
        var url = window.location.pathname + (pagina ? '?pagina=' + pagina + '&apagar=' + id : '?apagar=' + id);
        window.location.href = url;
    }
}
</script>

</body>
</html>