<?php
session_start();
require '../conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location:../login.php");
}

$user_id = $_SESSION['user_name'];


?>

<!DOCTYPE html>
<html>
<head>
    <title>Painel de Controle</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        .txtpadrao {
            font-size: 25px;
            /* Outros estilos aqui */
        }
    </style>
</head>
<body>
<img class="bn" src="bn.png" alt=""><br>
<br><br>
<?php


// Verifica se o formulário foi enviado via POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['vender'])) {
    $_SESSION['mensagem'] = 'Acesso inválido.';
    header('Location: mercado.php');
    exit;
}


// Verifique se um personagem foi selecionado
if (isset($_POST['vender'])) {
        $pin = $_SESSION['user_pin'];
    $postpin = htmlspecialchars($_POST['pin']);
    $personagem_id = $_POST['personagem'];
    $vendido = $_SESSION['vendido'];
  
// Verifica token CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION['mensagem'] = 'Erro de segurança: 0845. Nos contacte para saber mais';
    header('Location: mercado.php');
    exit;
}


    // Verificar PIN
 // BLOQUEIO DE PIN POR SEGURANÇA
$ip = $_SERVER['REMOTE_ADDR'];
$jogador = $_SESSION['user_name'];

// Verifica tentativas nas últimas 24h
$stmt = $pdo->prepare("
    SELECT COUNT(*) FROM tentativas_pin 
    WHERE jogador = ? AND timestamp >= NOW() - INTERVAL 24 HOUR
");
$stmt->execute([$jogador]);
$tentativas = $stmt->fetchColumn();

if ($tentativas >= 7) {
    $_SESSION['mensagem'] = "
    <div style='color: red; font-weight: bold; font-family: sans-serif; max-width: 500px; margin: auto; text-align: center; padding: 20px; border: 2px solid red; border-radius: 10px; background-color: #fff0f0;'>
        <h3>⛔ PIN Bloqueado por Segurança</h3>
        Detectamos <strong>múltiplas tentativas incorretas de PIN</strong> nas últimas 24 horas.<br><br>
        Por medida de segurança, o acesso a essa função foi temporariamente bloqueado.<br><br>
        Caso essa ação não tenha sido realizada por você, entre em contato conosco imediatamente.<br><br>
        Se foi apenas um engano, pedimos que tente novamente mais tarde.<br><br>
        <em>Nosso objetivo é garantir sua proteção.</em>
    </div>";
    header('Location: mercado.php');
    exit;
}

// Verifica se o PIN está correto
if (!password_verify($postpin, $pin)) {
    // Armazena tentativa incorreta
    $local = 'tentando_vender_personagem';
    $stmt = $pdo->prepare("
        INSERT INTO tentativas_pin (ip, jogador, local, timestamp)
        VALUES (?, ?, ?, NOW())
    ");
    $stmt->execute([$ip, $jogador, $local]);

    $_SESSION['mensagem'] = 'Erro: PIN incorreto.';
    header('Location: mercado.php');
    exit;
}

    
    // Recebe e valida inputs
$personagem_id = filter_input(INPUT_POST, 'personagem', FILTER_VALIDATE_INT);

$valor_raw = trim($_POST['valor'] ?? '');
$valor_formatado = str_replace(',', '.', $valor_raw);
$valor = filter_var($valor_formatado, FILTER_VALIDATE_FLOAT);


$pin_post = $_POST['pin'] ?? '';

if (!$personagem_id) {
    $_SESSION['mensagem'] = 'Personagem inválido.';
    header('Location: mercado.php');
    exit;
}



// Normaliza valor para float, aceita vírgula ou ponto
$valor_formatado = str_replace(',', '.', $valor_raw);
$valor = filter_var($valor_formatado, FILTER_VALIDATE_FLOAT);

if ($valor === false || $valor <= 0) {
    $_SESSION['mensagem'] = 'Valor inválido para venda.';
    header('Location: mercado.php');
    exit;
}


// Verifica personagem pertence ao jogador e não está vendendo
$sql = "SELECT * FROM personagens WHERE id = :id AND jogador = :jogador AND situacao != 'vendendo' LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->execute([':id' => $personagem_id, ':jogador' => $user_id]);
$personagem = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$personagem) {
    $_SESSION['mensagem'] = 'Personagem não encontrado ou já está à venda.';
    header('Location: mercado.php');
    exit;
}

    if ($vendido == 1) {
    echo "Parece que você já vendeu seu personagem";
  exit;
  }

    if ($personagem_id != '') {
        // Consulta SQL para selecionar os dados do personagem selecionado
        $sql = "SELECT * FROM personagens WHERE id = :personagem_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':personagem_id', $personagem_id, PDO::PARAM_INT);
        $stmt->execute();

        // Verifique se a consulta retornou resultados
        if ($stmt->rowCount() > 0) {
            // Exiba os dados do personagem em uma tabela
            echo "<div class='table-container'><table>";
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $_SESSION['local'] = $row['local'];
                $paralisado = $row['paralisado'];
                $prata = $row['prata'];
                $homens = $row['soldados'];
                $carne = $row['carne'];
                $_SESSION['carne'] = $carne;
                $madeira = $row['madeira'];
                $_SESSION['madeira'] = $madeira;
                $_SESSION['homens'] = $homens;
                $_SESSION['prata'] = $prata;
                $atk = $row['atk'];
                $_SESSION['atk'] = $atk;
                $def = $row['def'];
                $_SESSION['def'] = $def;
                $personagem = $row['personagem'];
                $_SESSION['personagem'] = $personagem;

                // Agora você pode usar $novaData em vez de $paralisado
                echo "</table></div>";
            }
        } else {
            echo "<p class='txtpadrao'>Nenhum personagem selecionado.</p><br><br>";
        }
    }
} else {
    echo "Não veio post.<br><br>";
}

$valor = $_POST['valor'];
$user_id = $_SESSION['user_name'];
// Obtém o valor de 

$user_name = $_SESSION['user_name'];

$sqlOrdemMaiorValor = "SELECT * FROM ordens_compra WHERE valor >= :valor AND user != :user_name ORDER BY valor DESC LIMIT 1";
$stmtOrdemMaiorValor = $pdo->prepare($sqlOrdemMaiorValor);
$stmtOrdemMaiorValor->bindParam(':valor', $valor, PDO::PARAM_STR);
$stmtOrdemMaiorValor->bindParam(':user_name', $user_name, PDO::PARAM_STR);

if ($stmtOrdemMaiorValor->execute()) {
    

    if ($stmtOrdemMaiorValor->rowCount() > 0) {
        //echo "tem ordem maio";
        // Encontrou uma ordem com valor maior ou igual
        $rowOrdemMaiorValor = $stmtOrdemMaiorValor->fetch(PDO::FETCH_ASSOC);
$valorordem = $rowOrdemMaiorValor['valor'];
        // Exibir os dados da ordem encontrada
        echo "<p class='txtpadrao'>Existia uma ordem de compra compativel com preço escolhido por você.<br><br>O preço era de R$ $valorordem<br><br>A transação foi concluída comsucesso.</p>";
        
        
        // Continue exibindo outras colunas, se necessário
        $idcompra = $rowOrdemMaiorValor['id'];
        $quantidadecompra = $rowOrdemMaiorValor['quantidade'];
        $valorcompra = $rowOrdemMaiorValor['valor'];
        $walletcompra = $rowOrdemMaiorValor['wallet'];
        $comprador = $rowOrdemMaiorValor['user'];

        // Finalize o script
        $personagem = $_SESSION['personagem'];
        $_SESSION['quantidadecompra'] = $quantidadecompra;
        $_SESSION['idcompra'] = $idcompra;
        // receber valor da venda mempol
        $destinatario = $_SESSION['user_wallet'];

        // Obtenha a data e hora atual no formato adequado
        $dataehora = date('Y-m-d H:i:s');

        // Crie a referência
        $referencia = "Venda do personagem $personagem na ordem.";

        // Prepare e execute a consulta de inserção na tabela mempool
        $sqlMempool = "INSERT INTO mempool (destinatario, valor, referencia, dataehora) VALUES (:destinatario, :valor, :referencia, :dataehora)";
        $stmtMempool = $pdo->prepare($sqlMempool);
        $stmtMempool->bindParam(':destinatario', $destinatario, PDO::PARAM_STR);
        $stmtMempool->bindParam(':valor', $valorcompra, PDO::PARAM_STR);
        $stmtMempool->bindParam(':referencia', $referencia, PDO::PARAM_STR);
        $stmtMempool->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);

        if ($stmtMempool->execute()) {
            // Inserido na tabela mempool com sucesso
           // echo "Inserido na tabela mempool com sucesso.";
        } else {
            echo "Erro ao inserir dados na tabela mempool: " . $stmtMempool->errorInfo()[2];
        }

    

    $personagem = $_SESSION['personagem'];

    // trocar jogador do personagem
    

    // Certifique-se de que as variáveis estejam definidas
    // Defina o valor de $comprador com o comprador correto

        // Certifique-se de que as variáveis estejam definidas
    // Defina o valor de $comprador com o comprador correto








    // tirar 1 da quantidade da ordem de vendas; chegando a 0 apagar
    $_SESSION['quantidadecompra'] = $quantidadecompra;
    $quantidadecomprar = $_SESSION['quantidadecompra'];
    $_SESSION['idcompra'] = $idcompra;
    $idcompra = $_SESSION['idcompra'];

    if ($quantidadecompra > 1) {
        // Se a quantidade é maior que 1, atualize a quantidade na tabela ordens_compra
        $sqlUpdateQuantidade = "UPDATE ordens_compra SET quantidade = quantidade - 1 WHERE id = :idcompra";
        $stmtUpdateQuantidade = $pdo->prepare($sqlUpdateQuantidade);
        $stmtUpdateQuantidade->bindParam(':idcompra', $idcompra, PDO::PARAM_INT);

        if ($stmtUpdateQuantidade->execute()) {
            // Atualizado com sucesso, você pode adicionar código adicional aqui, se necessário
        } else {
            echo "Erro ao atualizar a quantidade: " . $stmtUpdateQuantidade->errorInfo()[2];
        }
    } elseif ($quantidadecompra == 1) {
        // Se a quantidade é igual a 1, exclua a linha na tabela ordens_compra
        $sqlDeleteOrdemCompra = "DELETE FROM ordens_compra WHERE id = :idcompra";
        $stmtDeleteOrdemCompra = $pdo->prepare($sqlDeleteOrdemCompra);
        $stmtDeleteOrdemCompra->bindParam(':idcompra', $idcompra, PDO::PARAM_INT);

        if ($stmtDeleteOrdemCompra->execute()) {
            // Linha excluída com sucesso, você pode adicionar código adicional aqui, se necessário
        } else {
            echo "Erro ao excluir a linha: " . $stmtDeleteOrdemCompra->errorInfo()[2];
        }
    } else {
        echo "Valor de quantidade para tirar inválido.";
    }

    // criar notificação ao comprador
    
// Suponha que você já tenha estabelecido a conexão com o banco de dados aqui

// Defina os parâmetros
$tipo = "compra através da sua ordem de compra de R$ $valorcompra";
$notificacao = "O personagem $personagem foi comprado através da sua ordem de compra.";
$user1 = $user_name;
$user2 = $comprador;
$dataehora = date('Y-m-d H:i:s');
$vz1 = 0;
$vz2 = 0;

// Prepare a consulta SQL
$sql = "INSERT INTO notificacoes_sis (tipo, notificacao, user1, user2, dataehora, vz1, vz2) VALUES (:tipo, :notificacao, :user1, :user2, :dataehora, :vz1, :vz2)";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':tipo', $tipo, PDO::PARAM_STR);
$stmt->bindParam(':notificacao', $notificacao, PDO::PARAM_STR);
$stmt->bindParam(':user1', $user1, PDO::PARAM_STR);
$stmt->bindParam(':user2', $user2, PDO::PARAM_STR);
$stmt->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);
$stmt->bindParam(':vz1', $vz1, PDO::PARAM_INT);
$stmt->bindParam(':vz2', $vz2, PDO::PARAM_INT);

// Execute a consulta
if ($stmt->execute()) {
 //   echo "Notificação inserida com sucesso!";
} else {
    echo "Erro ao inserir a notificação: " . $stmt->errorInfo()[2];
}




// Prepare e execute a consulta de atualização na tabela personagens
    $sqlUpdatePersonagem = "UPDATE personagens SET jogador = :comprador WHERE personagem = :personagem";
    $stmtUpdatePersonagem = $pdo->prepare($sqlUpdatePersonagem);
    $stmtUpdatePersonagem->bindParam(':comprador', $comprador, PDO::PARAM_STR);
    $stmtUpdatePersonagem->bindParam(':personagem', $personagem, PDO::PARAM_STR);

    if ($stmtUpdatePersonagem->execute()) {
        // Atualizado na tabela personagens com sucesso
        // echo "Personagem atualizado com sucesso.";
    } else {
        echo "Erro ao atualizar o personagem: " . $stmtUpdatePersonagem->errorInfo()[2];
    }
    
    $_SESSION['vendido'] = "1";
    
    
    
    
    $quantidade = 1; // Substitua 2 pelo valor desejado
$preco = $valorcompra; // Substitua 10 pelo valor desejado
$dataehora = date('Y-m-d H:i:s'); // Obtém a data e hora atual no formato adequado

$sqlInserirVenda = "INSERT INTO vendas (quantidade, preco, dataehora) VALUES (:quantidade, :preco, :dataehora)";
$stmtInserirVenda = $pdo->prepare($sqlInserirVenda);
$stmtInserirVenda->bindParam(':quantidade', $quantidade, PDO::PARAM_INT); // Use PDO::PARAM_INT para valores inteiros
$stmtInserirVenda->bindParam(':preco', $preco, PDO::PARAM_STR);
$stmtInserirVenda->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);

if ($stmtInserirVenda->execute()) {
    // echo "Inserido na tabela vendas com sucesso.";
} else {
    echo "Erro ao inserir na tabela vendas do grafico: " . $stmtInserirVenda->errorInfo()[2];
}

    
    
    echo '<a href="ordens_venda.php"><button class="btnmenu">Ordens de venda</button></a><br><br>';
    echo '<br><br>';
    echo '<a href="../dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>';

    
    
    exit;
   // header("Location: ordenscompra.php");
    // fechar if tem ordem maior 
    } else {
   //     echo "n tem maior// alguma variável não está definida.";
    }
    
    // fecha if xecultou teve resultados (qu emngloba Se teve ou não ordens de valor maior)
   //  
} else {
    // echo "menor";
    // Não encontrou nenhuma ordem com valor maior ou igual
    echo "Não há ordens com valor maior ou igual a $valor.";

    
}

if (isset($_POST['vender'])) {
    $jogador = $_SESSION['user_name'];

    $dataehora = date('Y-m-d H:i:s'); // Obtém a data e hora atual no formato adequado

    // Atualize a coluna 'local' na tabela 'personagens' para o novo valor
}

// Consultar a tabela ordens_venda para obter a ordem com valor maior ou igual

// Verifique se existe algum personagem igual a $personagem na tabela ordem_vendas
$sql = "SELECT * FROM ordem_vendas WHERE personagem = :personagem";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    echo "<p class='txtpadrao'>Este personagem já foi anunciado no mercado, aguarde alguém compra-lo. <br><br>Você também pode tirar seu personagem do mercado, a hora que quiser.</p>";
    echo '<br><br>';
    echo '<a href="ordens_venda.php"><button class="btnmenu">Ordens de venda</button></a><br><br>';
    echo '<br><br>';
    echo '<a href="../dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>';

    exit;

} else {
    // Personagem não encontrado na tabela ordem_vendas
    // Faça o que você precisa fazer se o personagem não existe
   // echo "nn  tem esse personagem vendendo";
}

$sql = "INSERT INTO ordem_vendas (jogador, personagem, valor, dataehora) VALUES (:jogador, :personagem, :valor, :dataehora)";

// Preparar a consulta
$stmt = $pdo->prepare($sql);

// Vincular os parâmetros
$stmt->bindParam(':jogador', $jogador, PDO::PARAM_STR);
$stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);
$stmt->bindParam(':valor', $valor, PDO::PARAM_STR);
$stmt->bindParam(':dataehora', $dataehora, PDO::PARAM_STR);

// Executar a consulta
if ($stmt->execute()) {
    echo "<p class='txtpadrao'>Seu personagem $personagem, foi anunciado no mercado a um preço de R$ $valor. Aguarde alguém compra-lo. <br><br>Você também pode tirar seu personagem do mercado a hora que quiser.</p>";
    echo '<br><br>';
    echo '<a href="ordens_venda.php"><button class="btnmenu">Ordens de venda</button></a><br><br>';
    echo '<br><br>';
    echo '<a href="../dashboard.php"><button class="btnmenu">Menu principal</button></a><br><br>';

      // header("Location: ../dashboardmed.php");

} else {
    echo "Erro ao inserir os dados: " . $stmt->errorInfo()[2];

}

$situacao = "vendendo";

$sql = "UPDATE personagens SET situacao = :situacao WHERE id = :personagem_id";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':situacao', $situacao, PDO::PARAM_STR);
$stmt->bindParam(':personagem_id', $personagem_id, PDO::PARAM_INT);

if ($stmt->execute()) {
    // echo "atualizo";
} else {
    echo "<p class='txtpadrao'>Erro ao atualizar situação do personagem para vendendo.</p>";
}
?>

