<?php
include 'conexao.php';

// Consulta para obter as 5 ordens de compra com maiores valores (quantidade > 0)
$query = "
    SELECT quantidade, valor 
    FROM ordens_compra 
    WHERE valor IS NOT NULL
    AND quantidade > 0  -- Filtra apenas quantidades positivas
    ORDER BY valor DESC 
    LIMIT 5
";

try {
    $result = $pdo->query($query);
    $compras = $result->fetchAll(PDO::FETCH_ASSOC);
    $rowCount = count($compras);
} catch (PDOException $e) {
    die("Erro na consulta: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Maiores Ofertas de Compra</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 10px;
            padding: 0;
            background-color: #f5f5f5;
        }
        .compras-container {
            min-width: 265px;
            max-width: 265px;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .compras-header {
            background-color: #343a40;
            color: white;
            padding: 10px;
            font-size: 14px;
            text-align: center;
        }
        .compra-item {
            padding: 8px 10px;
            border-bottom: 1px solid #eee;
            font-size: 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .no-data {
            padding: 15px;
            text-align: center;
            color: #6c757d;
            font-style: italic;
        }
        .compra-quantidade {
            font-weight: bold;
            color: #007bff;
        }
        .compra-valor {
            font-weight: bold;
            color: #dc3545;
        }
        .compra-badge {
            display: inline-flex;
            justify-content: center;
            align-items: center;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background-color: #343a40;
            color: white;
            font-size: 10px;
            font-weight: bold;
            margin-right: 5px;
        }
    </style>
</head>
<body>

<div class="compras-container">
    <div class="compras-header">Ordens de compra</div>
    
    <?php if($rowCount > 0): ?>
        <?php foreach($compras as $compra): ?>
        <div class="compra-item">
            <div style="display: flex; align-items: center;">
                <span class="compra-badge">C</span>
                <span class="compra-quantidade"><?= htmlspecialchars($compra['quantidade']) ?>x</span>
            </div>
            <div class="compra-valor">R$ <?= number_format($compra['valor'], 2, ',', '.') ?></div>
        </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="no-data">Sem ofertas válidas</div>
    <?php endif; ?>
</div>

</body>
</html>