<?php
session_start();
require '../conexao.php';

if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$_SESSION['msg'] = "";
$_SESSION['msg2'] = "";

$user_id = $_SESSION['user_name'];
$user_name = $_SESSION['user_name'];
$_SESSION['vendido'] = "0";

try {
    $wallet = $_SESSION['user_wallet'];

    // Consulta de saldo enviado (remetente) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_enviado FROM mempool WHERE remetente = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $saldo_enviado = $result['total_enviado'];

    // Consulta de saldo recebido (destinatário) na mempool
    $stmt = $pdo->prepare("SELECT SUM(valor) AS total_recebido FROM mempool WHERE destinatario = :wallet");
    $stmt->bindParam(':wallet', $wallet);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $saldo_recebido = $result['total_recebido'];

    // Saldo na carteira
    $saldo_carteira = bcsub($saldo_recebido, $saldo_enviado, 2);
    $zeroreais = "0.00";
    $saldo_carteira = max($saldo_carteira, $zeroreais);

    $cor_saldo_carteira = $saldo_carteira >= 0 ? 'darkgreen' : 'darkred';
    $_SESSION['latillas'] = $saldo_carteira;
    $_SESSION['saldolivre'] = $saldo_carteira;
    $_SESSION['saldolivre2'] = $saldo_carteira;

} catch (PDOException $e) {
    $saldo_carteira = "Erro na consulta: " . $e->getMessage();
    $cor_saldo_carteira = 'darkred';
    $saldo_livre = "Erro na consulta: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Mercado - Mavilla</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
    .select40 {
    width: 40%;
    }
     footer {
      background-color: #000000;
      color: var(--light-text);
      text-align: center;
      padding: 15px;
      margin-top: 30px;
      border-top: 2px solid var(--primary);
    }
    </style>
</head>
<body>
<img class="bn" src="../bn.png" alt=""><br><br>
<a href="../dashboard.php"><button class="btnmenu">Menu princiapl</button></a><br><br>

<div class="titulo">Mercado Mavilla</div>
   

<div class="cont">
<div class="titulo">Gráfico de preços do NFT</div>
    <?php include('../grafico.php'); ?>
</div>
<a href="../graficow.php"><button class="btnmenu">Analisar melhor o gráfico</button></a>
<br><br><hr><hr><br>

    <center>
        <?php
        if (isset($_SESSION['mensagem'])) {
            $mensagem_class = strpos($_SESSION['mensagem'], 'Erro') !== false ? 'mensagem erro' : 'mensagem sucesso';
            echo '<p class="' . $mensagem_class . '">' . $_SESSION['mensagem'] . '</p>';
            unset($_SESSION['mensagem']);
        }
        ?>
    </center>

<?php
$jogador = $_SESSION['user_name'];
 // Calcula o total de fichas do jogador
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ?");
        $stmt->execute([$jogador]);
        $totalFichas = $stmt->fetchColumn();
        ?>
<div class="titulo">
    Fichas</div>
    <div class="saldos">
        <b>
            <span style="color: <?php echo $cor_saldo_carteira; ?>"><?php echo "<p class='txtpadrao'> $totalFichas</p>"; ?></span>
        </b>
    </div>

    <div class="titulo">
    Saldo em dinheiro</div>
    <div class="saldos">
        <b>
            <span style="color: <?php echo $cor_saldo_carteira; ?>"><?php echo "<p class='txtpadrao'>R$ $saldo_carteira</p>"; ?></span>
        </b>
    </div>

    

   

    <div class="titulo">Enviar dinheiro</div>
    <form action="envio.php" method="post">
        <input type="text" class="inputpadrao" id="destinatario" placeholder="Destinatário" name="destinatario" required>
        <br><br>
        <input type="text" class="inputpadrao" id="moneyInput" placeholder="Valor" name="valor" required oninput="formatCurrency(this)">
        <br><br>
          <input type="password" class="inputpadrao" placeholder="PIN de 4 dígitos" name="pin" maxlength="4" required><br><br>
                  <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>"><br>
        <input type="submit" class="btn" value="Enviar R$">
    </form>

    <br>
    <a href="../recibos.php"><button class="btnmenu">Meus recebimentos em dinheiro</button></a>
<br><br>

   
    <br><br><hr><hr><br>


    <div class="titulo">Vender personagem</div>
    
    <?php
// Busca personagens do jogador que não estão à venda
$vendendo = 'vendendo';
$sql = "SELECT * FROM personagens WHERE jogador = :user_id AND situacao != :vendendo";
$stmt = $pdo->prepare($sql);
$stmt->execute([':user_id' => $user_id, ':vendendo' => $vendendo]);
$personagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Gerar token CSRF simples para o formulário
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];
?>
<?php
if (count($personagens) === 0) {
    echo "<p>Você não possui personagens disponíveis para venda.</p>";
} else {
    echo "<form action='venderpersonagem.php' method='POST'>";
    echo "<select class='select40' name='personagem' required>";
    echo "<option value='' disabled selected>Selecione um personagem</option>";
    foreach ($personagens as $p) {
        echo "<option value='" . intval($p['id']) . "'>" . htmlspecialchars($p['personagem']) . "</option>";
    }
    echo "</select><br><br>";

    echo '<input type="text" id="moneyInput2" name="valor" placeholder="Valor (ex: 100.00)" oninput="formatCurrency(this)" required><br><br>';

    echo '<input type="password" class="inputpadrao" placeholder="Código PIN" name="pin" maxlength="4" required><br><br>';

    // Token CSRF
    echo "<input type='hidden' name='csrf_token' value='" . $csrf_token . "'>";

    echo "<input class='btnpadrao' name='vender' type='submit' onclick=\"return confirm('Tem certeza que deseja vender o seu personagem?');\" value='Vender'>";

    echo "</form>";
}


    ?>
<br><br>
<a href="ordens_venda.php"><button class="btnmenu">Personagens a venda</button></a>


<br><br><hr><hr><br>

<h1>Criar Ordem de Compra</h1>
    <form action="criarordemcompra.php" method="POST">
            <input type="number" class="inputpadrao" name="quantidade" placeholder="Quantidade" id="quantidade" required><br><br>

          

<input type="text" name ="valor" class="inputpadrao" id="moneyInput3"  placeholder="Valor" name="" required oninput="formatCurrency(this)">

        <br><br>
<input type="password" class="inputpadrao" placeholder="Código PIN" name="pin" maxlength="4" required><br><br>

<input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">

          
          <script>
    const moneyInput = document.getElementById("moneyInput");

    moneyInput.addEventListener("input", function() {
      let inputValue = moneyInput.value;

      // Remover caracteres não numéricos, exceto o ponto decimal
      inputValue = inputValue.replace(/[^0-9]/g, '');

      // Adicionar zeros à esquerda para garantir que sempre tenhamos centavos
      while (inputValue.length < 2) {
        inputValue = '0' + inputValue;
      }

      // Dividir o valor em parte inteira e parte decimal
      const integerPart = parseInt(inputValue.slice(0, -2)) || 0;
      const decimalPart = inputValue.slice(-2);

      // Formatar o valor no formato de dinheiro
      const formattedValue = `${integerPart}.${decimalPart}`;

      // Atualizar o valor do input
      moneyInput.value = formattedValue;
    });
  </script>
        <!-- Input Hidden -->
        <input type="hidden" name="userwallet" value="<?php echo $wallet; ?>">
        <input type="hidden" name="user_id" value="<?php echo $user_id; ?>">
        
        <!-- Input Hidden com a data e hora atual -->
        <input type="hidden" name="dataehora" value="<?php echo date('Y-m-d H:i:s'); ?>">

        <button class="btnmenu" type="submit" name="criarOrdem" onclick="return confirm('Tem certeza de que deseja criar essa ordem de compra?');">Criar Ordem</button>
    </form>

<br><br>

        <a href="ordenscompra.php"><button class="btnmenu">Ordens de compra</button></a>

        

<br><br><hr><hr><br>

<h1>Fichas</h1>
<a href="../fichas/vender_fichas.php"><button class="btnmenu">Vender ficha/s</button></a><br><br>

<a href="../fichas/listavendadefichas.php"><button class="btnmenu">Lista de venda de ficha/s</button></a><br><br><br><br>

<hr><hr>
 <footer>⚔️ RPG Era Medieval ⚔️</footer><br><br>
</body>


<script>
    const moneyInput1 = document.getElementById("moneyInput");
    const moneyInput2 = document.getElementById("moneyInput2");
    const moneyInput3 = document.getElementById("moneyInput3");

    moneyInput1.addEventListener("input", function() {
      let inputValue = moneyInput1.value;

      // Resto do seu código para moneyInput1
      inputValue = inputValue.replace(/[^0-9]/g, '');
      while (inputValue.length < 2) {
        inputValue = '0' + inputValue;
      }
      const integerPart = parseInt(inputValue.slice(0, -2)) || 0;
      const decimalPart = inputValue.slice(-2);
      const formattedValue = `${integerPart}.${decimalPart}`;
      moneyInput1.value = formattedValue;
    });


moneyInput3.addEventListener("input", function() {
      let inputValue = moneyInput3.value;

      // Resto do seu código para moneyInput3
      inputValue = inputValue.replace(/[^0-9]/g, '');
      while (inputValue.length < 2) {
        inputValue = '0' + inputValue;
      }
      const integerPart = parseInt(inputValue.slice(0, -2)) || 0;
      const decimalPart = inputValue.slice(-2);
      const formattedValue = `${integerPart}.${decimalPart}`;
      moneyInput3.value = formattedValue;
    });

    moneyInput2.addEventListener("input", function() {
      let inputValue = moneyInput2.value;

      // Resto do seu código para moneyInput2
      inputValue = inputValue.replace(/[^0-9]/g, '');
      while (inputValue.length < 2) {
        inputValue = '0' + inputValue;
      }
      const integerPart = parseInt(inputValue.slice(0, -2)) || 0;
      const decimalPart = inputValue.slice(-2);
      const formattedValue = `${integerPart}.${decimalPart}`;
      moneyInput2.value = formattedValue;
    });

    
  </script>
</html>