<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_wallet'])) {
    die("Erro: Você precisa estar logado.");
}

require_once '../conexao.php';

$user_wallet = $_SESSION['user_wallet'];
$user_id = $_SESSION['user_id'];

// Verifica se a requisição é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Erro: Acesso inválido.");
}

// Verifica CSRF token
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    die("Erro de segurança: token CSRF inválido.");
}

// Verifica se os campos obrigatórios foram enviados
$campos = ['destinatario', 'valor', 'pin'];
foreach ($campos as $campo) {
    if (empty($_POST[$campo])) {
        $_SESSION['mensagem'] = "Erro: Campo '$campo' é obrigatório.";
        header('Location: mercado.php');
        exit;
    }
}

// Limpa e valida os dados
$destinatario = preg_replace('/[^a-zA-Z0-9]/', '', $_POST['destinatario']);
$valor = filter_var(str_replace(',', '.', $_POST['valor']), FILTER_VALIDATE_FLOAT);
$postpin = $_POST['pin'];
$dataehora = date('Y-m-d H:i:s');

// Validação do valor
if ($valor === false || $valor <= 0) {
    $_SESSION['mensagem'] = "Erro: Valor inválido.";
    header('Location: mercado.php');
    exit;
}

// Verifica se está enviando para si mesmo
if ($destinatario === $user_wallet) {
    $_SESSION['mensagem'] = "Erro: Não é permitido enviar para si mesmo.";
    header('Location: ../mercado.php');
    exit;
}

// Verifica saldo suficiente
if (!isset($_SESSION['saldolivre']) || $valor > $_SESSION['saldolivre']) {
    $_SESSION['mensagem'] = "Erro: Saldo insuficiente.";
    header('Location: ../mercado.php');
    exit;
}

// Proteção contra brute-force (últimas 24h)
$ip = $_SERVER['REMOTE_ADDR'];

$stmt = $pdo->prepare("SELECT tentativas24h FROM tentativas_pin 
                       WHERE jogador = :jogador 
                       ORDER BY timestamp DESC 
                       LIMIT 1");
$stmt->execute([':jogador' => $user_wallet]);
$t = $stmt->fetchColumn();

if ($t !== false && $t >= 7) {
    $_SESSION['mensagem'] = "Erro: Muitas tentativas inválidas hoje. Tente novamente mais tarde.";
    header('Location: mercado.php');
    exit;
}

// Busca PIN no banco
$stmt = $pdo->prepare("SELECT pin FROM usersblock WHERE wallet = :wallet LIMIT 1");
$stmt->execute([':wallet' => $user_wallet]);
$hashpin = $stmt->fetchColumn();

if (!$hashpin || !password_verify($postpin, $hashpin)) {
    // Registra tentativa de pin inválida
// Pegue o nome do jogador da sessão (exemplo)
$jogador = isset($_SESSION['user_name']) ? $_SESSION['user_name'] : 'Desconhecido';

// Depois, na hora de registrar a tentativa de PIN errado:
$stmt = $pdo->prepare("INSERT INTO tentativas_pin (ip, jogador, local, timestamp) 
                       VALUES (:ip, :jogador, :local, NOW())");
$stmt->execute([
    ':ip' => $ip,
    ':jogador' => $jogador,
    ':local' => 'envio_dinheiro'
]);

    $_SESSION['mensagem'] = "Erro: PIN incorreto.";
    header('Location: mercado.php');
    exit;
}

// Verifica se o destinatário existe
$stmt = $pdo->prepare("SELECT COUNT(*) FROM usersblock WHERE wallet = :destinatario");
$stmt->execute([':destinatario' => $destinatario]);

if ($stmt->fetchColumn() == 0) {
    $_SESSION['mensagem'] = "Erro: Destinatário não encontrado.";
    header('Location: mercado.php');
    exit;
}

// Gera hash e link únicos
$hash = hash('sha256', $destinatario . $user_wallet . $dataehora . $valor . bin2hex(random_bytes(10)));
$link = bin2hex(random_bytes(25));

// Insere a transação na mempool
$stmt = $pdo->prepare("INSERT INTO mempool (destinatario, remetente, dataehora, valor, hash, link)
    VALUES (:destinatario, :remetente, :dataehora, :valor, :hash, :link)");

$stmt->execute([
    ':destinatario' => $destinatario,
    ':remetente' => $user_wallet,
    ':dataehora' => $dataehora,
    ':valor' => $valor,
    ':hash' => $hash,
    ':link' => $link
]);

// Mensagem de sucesso
$_SESSION['mensagem'] = "Transação de R$ " . number_format($valor, 2, ',', '.') . " enviada com sucesso!";
$_SESSION['linkhash'] = $link;

// Invalida CSRF token após uso
unset($_SESSION['csrf_token']);

header('Location: mercado.php');
exit;
?>
