<?php
session_start();
require '../conexao.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador_logado = $_SESSION['user_name'];
$preco = (float)$_GET['preco'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
$pin = $_SESSION['user_pin'];
    $postpin = $_POST['pin'];

    // Verificar PIN
    if (!password_verify($postpin, $pin)) {
        
       // echo 'Erro: PIN incorreto.';
       $_SESSION['msg'] = 'Erro: PIN incorreto, saimos da página por segurança';
         header("Location: listavendadefichas.php");
        exit;
    }

    $quantidade = (int)$_POST['quantidade'];

    // VERIFICAÇÃO DA QUANTIDADE DISPONÍVEL (NOVA FUNCIONALIDADE)
    $sql_verifica = "SELECT COUNT(*) AS total FROM fichaspersonagens 
                    WHERE situacao = 'vendendo' AND preco = ? AND jogador != ?";
    $stmt_verifica = $pdo->prepare($sql_verifica);
    $stmt_verifica->execute([$preco, $jogador_logado]);
    $disponivel = $stmt_verifica->fetch(PDO::FETCH_ASSOC);

    if ($quantidade > $disponivel['total']) {
        $_SESSION['msg'] = "ERRO: Só existem {$disponivel['total']} fichas disponíveis (você tentou comprar $quantidade).";
        header("Location: listavendadefichas.php");
        exit();
    }

    // PROCESSAMENTO DA COMPRA (CÓDIGO ORIGINAL FUNCIONAL)
    $valor_total = $quantidade * $preco;

    try {
        $pdo->beginTransaction();

        // PRIMEIRO: Obter o vendedor das fichas que serão compradas
        $sql_vendedor = "SELECT jogador FROM fichaspersonagens 
                        WHERE situacao = 'vendendo' AND preco = ? AND jogador != ? 
                        LIMIT 1";
        $stmt_vendedor = $pdo->prepare($sql_vendedor);
        $stmt_vendedor->execute([$preco, $jogador_logado]);
        $vendedor_info = $stmt_vendedor->fetch(PDO::FETCH_ASSOC);
        $vendedor = $vendedor_info['jogador'];

        // SEGUNDO: Atualizar as fichas
        $sql = "UPDATE fichaspersonagens 
               SET situacao = '1', jogador = ? 
               WHERE situacao = 'vendendo' AND preco = ? 
               LIMIT $quantidade";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$jogador_logado, $preco]);

        // TERCEIRO: Registrar na tabela vendas (NOVO)
        $sql_vendas = "INSERT INTO vendas 
                      (quantidade, preco, dataehora, vendedor, comprador, mediacao) 
                      VALUES 
                      (?, ?, NOW(), ?, ?, 'Compra Direta')";
        $stmt_vendas = $pdo->prepare($sql_vendas);
        $stmt_vendas->execute([$quantidade, $preco, $vendedor, $jogador_logado]);

        // QUARTO: Registrar no infossistema (NOVO)
        $info = "Compra de $quantidade fichas por R$ ".number_format($preco,2,',','.')." (Total: R$ ".number_format($valor_total,2,',','.').")";
        $sql_info = "INSERT INTO infossistema 
                    (informacao, p1, origem, dataehora) 
                    VALUES 
                    (?, ?, 'compra_fichas', NOW())";
        $stmt_info = $pdo->prepare($sql_info);
        $stmt_info->execute([$info, $jogador_logado]);

        $pdo->commit();
        $_SESSION['msg'] = "Compra realizada com sucesso! $quantidade fichas por R$ ".number_format($preco,2,',','.')." (Total: R$ ".number_format($valor_total,2,',','.').")";
        header("Location: listavendadefichas.php");
        exit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro ao realizar compra: " . $e->getMessage();
        header("Location: listavendadefichas.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Confirmar Compra</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 30px auto;
            padding: 25px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        a {
    text-decoration: none;
}
        h1.titulo {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 25px;
            font-size: 28px;
        }
        .price-info {
            text-align: center;
            font-size: 18px;
            margin: 20px 0;
            color: #3498db;
            font-weight: bold;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        .form-group {
            display: flex;
            flex-direction: column;
        }
        label {
            margin-bottom: 8px;
            font-weight: bold;
            color: #2c3e50;
        }
        input[type="number"] {
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
        }
        button[type="submit"] {
            background-color: #27ae60;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
             min-width: 20%;
        }
        button[type="submit"]:hover {
            background-color: #219653;
        }
.button {
            background-color: #27ae60;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
            min-width: 35%;
        }
        .button:hover {
            background-color: #219653;
        }

.buttoncancelar {
            background-color: red;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
            min-width: 35%;
        }
.buttonmenu {
            background-color: blue;
            color: white;
            padding: 12px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
            min-width: 35%;
        }
        .center {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="titulo">Confirmar Compra</h1>
        <p class="price-info">Preço por ficha: R$ <?= number_format($preco, 2, ',', '.') ?></p>
        
        <form method="POST"><center>
            <div class="form-group"><center>
                <label for="quantidade">Quantidade desejada:</label>
                <input type="number" id="quantidade" name="quantidade" min="1" required>

                <br><br>
        <input type="password" class="inputpadrao" placeholder="Código PIN" name="pin" maxlength="4" required><br><br>
 
           </center> </div>
            
            <div class="center">
                <button type="submit">Confirmar Compra</button>
            </div>
       </center> </form>
       <br><br><center>
<a href="listavendadefichas.php" class="buttoncancelar"><stronger>Cancelar compra</stronger></a><br><br><br><br>
    <a href="../dashboard.php" class="buttonmenu" style="margin-right: 10px;">Menu principal</a>
 <br><br>
    </div>

    <!-- Botões de navegação -->

</body>
</html>