<?php
session_start();
include 'conexao.php'; // Inclui o arquivo de conexão

// Verifica se as variáveis de sessão necessárias estão definidas
if (!isset($_SESSION['personagem'], $_SESSION['local'], $_SESSION['user_name'])) {
    die("Variáveis de sessão necessárias não estão definidas.");
}

// Busca a data do último movimento do personagem
$stmt = $pdo->prepare("SELECT data, destino FROM movpersonagens 
                      WHERE personagem = :personagem 
                      ORDER BY data DESC LIMIT 1");
$stmt->bindParam(':personagem', $_SESSION['personagem']);
$stmt->execute();
$ultimo_movimento = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$ultimo_movimento) {
    die("Histórico de movimento do personagem não encontrado.");
}

// Verifica se o destino do último movimento corresponde ao local atual
if ($ultimo_movimento['destino'] !== $_SESSION['local']) {
    die("O personagem não está no local correto.");
}

$data_chegada = $ultimo_movimento['data'];


// TESTE - Buscar personagens no mesmo local
$stmt_personagens = $pdo->prepare("SELECT personagem, local, situacao 
                                  FROM personagens 
                                  WHERE local = :local
                                  AND situacao NOT IN ('escondido', 'fugindo e reagrupando soldados')
                                  AND id != :meu_personagem
                                  ORDER BY personagem");
$stmt_personagens->bindParam(':local', $_SESSION['local']);
$stmt_personagens->bindParam(':meu_personagem', $_SESSION['personagem']);
$stmt_personagens->execute();
$personagens_local = $stmt_personagens->fetchAll(PDO::FETCH_ASSOC);

// Exibir resultados do teste
// echo "<h1>Teste de Personagens no Local</h1>";
// echo "<p>Local atual: " . htmlspecialchars($_SESSION['local']) . "</p>";
// echo "<p>Meu personagem ID: " . htmlspecialchars($_SESSION['personagem']) . "</p>";
// echo "<h2>Personagens encontrados:</h2>";

 // if (empty($personagens_local)) {
 //   echo "<p>Nenhum personagem encontrado neste local.</p>";
// } else {
//    echo "<ul>";
 //   foreach ($personagens_local as $personagem) {
   //     echo "<li>";
 //       echo "Nome: " . htmlspecialchars($personagem['personagem']) . " | ";
     //   echo "Local: " . htmlspecialchars($personagem['local']) . " | ";
     //   echo "Situação: " . htmlspecialchars($personagem['situacao']);
       // echo "</li>";}
// echo "</ul>"; }

// Mostrar a consulta SQL para debug
// echo "<h3>Consulta SQL executada:</h3>"; echo "<pre>SELECT personagem, local, situacao FROM personagens WHERE local = '" . htmlspecialchars($_SESSION['local']) . "' AND situacao NOT IN ('escondido', 'fugindo e reagrupando soldados') AND id != " . htmlspecialchars($_SESSION['personagem']) . " ORDER BY personagem</pre>";

// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxx

// Processar envio de nova mensagem
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fala'])) {
    // Verifica se já passou 10 segundos desde a última mensagem
    if (isset($_SESSION['ultima_mensagem']) && (time() - $_SESSION['ultima_mensagem']) < 10) {
        die("Aguarde 10 segundos entre mensagens.");
    }
    
    $fala = trim($_POST['fala']);
    $direcionada = isset($_POST['direcionada']) ? trim($_POST['direcionada']) : null;
    
    if (!empty($fala)) {
        // Busca o nome do personagem pelo ID da sessão
        $stmt = $pdo->prepare("SELECT personagem FROM personagens WHERE id = :id");
        $stmt->bindParam(':id', $_SESSION['personagem'], PDO::PARAM_INT);
        $stmt->execute();
        $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$resultado) {
            die("Erro: Personagem não encontrado!");
        }
        
        $nome_personagem = $resultado['personagem'];
        
        // Insere a mensagem no chat
        $stmt = $pdo->prepare("INSERT INTO chatpersonagens 
                              (personagem, jogador, fala, direcionada, local) 
                              VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([
            $nome_personagem,
            $_SESSION['user_name'],
            $fala,
            $direcionada,
            $_SESSION['local']
        ]);
        
        // Registra o momento da última mensagem
        $_SESSION['ultima_mensagem'] = time();
        
        // Redireciona para evitar reenvio ao atualizar a página
        header("Location: ".$_SERVER['PHP_SELF']);
        exit();
    }
}

// Recuperar mensagens do chat (apenas após a chegada no local)
$stmt = $pdo->prepare("SELECT personagem, fala, direcionada, dataehora 
                       FROM chatpersonagens 
                       WHERE local = :local 
                       AND dataehora >= :data_chegada
                       ORDER BY dataehora ASC");
$stmt->execute([
    ':local' => $_SESSION['local'],
    ':data_chegada' => $data_chegada
]);
$mensagens = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Busca o nome do personagem atual para verificação de mensagens
$stmt = $pdo->prepare("SELECT personagem FROM personagens WHERE id = :id");
$stmt->bindParam(':id', $_SESSION['personagem'], PDO::PARAM_INT);
$stmt->execute();
$meu_personagem = $stmt->fetch(PDO::FETCH_ASSOC);
$nome_personagem_atual = $meu_personagem['personagem'];
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat do RPG</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #000;
            color: #fff;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        .container {
            width: 100%;
            max-width: 400px;
            padding: 10px;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        h1 {
            color: #00f;
            text-align: center;
            font-size: 1.2em;
            margin: 5px 0;
            width: 100%;
        }
        .chat-container {
            background-color: #111;
            border: 2px solid #00f;
            border-radius: 5px;
            padding: 8px;
            margin-bottom: 10px;
            height: 250px;
            overflow-y: auto;
            display: flex;
            flex-direction: column-reverse;
            width: 100%;
        }
        .mensagens-wrapper {
            display: flex;
            flex-direction: column;
            width: 100%;
        }
        .mensagem {
            margin-bottom: 8px;
            padding: 6px;
            border-bottom: 1px solid #333;
            font-size: 0.9em;
            text-align: center;
            width: 100%;
        }
        .mensagem .cabecalho {
            font-weight: bold;
            margin-bottom: 3px;
            color: #00f;
            text-align: center;
        }
        .mensagem .texto {
            text-align: center;
            margin: 5px 0;
        }
        .mensagem .data {
            font-size: 0.7em;
            color: #666;
            text-align: center;
        }
        .mensagem.propria {
            background-color: rgba(0, 0, 255, 0.1);
            border-left: 3px solid #00f;
        }
        .mensagem.privada {
            background-color: rgba(255, 255, 0, 0.1);
            border-left: 3px solid #ff0;
        }
        .mensagem.privada .cabecalho {
            color: #ff0;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 8px;
            width: 100%;
            align-items: center;
        }
        textarea {
            height: 50px;
            padding: 8px;
            border-radius: 5px;
            border: 1px solid #00f;
            background-color: #222;
            color: #fff;
            font-size: 0.9em;
            resize: none;
            width: 95%;
            text-align: center;
        }
        select {
            padding: 6px;
            border-radius: 5px;
            border: 1px solid #00f;
            background-color: #222;
            color: #fff;
            font-size: 0.9em;
            width: 95%;
            text-align: center;
        }
        button {
            padding: 8px;
            background-color: #00f;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 0.9em;
            width: 95%;
        }
        button:hover {
            background-color: #0055ff;
        }
        .aviso-tempo {
            color: #f00;
            font-size: 0.8em;
            margin-top: 3px;
            text-align: center;
            width: 100%;
        }
    </style>
    <script>
        // Função para manter o scroll no final do chat
        function manterScrollNoFinal() {
            const container = document.querySelector('.chat-container');
            container.scrollTop = container.scrollHeight;
        }
        
        // Executa quando a página carrega
        window.onload = manterScrollNoFinal;
    </script>
</head>
<body>
    <div class="container">
        <h1>Chat - <?php echo htmlspecialchars($_SESSION['local']); ?></h1>
        
        <div class="chat-container">
            <div class="mensagens-wrapper">
                <?php foreach ($mensagens as $msg): 
                    $isPropria = ($msg['personagem'] === $nome_personagem_atual);
                    $isPrivada = (!empty($msg['direcionada']));
                    
                    // Verifica se a mensagem privada é para o personagem atual
                    $mostrarMensagem = true;
                    if ($isPrivada && $msg['direcionada'] !== $nome_personagem_atual && !$isPropria) {
                        $mostrarMensagem = false;
                    }
                    
                    if ($mostrarMensagem):
                ?>
                    <div class="mensagem <?php echo $isPropria ? 'propria' : ''; ?> <?php echo $isPrivada ? 'privada' : ''; ?>">
                        <div class="cabecalho">
                            <?php echo htmlspecialchars($msg['personagem']); ?>
                            <?php if ($isPrivada): ?>
                                <span style="font-style: italic; font-weight: normal;">
                                    (para <?php echo htmlspecialchars($msg['direcionada']); ?>)
                                </span>
                            <?php endif; ?>
                        </div>
                        <div class="texto"><?php echo nl2br(htmlspecialchars($msg['fala'])); ?></div>
                        <div class="data"><?php echo date('d/m/Y H:i', strtotime($msg['dataehora'])); ?></div>
                    </div>
                <?php 
                    endif;
                endforeach; 
                ?>
            </div>
        </div>
        
        <form method="POST" action="">
            <textarea name="fala" placeholder="Digite sua mensagem..." required></textarea>
            <select name="direcionada">
                <option value="">Todos (mensagem pública)</option>
                <?php foreach ($personagens_local as $personagem): ?>
                    <option value="<?php echo htmlspecialchars($personagem['personagem']); ?>">
                        <?php echo htmlspecialchars($personagem['personagem']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="submit">Enviar</button>
            <?php if (isset($_SESSION['ultima_mensagem']) && (time() - $_SESSION['ultima_mensagem']) < 10): ?>
                <div class="aviso-tempo">
                    Aguarde <?php echo 10 - (time() - $_SESSION['ultima_mensagem']); ?> segundos para enviar outra mensagem.
                </div>
            <?php endif; ?>
        </form>
    </div>
</body>
</html>