<?php
session_start();
require 'conexao.php';

// Verifique se o usuário não está logado
if (!isset($_SESSION['user_id'])) {
    // Redirecione-o para a página de login
    header("Location: login.php");
}

if (isset($_POST['contratar'])) {
$personagem = $_SESSION['personagem'];
$qnt = $_POST['quantidade'];
$valor = "80";
$qntxvalor = bcmul($qnt, $valor);

$prata = $_SESSION['prata'];
$maxqnt = $prata / $valor;
$maxqntint = floor($maxqnt);

if ($qntxvalor > $prata) {
$_SESSION['msg'] = "Você não pode contratar $qnt soldados, suas pratas dão pra contratar no máximo $maxqntint";
header("Location: dashboardmed.php");
exit;
}



if ($qntxvalor < $prata) {
$_SESSION['msg'] = "Você contratou $qnt soldados, por $qntxvalor prata/s.";

$soldados = $_SESSION['soldados'];
$soldadostotal = ($soldados + $qnt);
$nvsaldo = $prata - $qntxvalor;

// Atualize a coluna 'local' na tabela 'personagens' para o novo valor
    $sql = "UPDATE personagens SET prata = :nvsaldo, soldados = :soldadostotal WHERE id = :personagem";
    $stmt = $pdo->prepare($sql);
    
$stmt->bindParam(':nvsaldo', $nvsaldo, PDO::PARAM_STR);
    
    $stmt->bindParam(':soldadostotal', $soldadostotal, PDO::PARAM_STR);
    
    $stmt->bindParam(':personagem', $personagem, PDO::PARAM_STR);
    if ($stmt->execute()) {
    header("Location: dashboardmed.php");
exit;
} else {
    echo "Erro ao entrar em serviço.";
}
}
}

?>